# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from SerialPort.idl.

use strict;

package Raritan::RPC::serial::SerialPort;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "serial.SerialPort:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::serial::SerialPort::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant SUCCESS => 0;

use constant ERR_INVALID_VALUE => 1;

use constant ERR_NO_MODEM => 2;

use Raritan::RPC::serial::SerialPort::ConsoleSettings;

sub getConsoleSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getConsoleSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::serial::SerialPort::ConsoleSettings::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::serial::SerialPort::ConsoleSettings;

sub setConsoleSettings($$) {
    my ($self, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = Raritan::RPC::serial::SerialPort::ConsoleSettings::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setConsoleSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::serial::SerialPort::State;

sub getState($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getState', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::serial::SerialPort::State::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}


sub getGsmModem($$) {
    my ($self, $modem) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getGsmModem', $args);
    $$modem = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'modem'}, 'serial.GsmModem');
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('serial.SerialPort', 1, 0, 0, 'Raritan::RPC::serial::SerialPort');
1;
