# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from DoorAccessControl.idl.

use strict;

package Raritan::RPC::smartlock::DoorAccessControl::DoorAccessRule;

use Raritan::RPC::smartlock::DoorAccessControl::KeypadCondition;
use Raritan::RPC::smartlock::DoorAccessControl::CardCondition;
use Raritan::RPC::smartlock::DoorAccessControl::KeypadCondition;
use Raritan::RPC::smartlock::DoorAccessControl::PeriodicTimeCondition;
use Raritan::RPC::smartlock::DoorAccessControl::CardCondition;
use Raritan::RPC::smartlock::DoorAccessControl::AbsoluteTimeCondition;

sub encode {
    my ($in) = @_;
    my $encoded = {};
    $encoded->{'name'} = "$in->{'name'}";
    $encoded->{'doorHandleLocks'} = [];
    for (my $i0 = 0; $i0 <= $#{$in->{'doorHandleLocks'}}; $i0++) {
        $encoded->{'doorHandleLocks'}->[$i0] = Raritan::RPC::ObjectCodec::encode($in->{'doorHandleLocks'}->[$i0]);
    }
    $encoded->{'cardCondition1'} = Raritan::RPC::smartlock::DoorAccessControl::CardCondition::encode($in->{'cardCondition1'});
    $encoded->{'cardCondition2'} = Raritan::RPC::smartlock::DoorAccessControl::CardCondition::encode($in->{'cardCondition2'});
    $encoded->{'keypadCondition1'} = Raritan::RPC::smartlock::DoorAccessControl::KeypadCondition::encode($in->{'keypadCondition1'});
    $encoded->{'keypadCondition2'} = Raritan::RPC::smartlock::DoorAccessControl::KeypadCondition::encode($in->{'keypadCondition2'});
    $encoded->{'conditionsTimeout'} = 1 * $in->{'conditionsTimeout'};
    $encoded->{'absoluteTime'} = Raritan::RPC::smartlock::DoorAccessControl::AbsoluteTimeCondition::encode($in->{'absoluteTime'});
    $encoded->{'periodicTime'} = Raritan::RPC::smartlock::DoorAccessControl::PeriodicTimeCondition::encode($in->{'periodicTime'});
    return $encoded;
}

sub decode {
    my ($agent, $in) = @_;
    my $decoded = {};
    $decoded->{'name'} = $in->{'name'};
    $decoded->{'doorHandleLocks'} = [];
    for (my $i0 = 0; $i0 <= $#{$in->{'doorHandleLocks'}}; $i0++) {
        $decoded->{'doorHandleLocks'}->[$i0] = Raritan::RPC::ObjectCodec::decode($agent, $in->{'doorHandleLocks'}->[$i0], 'peripheral.DeviceSlot');
    }
    $decoded->{'cardCondition1'} = Raritan::RPC::smartlock::DoorAccessControl::CardCondition::decode($agent, $in->{'cardCondition1'});
    $decoded->{'cardCondition2'} = Raritan::RPC::smartlock::DoorAccessControl::CardCondition::decode($agent, $in->{'cardCondition2'});
    $decoded->{'keypadCondition1'} = Raritan::RPC::smartlock::DoorAccessControl::KeypadCondition::decode($agent, $in->{'keypadCondition1'});
    $decoded->{'keypadCondition2'} = Raritan::RPC::smartlock::DoorAccessControl::KeypadCondition::decode($agent, $in->{'keypadCondition2'});
    $decoded->{'conditionsTimeout'} = $in->{'conditionsTimeout'};
    $decoded->{'absoluteTime'} = Raritan::RPC::smartlock::DoorAccessControl::AbsoluteTimeCondition::decode($agent, $in->{'absoluteTime'});
    $decoded->{'periodicTime'} = Raritan::RPC::smartlock::DoorAccessControl::PeriodicTimeCondition::decode($agent, $in->{'periodicTime'});
    return $decoded;
}

1;
