# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from StorageManager.idl.

use strict;

package Raritan::RPC::webcam::StorageManager_1_0_1;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "webcam.StorageManager:1.0.1";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::webcam::StorageManager_1_0_1::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant NO_ERROR => 0;

use constant ERR_INVALID_PARAM => 1;

use constant ERR_INIT_IN_PROGRESS => 2;

use constant ERR_ALREADY_RUNNING => 3;

use constant ERR_TOO_LARGE => 4;


sub getSupportedStorageTypes($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSupportedStorageTypes', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = $rsp->{'_ret_'}->[$i0];
    }
    return $_ret_;
}

use Raritan::RPC::webcam::StorageManager_1_0_1::StorageInformation;

sub getInformation($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getInformation', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::webcam::StorageManager_1_0_1::StorageInformation::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::webcam::StorageManager_1_0_1::StorageSettings;

sub getSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::webcam::StorageManager_1_0_1::StorageSettings::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::webcam::StorageManager_1_0_1::StorageSettings;

sub setSettings($$) {
    my ($self, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = Raritan::RPC::webcam::StorageManager_1_0_1::StorageSettings::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::webcam::Image_2_0_0;

sub addImage($$$$) {
    my ($self, $webcam, $image, $index) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'webcam'} = Raritan::RPC::ObjectCodec::encode($webcam);
    $args->{'image'} = Raritan::RPC::webcam::Image_2_0_0::encode($image);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'addImage', $args);
    $$index = $rsp->{'index'};
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}


sub removeImages($$$$$) {
    my ($self, $webcam, $start, $count, $direction) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'webcam'} = Raritan::RPC::ObjectCodec::encode($webcam);
    $args->{'start'} = 1 * $start;
    $args->{'count'} = 1 * $count;
    $args->{'direction'} = 1 * $direction;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'removeImages', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::webcam::StorageManager_1_0_1::ImageStorageMetaData;

sub getMetaData($$$$$$) {
    my ($self, $webcam, $start, $count, $direction, $meta) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'webcam'} = Raritan::RPC::ObjectCodec::encode($webcam);
    $args->{'start'} = 1 * $start;
    $args->{'count'} = 1 * $count;
    $args->{'direction'} = 1 * $direction;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getMetaData', $args);
    $$meta = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'meta'}}; $i0++) {
        $$meta->[$i0] = Raritan::RPC::webcam::StorageManager_1_0_1::ImageStorageMetaData::decode($agent, $rsp->{'meta'}->[$i0]);
    }
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::webcam::StorageManager_1_0_1::StorageImage;

sub getImages($$$$$$) {
    my ($self, $webcam, $start, $count, $direction, $image) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'webcam'} = Raritan::RPC::ObjectCodec::encode($webcam);
    $args->{'start'} = 1 * $start;
    $args->{'count'} = 1 * $count;
    $args->{'direction'} = 1 * $direction;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getImages', $args);
    $$image = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'image'}}; $i0++) {
        $$image->[$i0] = Raritan::RPC::webcam::StorageManager_1_0_1::StorageImage::decode($agent, $rsp->{'image'}->[$i0]);
    }
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::webcam::StorageManager_1_0_1::Activity;

sub getActivities($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getActivities', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::webcam::StorageManager_1_0_1::Activity::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}


sub startActivity($$$$) {
    my ($self, $webcam, $count, $interval) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'webcam'} = Raritan::RPC::ObjectCodec::encode($webcam);
    $args->{'count'} = 1 * $count;
    $args->{'interval'} = 1 * $interval;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'startActivity', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}


sub stopActivity($$) {
    my ($self, $webcam) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'webcam'} = Raritan::RPC::ObjectCodec::encode($webcam);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'stopActivity', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('webcam.StorageManager', 1, 0, 1, 'Raritan::RPC::webcam::StorageManager_1_0_1');
1;
