# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from WebcamManager.idl.

use strict;

package Raritan::RPC::webcam::WebcamManager_2_0_2;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "webcam.WebcamManager:2.0.2";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::webcam::WebcamManager_2_0_2::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant NO_ERROR => 0;

use constant ERR_INVALID_PARAM => 1;


sub getWebcams($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getWebcams', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'_ret_'}->[$i0], 'webcam.Webcam');
    }
    return $_ret_;
}


sub getChannel($$$$) {
    my ($self, $webcam, $clientType, $channel) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'webcam'} = Raritan::RPC::ObjectCodec::encode($webcam);
    $args->{'clientType'} = "$clientType";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getChannel', $args);
    $$channel = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'channel'}, 'webcam.Channel');
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}


sub getChannels($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getChannels', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'_ret_'}->[$i0], 'webcam.Channel');
    }
    return $_ret_;
}

sub removeClientType($$) {
    my ($self, $clientType) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'clientType'} = "$clientType";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'removeClientType', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub getClientTypes($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getClientTypes', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = $rsp->{'_ret_'}->[$i0];
    }
    return $_ret_;
}


sub getClientTypePriorities($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getClientTypePriorities', $args);
    my $_ret_;
    $_ret_ = {};
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        my $key0 = $rsp->{'_ret_'}->[$i0]->{'key'};
        my $value0 = $rsp->{'_ret_'}->[$i0]->{'value'};
        $_ret_->{$key0} = $value0;
    }
    return $_ret_;
}


sub setClientTypePriorities($$) {
    my ($self, $priorities) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'priorities'} = [];
    foreach my $key0 (keys %{$priorities}) {
        my $value0 = $priorities->{$key0};
        my $elem0 = {};
        $elem0->{'key'} = "$key0";
        $elem0->{'value'} = 1 * $value0;
        push(@{$args->{'priorities'}}, $elem0);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setClientTypePriorities', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}


sub getWebcamPriorities($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getWebcamPriorities', $args);
    my $_ret_;
    $_ret_ = {};
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        my $key0 = $rsp->{'_ret_'}->[$i0]->{'key'};
        my $value0 = $rsp->{'_ret_'}->[$i0]->{'value'};
        $_ret_->{$key0} = $value0;
    }
    return $_ret_;
}


sub setWebcamPriorities($$) {
    my ($self, $priorities) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'priorities'} = [];
    foreach my $key0 (keys %{$priorities}) {
        my $value0 = $priorities->{$key0};
        my $elem0 = {};
        $elem0->{'key'} = "$key0";
        $elem0->{'value'} = 1 * $value0;
        push(@{$args->{'priorities'}}, $elem0);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setWebcamPriorities', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('webcam.WebcamManager', 2, 0, 2, 'Raritan::RPC::webcam::WebcamManager_2_0_2');
1;
