# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "AssetStripConfig.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.assetmgrmodel

import raritan.rpc.event


# interface
class AssetStripConfig(Interface):
    idlType = "assetmgrmodel.AssetStripConfig:1.0.1"

    # enumeration
    class ScanMode(Enumeration):
        idlType = "assetmgrmodel.AssetStripConfig_1_0_1.ScanMode:1.0.0"
        values = ["SCANMODE_DISABLED", "SCANMODE_BOTH"]

    ScanMode.SCANMODE_DISABLED = ScanMode(0)
    ScanMode.SCANMODE_BOTH = ScanMode(1)

    # enumeration
    class NumberingMode(Enumeration):
        idlType = "assetmgrmodel.AssetStripConfig_1_0_1.NumberingMode:1.0.0"
        values = ["TOP_DOWN", "BOTTOM_UP"]

    NumberingMode.TOP_DOWN = NumberingMode(0)
    NumberingMode.BOTTOM_UP = NumberingMode(1)

    # enumeration
    class Orientation(Enumeration):
        idlType = "assetmgrmodel.AssetStripConfig_1_0_1.Orientation:1.0.0"
        values = ["TOP_CONNECTOR", "BOTTOM_CONNECTOR"]

    Orientation.TOP_CONNECTOR = Orientation(0)
    Orientation.BOTTOM_CONNECTOR = Orientation(1)

    # enumeration
    class LEDOperationMode(Enumeration):
        idlType = "assetmgrmodel.AssetStripConfig_1_0_1.LEDOperationMode:1.0.0"
        values = ["LED_OPERATION_MANUAL", "LED_OPERATION_AUTO"]

    LEDOperationMode.LED_OPERATION_MANUAL = LEDOperationMode(0)
    LEDOperationMode.LED_OPERATION_AUTO = LEDOperationMode(1)

    # enumeration
    class LEDMode(Enumeration):
        idlType = "assetmgrmodel.AssetStripConfig_1_0_1.LEDMode:1.0.0"
        values = ["LED_MODE_ON", "LED_MODE_OFF", "LED_MODE_BLINK_FAST", "LED_MODE_BLINK_SLOW"]

    LEDMode.LED_MODE_ON = LEDMode(0)
    LEDMode.LED_MODE_OFF = LEDMode(1)
    LEDMode.LED_MODE_BLINK_FAST = LEDMode(2)
    LEDMode.LED_MODE_BLINK_SLOW = LEDMode(3)

    # structure
    class LEDColor(Structure):
        idlType = "assetmgrmodel.AssetStripConfig_1_0_1.LEDColor:1.0.0"
        elements = ["r", "g", "b"]

        def __init__(self, r=0, g=0, b=0):
            typecheck.is_int(r, AssertionError)
            typecheck.is_int(g, AssertionError)
            typecheck.is_int(b, AssertionError)

            self.r = r
            self.g = g
            self.b = b

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                r = json['r'] if 'r' in json or not useDefaults else 0,
                g = json['g'] if 'g' in json or not useDefaults else 0,
                b = json['b'] if 'b' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['r'] = self.r
            json['g'] = self.g
            json['b'] = self.b
            return json

    # structure
    class StripSettings(Structure):
        idlType = "assetmgrmodel.AssetStripConfig_1_0_1.StripSettings:1.0.0"
        elements = ["rackUnitCount", "name", "scanMode", "defaultColorConnected", "defaultColorDisconnected", "numberingMode", "numberingOffset", "orientation"]

        def __init__(self, rackUnitCount=0, name="", scanMode=None, defaultColorConnected=None, defaultColorDisconnected=None, numberingMode=None, numberingOffset=0, orientation=None):
            if scanMode is None:
                scanMode = raritan.rpc.assetmgrmodel.AssetStripConfig.ScanMode.SCANMODE_DISABLED
            if defaultColorConnected is None:
                defaultColorConnected = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor()
            if defaultColorDisconnected is None:
                defaultColorDisconnected = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor()
            if numberingMode is None:
                numberingMode = raritan.rpc.assetmgrmodel.AssetStripConfig.NumberingMode.TOP_DOWN
            if orientation is None:
                orientation = raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation.TOP_CONNECTOR
            typecheck.is_int(rackUnitCount, AssertionError)
            if not typecheck._is_int(name):
                typecheck.is_string(name, AssertionError)
            typecheck.is_enum(scanMode, raritan.rpc.assetmgrmodel.AssetStripConfig.ScanMode, AssertionError)
            typecheck.is_struct(defaultColorConnected, raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor, AssertionError)
            typecheck.is_struct(defaultColorDisconnected, raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor, AssertionError)
            typecheck.is_enum(numberingMode, raritan.rpc.assetmgrmodel.AssetStripConfig.NumberingMode, AssertionError)
            typecheck.is_int(numberingOffset, AssertionError)
            typecheck.is_enum(orientation, raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation, AssertionError)

            self.rackUnitCount = rackUnitCount
            self.name = name
            self.scanMode = scanMode
            self.defaultColorConnected = defaultColorConnected
            self.defaultColorDisconnected = defaultColorDisconnected
            self.numberingMode = numberingMode
            self.numberingOffset = numberingOffset
            self.orientation = orientation

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                rackUnitCount = json['rackUnitCount'] if 'rackUnitCount' in json or not useDefaults else 0,
                name = json['name'] if 'name' in json or not useDefaults else "",
                scanMode = raritan.rpc.assetmgrmodel.AssetStripConfig.ScanMode.decode(json['scanMode']) if 'scanMode' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.ScanMode.SCANMODE_DISABLED,
                defaultColorConnected = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor.decode(json['defaultColorConnected'], agent, useDefaults=useDefaults) if 'defaultColorConnected' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor(),
                defaultColorDisconnected = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor.decode(json['defaultColorDisconnected'], agent, useDefaults=useDefaults) if 'defaultColorDisconnected' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor(),
                numberingMode = raritan.rpc.assetmgrmodel.AssetStripConfig.NumberingMode.decode(json['numberingMode']) if 'numberingMode' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.NumberingMode.TOP_DOWN,
                numberingOffset = json['numberingOffset'] if 'numberingOffset' in json or not useDefaults else 0,
                orientation = raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation.decode(json['orientation']) if 'orientation' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation.TOP_CONNECTOR,
            )
            return obj

        def encode(self):
            json = {}
            json['rackUnitCount'] = self.rackUnitCount
            json['name'] = str(self.name)
            json['scanMode'] = raritan.rpc.assetmgrmodel.AssetStripConfig.ScanMode.encode(self.scanMode)
            json['defaultColorConnected'] = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor.encode(self.defaultColorConnected)
            json['defaultColorDisconnected'] = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor.encode(self.defaultColorDisconnected)
            json['numberingMode'] = raritan.rpc.assetmgrmodel.AssetStripConfig.NumberingMode.encode(self.numberingMode)
            json['numberingOffset'] = self.numberingOffset
            json['orientation'] = raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation.encode(self.orientation)
            return json

    # structure
    class RackUnitSettings(Structure):
        idlType = "assetmgrmodel.AssetStripConfig_1_0_1.RackUnitSettings:1.0.0"
        elements = ["opmode", "mode", "color", "name"]

        def __init__(self, opmode=None, mode=None, color=None, name=""):
            if opmode is None:
                opmode = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDOperationMode.LED_OPERATION_MANUAL
            if mode is None:
                mode = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDMode.LED_MODE_ON
            if color is None:
                color = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor()
            typecheck.is_enum(opmode, raritan.rpc.assetmgrmodel.AssetStripConfig.LEDOperationMode, AssertionError)
            typecheck.is_enum(mode, raritan.rpc.assetmgrmodel.AssetStripConfig.LEDMode, AssertionError)
            typecheck.is_struct(color, raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor, AssertionError)
            if not typecheck._is_int(name):
                typecheck.is_string(name, AssertionError)

            self.opmode = opmode
            self.mode = mode
            self.color = color
            self.name = name

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                opmode = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDOperationMode.decode(json['opmode']) if 'opmode' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.LEDOperationMode.LED_OPERATION_MANUAL,
                mode = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDMode.decode(json['mode']) if 'mode' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.LEDMode.LED_MODE_ON,
                color = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor.decode(json['color'], agent, useDefaults=useDefaults) if 'color' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor(),
                name = json['name'] if 'name' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['opmode'] = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDOperationMode.encode(self.opmode)
            json['mode'] = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDMode.encode(self.mode)
            json['color'] = raritan.rpc.assetmgrmodel.AssetStripConfig.LEDColor.encode(self.color)
            json['name'] = str(self.name)
            return json

    # value object
    class StripSettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "assetmgrmodel.AssetStripConfig_1_0_1.StripSettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettings()
            if newSettings is None:
                newSettings = raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettings()
            typecheck.is_struct(oldSettings, raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldSettings = raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettings(),
                newSettings = raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettingsChangedEvent, self).listElements()
            return elements

    # value object
    class RackUnitSettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "assetmgrmodel.AssetStripConfig_1_0_1.RackUnitSettingsChangedEvent:1.0.0"

        def __init__(self, rackUnitNumber=0, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings()
            if newSettings is None:
                newSettings = raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings()
            typecheck.is_int(rackUnitNumber, AssertionError)
            typecheck.is_struct(oldSettings, raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings, AssertionError)

            self.rackUnitNumber = rackUnitNumber
            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettingsChangedEvent, self).encode()
            json['rackUnitNumber'] = self.rackUnitNumber
            json['oldSettings'] = raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                rackUnitNumber = json['rackUnitNumber'] if 'rackUnitNumber' in json or not useDefaults else 0,
                oldSettings = raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings(),
                newSettings = raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["rackUnitNumber", "oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettingsChangedEvent, self).listElements()
            return elements

    class _getStripSettings(Interface.Method):
        name = 'getStripSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettings, DecodeException)
            return _ret_

    class _setStripSettings(Interface.Method):
        name = 'setStripSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.assetmgrmodel.AssetStripConfig.StripSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getRackUnitSettings(Interface.Method):
        name = 'getRackUnitSettings'

        @staticmethod
        def encode(rackUnitNumber):
            typecheck.is_int(rackUnitNumber, AssertionError)
            args = {}
            args['rackUnitNumber'] = rackUnitNumber
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            settings = raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings.decode(rsp['settings'], agent, useDefaults=useDefaults)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_struct(settings, raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings, DecodeException)
            return (_ret_, settings)

    class _getAllRackUnitSettings(Interface.Method):
        name = 'getAllRackUnitSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings, DecodeException)
            return _ret_

    class _setRackUnitSettings(Interface.Method):
        name = 'setRackUnitSettings'

        @staticmethod
        def encode(rackUnitNumber, settings):
            typecheck.is_int(rackUnitNumber, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings, AssertionError)
            args = {}
            args['rackUnitNumber'] = rackUnitNumber
            args['settings'] = raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setMultipleRackUnitSettings(Interface.Method):
        name = 'setMultipleRackUnitSettings'

        @staticmethod
        def encode(settings):
            args = {}
            args['settings'] = [dict(
                key = k,
                value = raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings.encode(v))
                for k, v in settings.items()]
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(AssetStripConfig, self).__init__(target, agent)
        self.getStripSettings = AssetStripConfig._getStripSettings(self)
        self.setStripSettings = AssetStripConfig._setStripSettings(self)
        self.getRackUnitSettings = AssetStripConfig._getRackUnitSettings(self)
        self.getAllRackUnitSettings = AssetStripConfig._getAllRackUnitSettings(self)
        self.setRackUnitSettings = AssetStripConfig._setRackUnitSettings(self)
        self.setMultipleRackUnitSettings = AssetStripConfig._setMultipleRackUnitSettings(self)

#
# Section generated by IdlC from "AssetStrip.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.assetmgrmodel

import raritan.rpc.event

import raritan.rpc.idl


# interface
class AssetStrip(Interface):
    idlType = "assetmgrmodel.AssetStrip:2.0.6"

    NO_ERROR = 0

    ERR_INVALID_PARAM = 1

    ERR_NO_SUCH_OBJECT = 2

    ERR_NOT_SUPPORTED = 3

    ERR_OPERATION_FAILED = 4

    MAIN_STRIP_COLUMN = 0

    # enumeration
    class State(Enumeration):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.State:1.0.0"
        values = ["DISCONNECTED", "FIRMWARE_UPDATE", "UNSUPPORTED", "AVAILABLE"]

    State.DISCONNECTED = State(0)
    State.FIRMWARE_UPDATE = State(1)
    State.UNSUPPORTED = State(2)
    State.AVAILABLE = State(3)

    # enumeration
    class TagType(Enumeration):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.TagType:1.0.0"
        values = ["SINGLE", "EXTENSION", "NONE"]

    TagType.SINGLE = TagType(0)
    TagType.EXTENSION = TagType(1)
    TagType.NONE = TagType(2)

    # enumeration
    class CascadeState(Enumeration):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.CascadeState:1.0.0"
        values = ["CASCADE_ACTIVE", "CASCADE_FIRMWARE_UPDATE"]

    CascadeState.CASCADE_ACTIVE = CascadeState(0)
    CascadeState.CASCADE_FIRMWARE_UPDATE = CascadeState(1)

    # structure
    class DeviceInfo(Structure):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.DeviceInfo:1.0.0"
        elements = ["deviceId", "hardwareId", "protocolVersion", "bootVersion", "appVersion", "orientationSensAvailable", "isCascadable", "rackUnitCountConfigurable"]

        def __init__(self, deviceId=0, hardwareId=0, protocolVersion=0, bootVersion=0, appVersion=0, orientationSensAvailable=False, isCascadable=False, rackUnitCountConfigurable=False):
            typecheck.is_int(deviceId, AssertionError)
            typecheck.is_int(hardwareId, AssertionError)
            typecheck.is_int(protocolVersion, AssertionError)
            typecheck.is_int(bootVersion, AssertionError)
            typecheck.is_int(appVersion, AssertionError)
            typecheck.is_bool(orientationSensAvailable, AssertionError)
            typecheck.is_bool(isCascadable, AssertionError)
            typecheck.is_bool(rackUnitCountConfigurable, AssertionError)

            self.deviceId = deviceId
            self.hardwareId = hardwareId
            self.protocolVersion = protocolVersion
            self.bootVersion = bootVersion
            self.appVersion = appVersion
            self.orientationSensAvailable = orientationSensAvailable
            self.isCascadable = isCascadable
            self.rackUnitCountConfigurable = rackUnitCountConfigurable

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                deviceId = json['deviceId'] if 'deviceId' in json or not useDefaults else 0,
                hardwareId = json['hardwareId'] if 'hardwareId' in json or not useDefaults else 0,
                protocolVersion = json['protocolVersion'] if 'protocolVersion' in json or not useDefaults else 0,
                bootVersion = json['bootVersion'] if 'bootVersion' in json or not useDefaults else 0,
                appVersion = json['appVersion'] if 'appVersion' in json or not useDefaults else 0,
                orientationSensAvailable = json['orientationSensAvailable'] if 'orientationSensAvailable' in json or not useDefaults else False,
                isCascadable = json['isCascadable'] if 'isCascadable' in json or not useDefaults else False,
                rackUnitCountConfigurable = json['rackUnitCountConfigurable'] if 'rackUnitCountConfigurable' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['deviceId'] = self.deviceId
            json['hardwareId'] = self.hardwareId
            json['protocolVersion'] = self.protocolVersion
            json['bootVersion'] = self.bootVersion
            json['appVersion'] = self.appVersion
            json['orientationSensAvailable'] = self.orientationSensAvailable
            json['isCascadable'] = self.isCascadable
            json['rackUnitCountConfigurable'] = self.rackUnitCountConfigurable
            return json

    # structure
    class StripInfo(Structure):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.StripInfo:1.0.0"
        elements = ["maxMainTagCount", "maxBladeTagCount", "mainTagCount", "bladeTagCount", "bladeOverflow", "rackUnitCount", "componentCount", "cascadeState"]

        def __init__(self, maxMainTagCount=0, maxBladeTagCount=0, mainTagCount=0, bladeTagCount=0, bladeOverflow=False, rackUnitCount=0, componentCount=0, cascadeState=None):
            if cascadeState is None:
                cascadeState = raritan.rpc.assetmgrmodel.AssetStrip.CascadeState.CASCADE_ACTIVE
            typecheck.is_int(maxMainTagCount, AssertionError)
            typecheck.is_int(maxBladeTagCount, AssertionError)
            typecheck.is_int(mainTagCount, AssertionError)
            typecheck.is_int(bladeTagCount, AssertionError)
            typecheck.is_bool(bladeOverflow, AssertionError)
            typecheck.is_int(rackUnitCount, AssertionError)
            typecheck.is_int(componentCount, AssertionError)
            typecheck.is_enum(cascadeState, raritan.rpc.assetmgrmodel.AssetStrip.CascadeState, AssertionError)

            self.maxMainTagCount = maxMainTagCount
            self.maxBladeTagCount = maxBladeTagCount
            self.mainTagCount = mainTagCount
            self.bladeTagCount = bladeTagCount
            self.bladeOverflow = bladeOverflow
            self.rackUnitCount = rackUnitCount
            self.componentCount = componentCount
            self.cascadeState = cascadeState

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                maxMainTagCount = json['maxMainTagCount'] if 'maxMainTagCount' in json or not useDefaults else 0,
                maxBladeTagCount = json['maxBladeTagCount'] if 'maxBladeTagCount' in json or not useDefaults else 0,
                mainTagCount = json['mainTagCount'] if 'mainTagCount' in json or not useDefaults else 0,
                bladeTagCount = json['bladeTagCount'] if 'bladeTagCount' in json or not useDefaults else 0,
                bladeOverflow = json['bladeOverflow'] if 'bladeOverflow' in json or not useDefaults else False,
                rackUnitCount = json['rackUnitCount'] if 'rackUnitCount' in json or not useDefaults else 0,
                componentCount = json['componentCount'] if 'componentCount' in json or not useDefaults else 0,
                cascadeState = raritan.rpc.assetmgrmodel.AssetStrip.CascadeState.decode(json['cascadeState']) if 'cascadeState' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStrip.CascadeState.CASCADE_ACTIVE,
            )
            return obj

        def encode(self):
            json = {}
            json['maxMainTagCount'] = self.maxMainTagCount
            json['maxBladeTagCount'] = self.maxBladeTagCount
            json['mainTagCount'] = self.mainTagCount
            json['bladeTagCount'] = self.bladeTagCount
            json['bladeOverflow'] = self.bladeOverflow
            json['rackUnitCount'] = self.rackUnitCount
            json['componentCount'] = self.componentCount
            json['cascadeState'] = raritan.rpc.assetmgrmodel.AssetStrip.CascadeState.encode(self.cascadeState)
            return json

    # structure
    class TagInfo(Structure):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.TagInfo:1.0.0"
        elements = ["rackUnitNumber", "slotNumber", "familyDesc", "rawId", "programmable"]

        def __init__(self, rackUnitNumber=0, slotNumber=0, familyDesc="", rawId="", programmable=False):
            typecheck.is_int(rackUnitNumber, AssertionError)
            typecheck.is_int(slotNumber, AssertionError)
            if not typecheck._is_int(familyDesc):
                typecheck.is_string(familyDesc, AssertionError)
            if not typecheck._is_int(rawId):
                typecheck.is_string(rawId, AssertionError)
            typecheck.is_bool(programmable, AssertionError)

            self.rackUnitNumber = rackUnitNumber
            self.slotNumber = slotNumber
            self.familyDesc = familyDesc
            self.rawId = rawId
            self.programmable = programmable

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                rackUnitNumber = json['rackUnitNumber'] if 'rackUnitNumber' in json or not useDefaults else 0,
                slotNumber = json['slotNumber'] if 'slotNumber' in json or not useDefaults else 0,
                familyDesc = json['familyDesc'] if 'familyDesc' in json or not useDefaults else "",
                rawId = json['rawId'] if 'rawId' in json or not useDefaults else "",
                programmable = json['programmable'] if 'programmable' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['rackUnitNumber'] = self.rackUnitNumber
            json['slotNumber'] = self.slotNumber
            json['familyDesc'] = str(self.familyDesc)
            json['rawId'] = str(self.rawId)
            json['programmable'] = self.programmable
            return json

    # structure
    class RackUnitInfo(Structure):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.RackUnitInfo:1.0.0"
        elements = ["rackUnitNumber", "rackUnitPosition", "type", "size", "settings", "assetStripCascadePosition", "rackUnitRelativePosition", "assetStripNumberOfRackUnits"]

        def __init__(self, rackUnitNumber=0, rackUnitPosition=0, type=None, size=0, settings=None, assetStripCascadePosition=0, rackUnitRelativePosition=0, assetStripNumberOfRackUnits=0):
            if type is None:
                type = raritan.rpc.assetmgrmodel.AssetStrip.TagType.SINGLE
            if settings is None:
                settings = raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings()
            typecheck.is_int(rackUnitNumber, AssertionError)
            typecheck.is_int(rackUnitPosition, AssertionError)
            typecheck.is_enum(type, raritan.rpc.assetmgrmodel.AssetStrip.TagType, AssertionError)
            typecheck.is_int(size, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings, AssertionError)
            typecheck.is_int(assetStripCascadePosition, AssertionError)
            typecheck.is_int(rackUnitRelativePosition, AssertionError)
            typecheck.is_int(assetStripNumberOfRackUnits, AssertionError)

            self.rackUnitNumber = rackUnitNumber
            self.rackUnitPosition = rackUnitPosition
            self.type = type
            self.size = size
            self.settings = settings
            self.assetStripCascadePosition = assetStripCascadePosition
            self.rackUnitRelativePosition = rackUnitRelativePosition
            self.assetStripNumberOfRackUnits = assetStripNumberOfRackUnits

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                rackUnitNumber = json['rackUnitNumber'] if 'rackUnitNumber' in json or not useDefaults else 0,
                rackUnitPosition = json['rackUnitPosition'] if 'rackUnitPosition' in json or not useDefaults else 0,
                type = raritan.rpc.assetmgrmodel.AssetStrip.TagType.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStrip.TagType.SINGLE,
                size = json['size'] if 'size' in json or not useDefaults else 0,
                settings = raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings.decode(json['settings'], agent, useDefaults=useDefaults) if 'settings' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings(),
                assetStripCascadePosition = json['assetStripCascadePosition'] if 'assetStripCascadePosition' in json or not useDefaults else 0,
                rackUnitRelativePosition = json['rackUnitRelativePosition'] if 'rackUnitRelativePosition' in json or not useDefaults else 0,
                assetStripNumberOfRackUnits = json['assetStripNumberOfRackUnits'] if 'assetStripNumberOfRackUnits' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['rackUnitNumber'] = self.rackUnitNumber
            json['rackUnitPosition'] = self.rackUnitPosition
            json['type'] = raritan.rpc.assetmgrmodel.AssetStrip.TagType.encode(self.type)
            json['size'] = self.size
            json['settings'] = raritan.rpc.assetmgrmodel.AssetStripConfig.RackUnitSettings.encode(self.settings)
            json['assetStripCascadePosition'] = self.assetStripCascadePosition
            json['rackUnitRelativePosition'] = self.rackUnitRelativePosition
            json['assetStripNumberOfRackUnits'] = self.assetStripNumberOfRackUnits
            return json

    # value object
    class StripInfoChangedEvent(raritan.rpc.idl.Event):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.StripInfoChangedEvent:1.0.0"

        def __init__(self, oldInfo=None, newInfo=None, source=None):
            super(raritan.rpc.assetmgrmodel.AssetStrip.StripInfoChangedEvent, self).__init__(source)
            if oldInfo is None:
                oldInfo = raritan.rpc.assetmgrmodel.AssetStrip.StripInfo()
            if newInfo is None:
                newInfo = raritan.rpc.assetmgrmodel.AssetStrip.StripInfo()
            typecheck.is_struct(oldInfo, raritan.rpc.assetmgrmodel.AssetStrip.StripInfo, AssertionError)
            typecheck.is_struct(newInfo, raritan.rpc.assetmgrmodel.AssetStrip.StripInfo, AssertionError)

            self.oldInfo = oldInfo
            self.newInfo = newInfo

        def encode(self):
            json = super(raritan.rpc.assetmgrmodel.AssetStrip.StripInfoChangedEvent, self).encode()
            json['oldInfo'] = raritan.rpc.assetmgrmodel.AssetStrip.StripInfo.encode(self.oldInfo)
            json['newInfo'] = raritan.rpc.assetmgrmodel.AssetStrip.StripInfo.encode(self.newInfo)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldInfo = raritan.rpc.assetmgrmodel.AssetStrip.StripInfo.decode(json['oldInfo'], agent, useDefaults=useDefaults) if 'oldInfo' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStrip.StripInfo(),
                newInfo = raritan.rpc.assetmgrmodel.AssetStrip.StripInfo.decode(json['newInfo'], agent, useDefaults=useDefaults) if 'newInfo' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStrip.StripInfo(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldInfo", "newInfo"]
            elements = elements + super(raritan.rpc.assetmgrmodel.AssetStrip.StripInfoChangedEvent, self).listElements()
            return elements

    # value object
    class StateChangedEvent(raritan.rpc.idl.Event):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.StateChangedEvent:1.0.0"

        def __init__(self, oldState=None, newState=None, deviceInfo=None, source=None):
            super(raritan.rpc.assetmgrmodel.AssetStrip.StateChangedEvent, self).__init__(source)
            if oldState is None:
                oldState = raritan.rpc.assetmgrmodel.AssetStrip.State.DISCONNECTED
            if newState is None:
                newState = raritan.rpc.assetmgrmodel.AssetStrip.State.DISCONNECTED
            if deviceInfo is None:
                deviceInfo = raritan.rpc.assetmgrmodel.AssetStrip.DeviceInfo()
            typecheck.is_enum(oldState, raritan.rpc.assetmgrmodel.AssetStrip.State, AssertionError)
            typecheck.is_enum(newState, raritan.rpc.assetmgrmodel.AssetStrip.State, AssertionError)
            typecheck.is_struct(deviceInfo, raritan.rpc.assetmgrmodel.AssetStrip.DeviceInfo, AssertionError)

            self.oldState = oldState
            self.newState = newState
            self.deviceInfo = deviceInfo

        def encode(self):
            json = super(raritan.rpc.assetmgrmodel.AssetStrip.StateChangedEvent, self).encode()
            json['oldState'] = raritan.rpc.assetmgrmodel.AssetStrip.State.encode(self.oldState)
            json['newState'] = raritan.rpc.assetmgrmodel.AssetStrip.State.encode(self.newState)
            json['deviceInfo'] = raritan.rpc.assetmgrmodel.AssetStrip.DeviceInfo.encode(self.deviceInfo)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldState = raritan.rpc.assetmgrmodel.AssetStrip.State.decode(json['oldState']) if 'oldState' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStrip.State.DISCONNECTED,
                newState = raritan.rpc.assetmgrmodel.AssetStrip.State.decode(json['newState']) if 'newState' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStrip.State.DISCONNECTED,
                deviceInfo = raritan.rpc.assetmgrmodel.AssetStrip.DeviceInfo.decode(json['deviceInfo'], agent, useDefaults=useDefaults) if 'deviceInfo' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStrip.DeviceInfo(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldState", "newState", "deviceInfo"]
            elements = elements + super(raritan.rpc.assetmgrmodel.AssetStrip.StateChangedEvent, self).listElements()
            return elements

    # value object
    class RackUnitChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.RackUnitChangedEvent:1.0.0"

        def __init__(self, rackUnitNumber=0, rackUnit=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.assetmgrmodel.AssetStrip.RackUnitChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if rackUnit is None:
                rackUnit = raritan.rpc.assetmgrmodel.AssetStrip.RackUnitInfo()
            typecheck.is_int(rackUnitNumber, AssertionError)
            typecheck.is_struct(rackUnit, raritan.rpc.assetmgrmodel.AssetStrip.RackUnitInfo, AssertionError)

            self.rackUnitNumber = rackUnitNumber
            self.rackUnit = rackUnit

        def encode(self):
            json = super(raritan.rpc.assetmgrmodel.AssetStrip.RackUnitChangedEvent, self).encode()
            json['rackUnitNumber'] = self.rackUnitNumber
            json['rackUnit'] = raritan.rpc.assetmgrmodel.AssetStrip.RackUnitInfo.encode(self.rackUnit)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                rackUnitNumber = json['rackUnitNumber'] if 'rackUnitNumber' in json or not useDefaults else 0,
                rackUnit = raritan.rpc.assetmgrmodel.AssetStrip.RackUnitInfo.decode(json['rackUnit'], agent, useDefaults=useDefaults) if 'rackUnit' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStrip.RackUnitInfo(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["rackUnitNumber", "rackUnit"]
            elements = elements + super(raritan.rpc.assetmgrmodel.AssetStrip.RackUnitChangedEvent, self).listElements()
            return elements

    # structure
    class TagChangeInfo(Structure):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.TagChangeInfo:1.0.0"
        elements = ["tag", "info", "parentBladeTagId", "slotPosition"]

        def __init__(self, tag=None, info=None, parentBladeTagId="", slotPosition=0):
            if tag is None:
                tag = raritan.rpc.assetmgrmodel.AssetStrip.TagInfo()
            if info is None:
                info = raritan.rpc.assetmgrmodel.AssetStrip.RackUnitInfo()
            typecheck.is_struct(tag, raritan.rpc.assetmgrmodel.AssetStrip.TagInfo, AssertionError)
            typecheck.is_struct(info, raritan.rpc.assetmgrmodel.AssetStrip.RackUnitInfo, AssertionError)
            if not typecheck._is_int(parentBladeTagId):
                typecheck.is_string(parentBladeTagId, AssertionError)
            typecheck.is_int(slotPosition, AssertionError)

            self.tag = tag
            self.info = info
            self.parentBladeTagId = parentBladeTagId
            self.slotPosition = slotPosition

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                tag = raritan.rpc.assetmgrmodel.AssetStrip.TagInfo.decode(json['tag'], agent, useDefaults=useDefaults) if 'tag' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStrip.TagInfo(),
                info = raritan.rpc.assetmgrmodel.AssetStrip.RackUnitInfo.decode(json['info'], agent, useDefaults=useDefaults) if 'info' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStrip.RackUnitInfo(),
                parentBladeTagId = json['parentBladeTagId'] if 'parentBladeTagId' in json or not useDefaults else "",
                slotPosition = json['slotPosition'] if 'slotPosition' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['tag'] = raritan.rpc.assetmgrmodel.AssetStrip.TagInfo.encode(self.tag)
            json['info'] = raritan.rpc.assetmgrmodel.AssetStrip.RackUnitInfo.encode(self.info)
            json['parentBladeTagId'] = str(self.parentBladeTagId)
            json['slotPosition'] = self.slotPosition
            return json

    # value object
    class TagEvent(raritan.rpc.idl.Event):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.TagEvent:1.0.0"

        def __init__(self, tags=[], allTags=[], source=None):
            super(raritan.rpc.assetmgrmodel.AssetStrip.TagEvent, self).__init__(source)
            for x0 in tags:
                typecheck.is_struct(x0, raritan.rpc.assetmgrmodel.AssetStrip.TagChangeInfo, AssertionError)
            for x0 in allTags:
                typecheck.is_struct(x0, raritan.rpc.assetmgrmodel.AssetStrip.TagInfo, AssertionError)

            self.tags = tags
            self.allTags = allTags

        def encode(self):
            json = super(raritan.rpc.assetmgrmodel.AssetStrip.TagEvent, self).encode()
            json['tags'] = [raritan.rpc.assetmgrmodel.AssetStrip.TagChangeInfo.encode(x0) for x0 in self.tags]
            json['allTags'] = [raritan.rpc.assetmgrmodel.AssetStrip.TagInfo.encode(x0) for x0 in self.allTags]
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                tags = [raritan.rpc.assetmgrmodel.AssetStrip.TagChangeInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in json['tags']] if 'tags' in json or not useDefaults else [],
                allTags = [raritan.rpc.assetmgrmodel.AssetStrip.TagInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in json['allTags']] if 'allTags' in json or not useDefaults else [],
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["tags", "allTags"]
            elements = elements + super(raritan.rpc.assetmgrmodel.AssetStrip.TagEvent, self).listElements()
            return elements

    # value object
    class TagAddedEvent(TagEvent):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.TagAddedEvent:1.0.0"

        def __init__(self, tags=[], allTags=[], source=None):
            super(raritan.rpc.assetmgrmodel.AssetStrip.TagAddedEvent, self).__init__(tags, allTags, source)

        def encode(self):
            json = super(raritan.rpc.assetmgrmodel.AssetStrip.TagAddedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                # for assetmgrmodel.AssetStrip_2_0_6.TagEvent
                tags = [raritan.rpc.assetmgrmodel.AssetStrip.TagChangeInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in json['tags']] if 'tags' in json or not useDefaults else [],
                allTags = [raritan.rpc.assetmgrmodel.AssetStrip.TagInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in json['allTags']] if 'allTags' in json or not useDefaults else [],
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.assetmgrmodel.AssetStrip.TagAddedEvent, self).listElements()
            return elements

    # value object
    class TagRemovedEvent(TagEvent):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.TagRemovedEvent:1.0.0"

        def __init__(self, tags=[], allTags=[], source=None):
            super(raritan.rpc.assetmgrmodel.AssetStrip.TagRemovedEvent, self).__init__(tags, allTags, source)

        def encode(self):
            json = super(raritan.rpc.assetmgrmodel.AssetStrip.TagRemovedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                # for assetmgrmodel.AssetStrip_2_0_6.TagEvent
                tags = [raritan.rpc.assetmgrmodel.AssetStrip.TagChangeInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in json['tags']] if 'tags' in json or not useDefaults else [],
                allTags = [raritan.rpc.assetmgrmodel.AssetStrip.TagInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in json['allTags']] if 'allTags' in json or not useDefaults else [],
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.assetmgrmodel.AssetStrip.TagRemovedEvent, self).listElements()
            return elements

    # enumeration
    class FirmwareUpdateState(Enumeration):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.FirmwareUpdateState:1.0.0"
        values = ["UPDATE_STARTED", "UPDATE_SUCCESSFUL", "UPDATE_FAILED"]

    FirmwareUpdateState.UPDATE_STARTED = FirmwareUpdateState(0)
    FirmwareUpdateState.UPDATE_SUCCESSFUL = FirmwareUpdateState(1)
    FirmwareUpdateState.UPDATE_FAILED = FirmwareUpdateState(2)

    # value object
    class FirmwareUpdateStateChangedEvent(raritan.rpc.idl.Event):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.FirmwareUpdateStateChangedEvent:1.0.0"

        def __init__(self, state=None, source=None):
            super(raritan.rpc.assetmgrmodel.AssetStrip.FirmwareUpdateStateChangedEvent, self).__init__(source)
            if state is None:
                state = raritan.rpc.assetmgrmodel.AssetStrip.FirmwareUpdateState.UPDATE_STARTED
            typecheck.is_enum(state, raritan.rpc.assetmgrmodel.AssetStrip.FirmwareUpdateState, AssertionError)

            self.state = state

        def encode(self):
            json = super(raritan.rpc.assetmgrmodel.AssetStrip.FirmwareUpdateStateChangedEvent, self).encode()
            json['state'] = raritan.rpc.assetmgrmodel.AssetStrip.FirmwareUpdateState.encode(self.state)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                state = raritan.rpc.assetmgrmodel.AssetStrip.FirmwareUpdateState.decode(json['state']) if 'state' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStrip.FirmwareUpdateState.UPDATE_STARTED,
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["state"]
            elements = elements + super(raritan.rpc.assetmgrmodel.AssetStrip.FirmwareUpdateStateChangedEvent, self).listElements()
            return elements

    # value object
    class BladeOverflowChangedEvent(raritan.rpc.idl.Event):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.BladeOverflowChangedEvent:1.0.0"

        def __init__(self, overflow=False, source=None):
            super(raritan.rpc.assetmgrmodel.AssetStrip.BladeOverflowChangedEvent, self).__init__(source)
            typecheck.is_bool(overflow, AssertionError)

            self.overflow = overflow

        def encode(self):
            json = super(raritan.rpc.assetmgrmodel.AssetStrip.BladeOverflowChangedEvent, self).encode()
            json['overflow'] = self.overflow
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                overflow = json['overflow'] if 'overflow' in json or not useDefaults else False,
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["overflow"]
            elements = elements + super(raritan.rpc.assetmgrmodel.AssetStrip.BladeOverflowChangedEvent, self).listElements()
            return elements

    # value object
    class OrientationChangedEvent(raritan.rpc.idl.Event):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.OrientationChangedEvent:1.0.0"

        def __init__(self, oldOrientation=None, newOrientation=None, source=None):
            super(raritan.rpc.assetmgrmodel.AssetStrip.OrientationChangedEvent, self).__init__(source)
            if oldOrientation is None:
                oldOrientation = raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation.TOP_CONNECTOR
            if newOrientation is None:
                newOrientation = raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation.TOP_CONNECTOR
            typecheck.is_enum(oldOrientation, raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation, AssertionError)
            typecheck.is_enum(newOrientation, raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation, AssertionError)

            self.oldOrientation = oldOrientation
            self.newOrientation = newOrientation

        def encode(self):
            json = super(raritan.rpc.assetmgrmodel.AssetStrip.OrientationChangedEvent, self).encode()
            json['oldOrientation'] = raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation.encode(self.oldOrientation)
            json['newOrientation'] = raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation.encode(self.newOrientation)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldOrientation = raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation.decode(json['oldOrientation']) if 'oldOrientation' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation.TOP_CONNECTOR,
                newOrientation = raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation.decode(json['newOrientation']) if 'newOrientation' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripConfig.Orientation.TOP_CONNECTOR,
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldOrientation", "newOrientation"]
            elements = elements + super(raritan.rpc.assetmgrmodel.AssetStrip.OrientationChangedEvent, self).listElements()
            return elements

    # value object
    class CompositionChangedEvent(raritan.rpc.idl.Event):
        idlType = "assetmgrmodel.AssetStrip_2_0_6.CompositionChangedEvent:1.0.0"

        def __init__(self, oldComponentCount=0, newComponentCount=0, source=None):
            super(raritan.rpc.assetmgrmodel.AssetStrip.CompositionChangedEvent, self).__init__(source)
            typecheck.is_int(oldComponentCount, AssertionError)
            typecheck.is_int(newComponentCount, AssertionError)

            self.oldComponentCount = oldComponentCount
            self.newComponentCount = newComponentCount

        def encode(self):
            json = super(raritan.rpc.assetmgrmodel.AssetStrip.CompositionChangedEvent, self).encode()
            json['oldComponentCount'] = self.oldComponentCount
            json['newComponentCount'] = self.newComponentCount
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldComponentCount = json['oldComponentCount'] if 'oldComponentCount' in json or not useDefaults else 0,
                newComponentCount = json['newComponentCount'] if 'newComponentCount' in json or not useDefaults else 0,
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldComponentCount", "newComponentCount"]
            elements = elements + super(raritan.rpc.assetmgrmodel.AssetStrip.CompositionChangedEvent, self).listElements()
            return elements

    class _getState(Interface.Method):
        name = 'getState'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.assetmgrmodel.AssetStrip.State.decode(rsp['_ret_'])
            typecheck.is_enum(_ret_, raritan.rpc.assetmgrmodel.AssetStrip.State, DecodeException)
            return _ret_

    class _getDeviceInfo(Interface.Method):
        name = 'getDeviceInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.assetmgrmodel.AssetStrip.DeviceInfo.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.assetmgrmodel.AssetStrip.DeviceInfo, DecodeException)
            return _ret_

    class _getStripInfo(Interface.Method):
        name = 'getStripInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.assetmgrmodel.AssetStrip.StripInfo.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.assetmgrmodel.AssetStrip.StripInfo, DecodeException)
            return _ret_

    class _getRackUnitInfo(Interface.Method):
        name = 'getRackUnitInfo'

        @staticmethod
        def encode(rackUnitNumber):
            typecheck.is_int(rackUnitNumber, AssertionError)
            args = {}
            args['rackUnitNumber'] = rackUnitNumber
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            info = raritan.rpc.assetmgrmodel.AssetStrip.RackUnitInfo.decode(rsp['info'], agent, useDefaults=useDefaults)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_struct(info, raritan.rpc.assetmgrmodel.AssetStrip.RackUnitInfo, DecodeException)
            return (_ret_, info)

    class _getAllRackUnitInfos(Interface.Method):
        name = 'getAllRackUnitInfos'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.assetmgrmodel.AssetStrip.RackUnitInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.assetmgrmodel.AssetStrip.RackUnitInfo, DecodeException)
            return _ret_

    class _getTag(Interface.Method):
        name = 'getTag'

        @staticmethod
        def encode(rackUnitNumber, slotNumber):
            typecheck.is_int(rackUnitNumber, AssertionError)
            typecheck.is_int(slotNumber, AssertionError)
            args = {}
            args['rackUnitNumber'] = rackUnitNumber
            args['slotNumber'] = slotNumber
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            tagInfo = raritan.rpc.assetmgrmodel.AssetStrip.TagInfo.decode(rsp['tagInfo'], agent, useDefaults=useDefaults)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_struct(tagInfo, raritan.rpc.assetmgrmodel.AssetStrip.TagInfo, DecodeException)
            return (_ret_, tagInfo)

    class _getAllTags(Interface.Method):
        name = 'getAllTags'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.assetmgrmodel.AssetStrip.TagInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.assetmgrmodel.AssetStrip.TagInfo, DecodeException)
            return _ret_

    class _getMainTags(Interface.Method):
        name = 'getMainTags'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.assetmgrmodel.AssetStrip.TagInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.assetmgrmodel.AssetStrip.TagInfo, DecodeException)
            return _ret_

    class _getExtensionTags(Interface.Method):
        name = 'getExtensionTags'

        @staticmethod
        def encode(rackUnitNumber):
            typecheck.is_int(rackUnitNumber, AssertionError)
            args = {}
            args['rackUnitNumber'] = rackUnitNumber
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            tags = [raritan.rpc.assetmgrmodel.AssetStrip.TagInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['tags']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in tags:
                typecheck.is_struct(x0, raritan.rpc.assetmgrmodel.AssetStrip.TagInfo, DecodeException)
            return (_ret_, tags)

    class _triggerPowercycle(Interface.Method):
        name = 'triggerPowercycle'

        @staticmethod
        def encode(hard):
            typecheck.is_bool(hard, AssertionError)
            args = {}
            args['hard'] = hard
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _programTagIDs(Interface.Method):
        name = 'programTagIDs'

        @staticmethod
        def encode(tagInfos):
            for x0 in tagInfos:
                typecheck.is_struct(x0, raritan.rpc.assetmgrmodel.AssetStrip.TagInfo, AssertionError)
            args = {}
            args['tagInfos'] = [raritan.rpc.assetmgrmodel.AssetStrip.TagInfo.encode(x0) for x0 in tagInfos]
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getFirmwareUpdateState(Interface.Method):
        name = 'getFirmwareUpdateState'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.assetmgrmodel.AssetStrip.FirmwareUpdateState.decode(rsp['_ret_'])
            typecheck.is_enum(_ret_, raritan.rpc.assetmgrmodel.AssetStrip.FirmwareUpdateState, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(AssetStrip, self).__init__(target, agent)
        self.getState = AssetStrip._getState(self)
        self.getDeviceInfo = AssetStrip._getDeviceInfo(self)
        self.getStripInfo = AssetStrip._getStripInfo(self)
        self.getRackUnitInfo = AssetStrip._getRackUnitInfo(self)
        self.getAllRackUnitInfos = AssetStrip._getAllRackUnitInfos(self)
        self.getTag = AssetStrip._getTag(self)
        self.getAllTags = AssetStrip._getAllTags(self)
        self.getMainTags = AssetStrip._getMainTags(self)
        self.getExtensionTags = AssetStrip._getExtensionTags(self)
        self.triggerPowercycle = AssetStrip._triggerPowercycle(self)
        self.programTagIDs = AssetStrip._programTagIDs(self)
        self.getFirmwareUpdateState = AssetStrip._getFirmwareUpdateState(self)

#
# Section generated by IdlC from "AssetStripLogger.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.assetmgrmodel


# interface
class AssetStripLogger(Interface):
    idlType = "assetmgrmodel.AssetStripLogger:1.0.7"

    NO_ERROR = 0

    ERR_INVALID_PARAM = 1

    # structure
    class Info(Structure):
        idlType = "assetmgrmodel.AssetStripLogger_1_0_7.Info:1.0.0"
        elements = ["capacity", "oldestRecord", "newestRecord", "totalEventCount"]

        def __init__(self, capacity=0, oldestRecord=0, newestRecord=0, totalEventCount=0):
            typecheck.is_int(capacity, AssertionError)
            typecheck.is_int(oldestRecord, AssertionError)
            typecheck.is_int(newestRecord, AssertionError)
            typecheck.is_int(totalEventCount, AssertionError)

            self.capacity = capacity
            self.oldestRecord = oldestRecord
            self.newestRecord = newestRecord
            self.totalEventCount = totalEventCount

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                capacity = json['capacity'] if 'capacity' in json or not useDefaults else 0,
                oldestRecord = json['oldestRecord'] if 'oldestRecord' in json or not useDefaults else 0,
                newestRecord = json['newestRecord'] if 'newestRecord' in json or not useDefaults else 0,
                totalEventCount = json['totalEventCount'] if 'totalEventCount' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['capacity'] = self.capacity
            json['oldestRecord'] = self.oldestRecord
            json['newestRecord'] = self.newestRecord
            json['totalEventCount'] = self.totalEventCount
            return json

    # enumeration
    class RecordType(Enumeration):
        idlType = "assetmgrmodel.AssetStripLogger_1_0_7.RecordType:1.0.0"
        values = ["EMPTY", "ASSET_TAG_CONNECTED", "ASSET_TAG_DISCONNECTED", "ASSET_STRIP_STATE_CHANGED"]

    RecordType.EMPTY = RecordType(0)
    RecordType.ASSET_TAG_CONNECTED = RecordType(1)
    RecordType.ASSET_TAG_DISCONNECTED = RecordType(2)
    RecordType.ASSET_STRIP_STATE_CHANGED = RecordType(3)

    # structure
    class Record(Structure):
        idlType = "assetmgrmodel.AssetStripLogger_1_0_7.Record:1.0.0"
        elements = ["timestamp", "type", "assetStripNumber", "rackUnitNumber", "rackUnitPosition", "slotNumber", "tagId", "parentBladeId", "state"]

        def __init__(self, timestamp=None, type=None, assetStripNumber=0, rackUnitNumber=0, rackUnitPosition=0, slotNumber=0, tagId="", parentBladeId="", state=None):
            if type is None:
                type = raritan.rpc.assetmgrmodel.AssetStripLogger.RecordType.EMPTY
            if state is None:
                state = raritan.rpc.assetmgrmodel.AssetStrip.State.DISCONNECTED
            typecheck.is_time(timestamp, AssertionError)
            typecheck.is_enum(type, raritan.rpc.assetmgrmodel.AssetStripLogger.RecordType, AssertionError)
            typecheck.is_int(assetStripNumber, AssertionError)
            typecheck.is_int(rackUnitNumber, AssertionError)
            typecheck.is_int(rackUnitPosition, AssertionError)
            typecheck.is_int(slotNumber, AssertionError)
            if not typecheck._is_int(tagId):
                typecheck.is_string(tagId, AssertionError)
            if not typecheck._is_int(parentBladeId):
                typecheck.is_string(parentBladeId, AssertionError)
            typecheck.is_enum(state, raritan.rpc.assetmgrmodel.AssetStrip.State, AssertionError)

            self.timestamp = timestamp
            self.type = type
            self.assetStripNumber = assetStripNumber
            self.rackUnitNumber = rackUnitNumber
            self.rackUnitPosition = rackUnitPosition
            self.slotNumber = slotNumber
            self.tagId = tagId
            self.parentBladeId = parentBladeId
            self.state = state

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                timestamp = raritan.rpc.Time.decode(json['timestamp']) if 'timestamp' in json or not useDefaults else None,
                type = raritan.rpc.assetmgrmodel.AssetStripLogger.RecordType.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStripLogger.RecordType.EMPTY,
                assetStripNumber = json['assetStripNumber'] if 'assetStripNumber' in json or not useDefaults else 0,
                rackUnitNumber = json['rackUnitNumber'] if 'rackUnitNumber' in json or not useDefaults else 0,
                rackUnitPosition = json['rackUnitPosition'] if 'rackUnitPosition' in json or not useDefaults else 0,
                slotNumber = json['slotNumber'] if 'slotNumber' in json or not useDefaults else 0,
                tagId = json['tagId'] if 'tagId' in json or not useDefaults else "",
                parentBladeId = json['parentBladeId'] if 'parentBladeId' in json or not useDefaults else "",
                state = raritan.rpc.assetmgrmodel.AssetStrip.State.decode(json['state']) if 'state' in json or not useDefaults else raritan.rpc.assetmgrmodel.AssetStrip.State.DISCONNECTED,
            )
            return obj

        def encode(self):
            json = {}
            json['timestamp'] = raritan.rpc.Time.encode(self.timestamp)
            json['type'] = raritan.rpc.assetmgrmodel.AssetStripLogger.RecordType.encode(self.type)
            json['assetStripNumber'] = self.assetStripNumber
            json['rackUnitNumber'] = self.rackUnitNumber
            json['rackUnitPosition'] = self.rackUnitPosition
            json['slotNumber'] = self.slotNumber
            json['tagId'] = str(self.tagId)
            json['parentBladeId'] = str(self.parentBladeId)
            json['state'] = raritan.rpc.assetmgrmodel.AssetStrip.State.encode(self.state)
            return json

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.assetmgrmodel.AssetStripLogger.Info.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.assetmgrmodel.AssetStripLogger.Info, DecodeException)
            return _ret_

    class _getRecords(Interface.Method):
        name = 'getRecords'

        @staticmethod
        def encode(id, count):
            typecheck.is_int(id, AssertionError)
            typecheck.is_int(count, AssertionError)
            args = {}
            args['id'] = id
            args['count'] = count
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            records = [raritan.rpc.assetmgrmodel.AssetStripLogger.Record.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['records']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in records:
                typecheck.is_struct(x0, raritan.rpc.assetmgrmodel.AssetStripLogger.Record, DecodeException)
            return (_ret_, records)
    def __init__(self, target, agent):
        super(AssetStripLogger, self).__init__(target, agent)
        self.getInfo = AssetStripLogger._getInfo(self)
        self.getRecords = AssetStripLogger._getRecords(self)
