# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "ServerSSLCert.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.cert


# interface
class ServerSSLCert(Interface):
    idlType = "cert.ServerSSLCert:4.0.0"

    SUCCESS = 0

    ERR_BUSY = 1

    ERR_CSR_OR_CERT_PENDING = 101

    ERR_KEY_MISSING = 200

    ERR_CERT_MISSING = 201

    ERR_CERT_FORMAT_INVALID = 202

    ERR_CERT_KEY_MISMATCH = 203

    ERR_KEY_FORMAT_INVALID = 204

    ERR_GEN_KEY_LEN_INVALID = 100

    ERR_GEN_CSR_OR_CERT_PENDING = 101

    ERR_GEN_KEY_GEN_FAILED = 102

    ERR_GEN_KEY_TYPE_INVALID = 103

    ERR_GEN_ELLIPTIC_CURVE_INVALID = 104

    ERR_GEN_VALIDITY_OUT_OF_RANGE = 105

    ERR_INSTALL_KEY_MISSING = 200

    ERR_INSTALL_CERT_MISSING = 201

    ERR_INSTALL_CERT_FORMAT_INVALID = 202

    ERR_INSTALL_CERT_KEY_MISMATCH = 203

    ERR_INSTALL_KEY_FORMAT_INVALID = 204

    # structure
    class CommonAttributes(Structure):
        idlType = "cert.ServerSSLCert_4_0_0.CommonAttributes:1.0.0"
        elements = ["country", "stateOrProvince", "locality", "organization", "organizationalUnit", "commonName", "emailAddress"]

        def __init__(self, country="", stateOrProvince="", locality="", organization="", organizationalUnit="", commonName="", emailAddress=""):
            if not typecheck._is_int(country):
                typecheck.is_string(country, AssertionError)
            if not typecheck._is_int(stateOrProvince):
                typecheck.is_string(stateOrProvince, AssertionError)
            if not typecheck._is_int(locality):
                typecheck.is_string(locality, AssertionError)
            if not typecheck._is_int(organization):
                typecheck.is_string(organization, AssertionError)
            if not typecheck._is_int(organizationalUnit):
                typecheck.is_string(organizationalUnit, AssertionError)
            if not typecheck._is_int(commonName):
                typecheck.is_string(commonName, AssertionError)
            if not typecheck._is_int(emailAddress):
                typecheck.is_string(emailAddress, AssertionError)

            self.country = country
            self.stateOrProvince = stateOrProvince
            self.locality = locality
            self.organization = organization
            self.organizationalUnit = organizationalUnit
            self.commonName = commonName
            self.emailAddress = emailAddress

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                country = json['country'] if 'country' in json or not useDefaults else "",
                stateOrProvince = json['stateOrProvince'] if 'stateOrProvince' in json or not useDefaults else "",
                locality = json['locality'] if 'locality' in json or not useDefaults else "",
                organization = json['organization'] if 'organization' in json or not useDefaults else "",
                organizationalUnit = json['organizationalUnit'] if 'organizationalUnit' in json or not useDefaults else "",
                commonName = json['commonName'] if 'commonName' in json or not useDefaults else "",
                emailAddress = json['emailAddress'] if 'emailAddress' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['country'] = str(self.country)
            json['stateOrProvince'] = str(self.stateOrProvince)
            json['locality'] = str(self.locality)
            json['organization'] = str(self.organization)
            json['organizationalUnit'] = str(self.organizationalUnit)
            json['commonName'] = str(self.commonName)
            json['emailAddress'] = str(self.emailAddress)
            return json

    # enumeration
    class KeyType(Enumeration):
        idlType = "cert.ServerSSLCert_4_0_0.KeyType:1.0.0"
        values = ["KEY_TYPE_UNKNOWN", "KEY_TYPE_RSA", "KEY_TYPE_ECDSA"]

    KeyType.KEY_TYPE_UNKNOWN = KeyType(0)
    KeyType.KEY_TYPE_RSA = KeyType(1)
    KeyType.KEY_TYPE_ECDSA = KeyType(2)

    # enumeration
    class EllipticCurve(Enumeration):
        idlType = "cert.ServerSSLCert_4_0_0.EllipticCurve:1.0.0"
        values = ["EC_CURVE_UNKNOWN", "EC_CURVE_NIST_P256", "EC_CURVE_NIST_P384", "EC_CURVE_NIST_P521"]

    EllipticCurve.EC_CURVE_UNKNOWN = EllipticCurve(0)
    EllipticCurve.EC_CURVE_NIST_P256 = EllipticCurve(1)
    EllipticCurve.EC_CURVE_NIST_P384 = EllipticCurve(2)
    EllipticCurve.EC_CURVE_NIST_P521 = EllipticCurve(3)

    # structure
    class KeyInfo(Structure):
        idlType = "cert.ServerSSLCert_4_0_0.KeyInfo:1.0.0"
        elements = ["type", "ecCurve", "rsaKeyLength", "inSecureElement"]

        def __init__(self, type=None, ecCurve=None, rsaKeyLength=0, inSecureElement=False):
            if type is None:
                type = raritan.rpc.cert.ServerSSLCert.KeyType.KEY_TYPE_UNKNOWN
            if ecCurve is None:
                ecCurve = raritan.rpc.cert.ServerSSLCert.EllipticCurve.EC_CURVE_UNKNOWN
            typecheck.is_enum(type, raritan.rpc.cert.ServerSSLCert.KeyType, AssertionError)
            typecheck.is_enum(ecCurve, raritan.rpc.cert.ServerSSLCert.EllipticCurve, AssertionError)
            typecheck.is_int(rsaKeyLength, AssertionError)
            typecheck.is_bool(inSecureElement, AssertionError)

            self.type = type
            self.ecCurve = ecCurve
            self.rsaKeyLength = rsaKeyLength
            self.inSecureElement = inSecureElement

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                type = raritan.rpc.cert.ServerSSLCert.KeyType.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.cert.ServerSSLCert.KeyType.KEY_TYPE_UNKNOWN,
                ecCurve = raritan.rpc.cert.ServerSSLCert.EllipticCurve.decode(json['ecCurve']) if 'ecCurve' in json or not useDefaults else raritan.rpc.cert.ServerSSLCert.EllipticCurve.EC_CURVE_UNKNOWN,
                rsaKeyLength = json['rsaKeyLength'] if 'rsaKeyLength' in json or not useDefaults else 0,
                inSecureElement = json['inSecureElement'] if 'inSecureElement' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = raritan.rpc.cert.ServerSSLCert.KeyType.encode(self.type)
            json['ecCurve'] = raritan.rpc.cert.ServerSSLCert.EllipticCurve.encode(self.ecCurve)
            json['rsaKeyLength'] = self.rsaKeyLength
            json['inSecureElement'] = self.inSecureElement
            return json

    # structure
    class ReqInfo(Structure):
        idlType = "cert.ServerSSLCert_4_0_0.ReqInfo:1.0.0"
        elements = ["subject", "names", "keyInfo"]

        def __init__(self, subject=None, names=[], keyInfo=None):
            if subject is None:
                subject = raritan.rpc.cert.ServerSSLCert.CommonAttributes()
            if keyInfo is None:
                keyInfo = raritan.rpc.cert.ServerSSLCert.KeyInfo()
            typecheck.is_struct(subject, raritan.rpc.cert.ServerSSLCert.CommonAttributes, AssertionError)
            for x0 in names:
                if not typecheck._is_int(x0):
                    typecheck.is_string(x0, AssertionError)
            typecheck.is_struct(keyInfo, raritan.rpc.cert.ServerSSLCert.KeyInfo, AssertionError)

            self.subject = subject
            self.names = names
            self.keyInfo = keyInfo

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                subject = raritan.rpc.cert.ServerSSLCert.CommonAttributes.decode(json['subject'], agent, useDefaults=useDefaults) if 'subject' in json or not useDefaults else raritan.rpc.cert.ServerSSLCert.CommonAttributes(),
                names = [x0 for x0 in json['names']] if 'names' in json or not useDefaults else [],
                keyInfo = raritan.rpc.cert.ServerSSLCert.KeyInfo.decode(json['keyInfo'], agent, useDefaults=useDefaults) if 'keyInfo' in json or not useDefaults else raritan.rpc.cert.ServerSSLCert.KeyInfo(),
            )
            return obj

        def encode(self):
            json = {}
            json['subject'] = raritan.rpc.cert.ServerSSLCert.CommonAttributes.encode(self.subject)
            json['names'] = [str(x0) for x0 in self.names]
            json['keyInfo'] = raritan.rpc.cert.ServerSSLCert.KeyInfo.encode(self.keyInfo)
            return json

    # structure
    class CertInfo(Structure):
        idlType = "cert.ServerSSLCert_4_0_0.CertInfo:1.0.0"
        elements = ["subject", "issuer", "names", "invalidBefore", "invalidAfter", "serialNumber", "keyInfo"]

        def __init__(self, subject=None, issuer=None, names=[], invalidBefore="", invalidAfter="", serialNumber="", keyInfo=None):
            if subject is None:
                subject = raritan.rpc.cert.ServerSSLCert.CommonAttributes()
            if issuer is None:
                issuer = raritan.rpc.cert.ServerSSLCert.CommonAttributes()
            if keyInfo is None:
                keyInfo = raritan.rpc.cert.ServerSSLCert.KeyInfo()
            typecheck.is_struct(subject, raritan.rpc.cert.ServerSSLCert.CommonAttributes, AssertionError)
            typecheck.is_struct(issuer, raritan.rpc.cert.ServerSSLCert.CommonAttributes, AssertionError)
            for x0 in names:
                if not typecheck._is_int(x0):
                    typecheck.is_string(x0, AssertionError)
            if not typecheck._is_int(invalidBefore):
                typecheck.is_string(invalidBefore, AssertionError)
            if not typecheck._is_int(invalidAfter):
                typecheck.is_string(invalidAfter, AssertionError)
            if not typecheck._is_int(serialNumber):
                typecheck.is_string(serialNumber, AssertionError)
            typecheck.is_struct(keyInfo, raritan.rpc.cert.ServerSSLCert.KeyInfo, AssertionError)

            self.subject = subject
            self.issuer = issuer
            self.names = names
            self.invalidBefore = invalidBefore
            self.invalidAfter = invalidAfter
            self.serialNumber = serialNumber
            self.keyInfo = keyInfo

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                subject = raritan.rpc.cert.ServerSSLCert.CommonAttributes.decode(json['subject'], agent, useDefaults=useDefaults) if 'subject' in json or not useDefaults else raritan.rpc.cert.ServerSSLCert.CommonAttributes(),
                issuer = raritan.rpc.cert.ServerSSLCert.CommonAttributes.decode(json['issuer'], agent, useDefaults=useDefaults) if 'issuer' in json or not useDefaults else raritan.rpc.cert.ServerSSLCert.CommonAttributes(),
                names = [x0 for x0 in json['names']] if 'names' in json or not useDefaults else [],
                invalidBefore = json['invalidBefore'] if 'invalidBefore' in json or not useDefaults else "",
                invalidAfter = json['invalidAfter'] if 'invalidAfter' in json or not useDefaults else "",
                serialNumber = json['serialNumber'] if 'serialNumber' in json or not useDefaults else "",
                keyInfo = raritan.rpc.cert.ServerSSLCert.KeyInfo.decode(json['keyInfo'], agent, useDefaults=useDefaults) if 'keyInfo' in json or not useDefaults else raritan.rpc.cert.ServerSSLCert.KeyInfo(),
            )
            return obj

        def encode(self):
            json = {}
            json['subject'] = raritan.rpc.cert.ServerSSLCert.CommonAttributes.encode(self.subject)
            json['issuer'] = raritan.rpc.cert.ServerSSLCert.CommonAttributes.encode(self.issuer)
            json['names'] = [str(x0) for x0 in self.names]
            json['invalidBefore'] = str(self.invalidBefore)
            json['invalidAfter'] = str(self.invalidAfter)
            json['serialNumber'] = str(self.serialNumber)
            json['keyInfo'] = raritan.rpc.cert.ServerSSLCert.KeyInfo.encode(self.keyInfo)
            return json

    # structure
    class Info(Structure):
        idlType = "cert.ServerSSLCert_4_0_0.Info:1.0.0"
        elements = ["havePendingReq", "havePendingCert", "pendingReqInfo", "pendingCertInfo", "pendingCertChainInfos", "activeCertInfo", "activeCertChainInfos", "maxSignDays"]

        def __init__(self, havePendingReq=False, havePendingCert=False, pendingReqInfo=None, pendingCertInfo=None, pendingCertChainInfos=[], activeCertInfo=None, activeCertChainInfos=[], maxSignDays=0):
            if pendingReqInfo is None:
                pendingReqInfo = raritan.rpc.cert.ServerSSLCert.ReqInfo()
            if pendingCertInfo is None:
                pendingCertInfo = raritan.rpc.cert.ServerSSLCert.CertInfo()
            if activeCertInfo is None:
                activeCertInfo = raritan.rpc.cert.ServerSSLCert.CertInfo()
            typecheck.is_bool(havePendingReq, AssertionError)
            typecheck.is_bool(havePendingCert, AssertionError)
            typecheck.is_struct(pendingReqInfo, raritan.rpc.cert.ServerSSLCert.ReqInfo, AssertionError)
            typecheck.is_struct(pendingCertInfo, raritan.rpc.cert.ServerSSLCert.CertInfo, AssertionError)
            for x0 in pendingCertChainInfos:
                typecheck.is_struct(x0, raritan.rpc.cert.ServerSSLCert.CertInfo, AssertionError)
            typecheck.is_struct(activeCertInfo, raritan.rpc.cert.ServerSSLCert.CertInfo, AssertionError)
            for x0 in activeCertChainInfos:
                typecheck.is_struct(x0, raritan.rpc.cert.ServerSSLCert.CertInfo, AssertionError)
            typecheck.is_int(maxSignDays, AssertionError)

            self.havePendingReq = havePendingReq
            self.havePendingCert = havePendingCert
            self.pendingReqInfo = pendingReqInfo
            self.pendingCertInfo = pendingCertInfo
            self.pendingCertChainInfos = pendingCertChainInfos
            self.activeCertInfo = activeCertInfo
            self.activeCertChainInfos = activeCertChainInfos
            self.maxSignDays = maxSignDays

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                havePendingReq = json['havePendingReq'] if 'havePendingReq' in json or not useDefaults else False,
                havePendingCert = json['havePendingCert'] if 'havePendingCert' in json or not useDefaults else False,
                pendingReqInfo = raritan.rpc.cert.ServerSSLCert.ReqInfo.decode(json['pendingReqInfo'], agent, useDefaults=useDefaults) if 'pendingReqInfo' in json or not useDefaults else raritan.rpc.cert.ServerSSLCert.ReqInfo(),
                pendingCertInfo = raritan.rpc.cert.ServerSSLCert.CertInfo.decode(json['pendingCertInfo'], agent, useDefaults=useDefaults) if 'pendingCertInfo' in json or not useDefaults else raritan.rpc.cert.ServerSSLCert.CertInfo(),
                pendingCertChainInfos = [raritan.rpc.cert.ServerSSLCert.CertInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in json['pendingCertChainInfos']] if 'pendingCertChainInfos' in json or not useDefaults else [],
                activeCertInfo = raritan.rpc.cert.ServerSSLCert.CertInfo.decode(json['activeCertInfo'], agent, useDefaults=useDefaults) if 'activeCertInfo' in json or not useDefaults else raritan.rpc.cert.ServerSSLCert.CertInfo(),
                activeCertChainInfos = [raritan.rpc.cert.ServerSSLCert.CertInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in json['activeCertChainInfos']] if 'activeCertChainInfos' in json or not useDefaults else [],
                maxSignDays = json['maxSignDays'] if 'maxSignDays' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['havePendingReq'] = self.havePendingReq
            json['havePendingCert'] = self.havePendingCert
            json['pendingReqInfo'] = raritan.rpc.cert.ServerSSLCert.ReqInfo.encode(self.pendingReqInfo)
            json['pendingCertInfo'] = raritan.rpc.cert.ServerSSLCert.CertInfo.encode(self.pendingCertInfo)
            json['pendingCertChainInfos'] = [raritan.rpc.cert.ServerSSLCert.CertInfo.encode(x0) for x0 in self.pendingCertChainInfos]
            json['activeCertInfo'] = raritan.rpc.cert.ServerSSLCert.CertInfo.encode(self.activeCertInfo)
            json['activeCertChainInfos'] = [raritan.rpc.cert.ServerSSLCert.CertInfo.encode(x0) for x0 in self.activeCertChainInfos]
            json['maxSignDays'] = self.maxSignDays
            return json

    class _getSupportedKeyInfos(Interface.Method):
        name = 'getSupportedKeyInfos'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.cert.ServerSSLCert.KeyInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.cert.ServerSSLCert.KeyInfo, DecodeException)
            return _ret_

    class _generateUnsignedKeyPair(Interface.Method):
        name = 'generateUnsignedKeyPair'

        @staticmethod
        def encode(reqInfo, challenge):
            typecheck.is_struct(reqInfo, raritan.rpc.cert.ServerSSLCert.ReqInfo, AssertionError)
            if not typecheck._is_int(challenge):
                typecheck.is_string(challenge, AssertionError)
            args = {}
            args['reqInfo'] = raritan.rpc.cert.ServerSSLCert.ReqInfo.encode(reqInfo)
            args['challenge'] = str(challenge)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _generateSelfSignedKeyPair(Interface.Method):
        name = 'generateSelfSignedKeyPair'

        @staticmethod
        def encode(reqInfo, days):
            typecheck.is_struct(reqInfo, raritan.rpc.cert.ServerSSLCert.ReqInfo, AssertionError)
            typecheck.is_int(days, AssertionError)
            args = {}
            args['reqInfo'] = raritan.rpc.cert.ServerSSLCert.ReqInfo.encode(reqInfo)
            args['days'] = days
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _deletePending(Interface.Method):
        name = 'deletePending'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            info = raritan.rpc.cert.ServerSSLCert.Info.decode(rsp['info'], agent, useDefaults=useDefaults)
            typecheck.is_struct(info, raritan.rpc.cert.ServerSSLCert.Info, DecodeException)
            return info

    class _getActiveCertChainPEM(Interface.Method):
        name = 'getActiveCertChainPEM'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            if not typecheck._is_int(_ret_):
                typecheck.is_string(_ret_, DecodeException)
            return _ret_

    class _getActiveKeyPEM(Interface.Method):
        name = 'getActiveKeyPEM'

        @staticmethod
        def encode(keyPassword):
            if not typecheck._is_int(keyPassword):
                typecheck.is_string(keyPassword, AssertionError)
            args = {}
            args['keyPassword'] = str(keyPassword)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            if not typecheck._is_int(_ret_):
                typecheck.is_string(_ret_, DecodeException)
            return _ret_

    class _getPendingRequestPEM(Interface.Method):
        name = 'getPendingRequestPEM'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            if not typecheck._is_int(_ret_):
                typecheck.is_string(_ret_, DecodeException)
            return _ret_

    class _getPendingCertChainPEM(Interface.Method):
        name = 'getPendingCertChainPEM'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            if not typecheck._is_int(_ret_):
                typecheck.is_string(_ret_, DecodeException)
            return _ret_

    class _getPendingKeyPEM(Interface.Method):
        name = 'getPendingKeyPEM'

        @staticmethod
        def encode(keyPassword):
            if not typecheck._is_int(keyPassword):
                typecheck.is_string(keyPassword, AssertionError)
            args = {}
            args['keyPassword'] = str(keyPassword)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            if not typecheck._is_int(_ret_):
                typecheck.is_string(_ret_, DecodeException)
            return _ret_

    class _setPendingCertChainPEM(Interface.Method):
        name = 'setPendingCertChainPEM'

        @staticmethod
        def encode(certChain):
            if not typecheck._is_int(certChain):
                typecheck.is_string(certChain, AssertionError)
            args = {}
            args['certChain'] = str(certChain)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setPendingKeyAndCertChainPEM(Interface.Method):
        name = 'setPendingKeyAndCertChainPEM'

        @staticmethod
        def encode(key, certChain, keyPassword):
            if not typecheck._is_int(key):
                typecheck.is_string(key, AssertionError)
            if not typecheck._is_int(certChain):
                typecheck.is_string(certChain, AssertionError)
            if not typecheck._is_int(keyPassword):
                typecheck.is_string(keyPassword, AssertionError)
            args = {}
            args['key'] = str(key)
            args['certChain'] = str(certChain)
            args['keyPassword'] = str(keyPassword)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _installPendingKeyPair(Interface.Method):
        name = 'installPendingKeyPair'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(ServerSSLCert, self).__init__(target, agent)
        self.getSupportedKeyInfos = ServerSSLCert._getSupportedKeyInfos(self)
        self.generateUnsignedKeyPair = ServerSSLCert._generateUnsignedKeyPair(self)
        self.generateSelfSignedKeyPair = ServerSSLCert._generateSelfSignedKeyPair(self)
        self.deletePending = ServerSSLCert._deletePending(self)
        self.getInfo = ServerSSLCert._getInfo(self)
        self.getActiveCertChainPEM = ServerSSLCert._getActiveCertChainPEM(self)
        self.getActiveKeyPEM = ServerSSLCert._getActiveKeyPEM(self)
        self.getPendingRequestPEM = ServerSSLCert._getPendingRequestPEM(self)
        self.getPendingCertChainPEM = ServerSSLCert._getPendingCertChainPEM(self)
        self.getPendingKeyPEM = ServerSSLCert._getPendingKeyPEM(self)
        self.setPendingCertChainPEM = ServerSSLCert._setPendingCertChainPEM(self)
        self.setPendingKeyAndCertChainPEM = ServerSSLCert._setPendingKeyAndCertChainPEM(self)
        self.installPendingKeyPair = ServerSSLCert._installPendingKeyPair(self)

# from raritan/rpc/cert/__extend__.py
def upload(agent, certData, keyData=None):
    """
    Method to upload certificates

    - **parameters**, **return**

    :param agent: An agent instance for the device where the certificate should be uploaded
    :param certData: The binary data of the certificate
    :param keyData: The binary data of the key (optional, default: None)
    :return: the response code

    - **Example**
        :Example:

        from raritan import rpc
        from raritan.rpc import cert

        agent = rpc.Agent("https", "my-pdu.example.com", "admin", "raritan")
        ssl_proxy = cert.ServerSSLCert("/server_ssl_cert", agent)

        # read files in binary mode
        certFile = open("my-cert.crt", "rb")
        keyFile = open("my-key.key", "rb")
        # upload
        code = cert.upload(agent, certFile.read(), keyFile.read())
        # view code
        print(code)
    """
    target = "cgi-bin/server_ssl_cert_upload.cgi"
    formdata = [dict(data=certData, filename="cert-file.crt", formname="cert_file", mimetype="application/octet-stream")]
    if keyData:
        formdata.append(dict(data=keyData, filename="key-file.key", formname="key_file", mimetype="application/octet-stream"))
    response = agent.form_data_file(target, formdata)
    # extract the result from "return_code=<code>" from body
    respBody = response["body"].split("=")
    return int(respBody[1])

def download(agent, tag="active_cert"):
    """
    Method to download the server cert

    **parameters**

    :param agent: An agent instance from the device where the certificate file should be downloaded
    :param tag: The tag to define what should be downloaded
    (default: "active_cert", values: "active_cert","active_key","new_cert","new_key","new_req")
    :return: returns the certificate data

    **Example**
        :Example:

        from raritan import rpc
        from raritan.rpc import cert

        agent = rpc.Agent("https", "my-pdu.example.com", "admin", "raritan")
        # download
        cert = cert.download(agent, "active_cert")
        print(cert)
    """
    target = "cgi-bin/server_ssl_cert_download.cgi?tag=%s" % tag
    return agent.get(target)
