# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "Sx.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.sx


# interface
class Sx(Interface):
    idlType = "sx.Sx:1.0.0"

    # structure
    class ClientInfo(Structure):
        idlType = "sx.Sx.ClientInfo:1.0.0"
        elements = ["portId", "portName", "userName", "userIp"]

        def __init__(self, portId="", portName="", userName="", userIp=""):
            if not typecheck._is_int(portId):
                typecheck.is_string(portId, AssertionError)
            if not typecheck._is_int(portName):
                typecheck.is_string(portName, AssertionError)
            if not typecheck._is_int(userName):
                typecheck.is_string(userName, AssertionError)
            if not typecheck._is_int(userIp):
                typecheck.is_string(userIp, AssertionError)

            self.portId = portId
            self.portName = portName
            self.userName = userName
            self.userIp = userIp

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                portId = json['portId'] if 'portId' in json or not useDefaults else "",
                portName = json['portName'] if 'portName' in json or not useDefaults else "",
                userName = json['userName'] if 'userName' in json or not useDefaults else "",
                userIp = json['userIp'] if 'userIp' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['portId'] = str(self.portId)
            json['portName'] = str(self.portName)
            json['userName'] = str(self.userName)
            json['userIp'] = str(self.userIp)
            return json

    # value object
    class ClientConnectionStatusEvent(raritan.rpc.event.UserEvent):
        idlType = "sx.Sx.ClientConnectionStatusEvent:1.0.0"

        def __init__(self, clientInfo=None, status=False, clientCnt=0, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.sx.Sx.ClientConnectionStatusEvent, self).__init__(actUserName, actIpAddr, source)
            if clientInfo is None:
                clientInfo = raritan.rpc.sx.Sx.ClientInfo()
            typecheck.is_struct(clientInfo, raritan.rpc.sx.Sx.ClientInfo, AssertionError)
            typecheck.is_bool(status, AssertionError)
            typecheck.is_int(clientCnt, AssertionError)

            self.clientInfo = clientInfo
            self.status = status
            self.clientCnt = clientCnt

        def encode(self):
            json = super(raritan.rpc.sx.Sx.ClientConnectionStatusEvent, self).encode()
            json['clientInfo'] = raritan.rpc.sx.Sx.ClientInfo.encode(self.clientInfo)
            json['status'] = self.status
            json['clientCnt'] = self.clientCnt
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                clientInfo = raritan.rpc.sx.Sx.ClientInfo.decode(json['clientInfo'], agent, useDefaults=useDefaults) if 'clientInfo' in json or not useDefaults else raritan.rpc.sx.Sx.ClientInfo(),
                status = json['status'] if 'status' in json or not useDefaults else False,
                clientCnt = json['clientCnt'] if 'clientCnt' in json or not useDefaults else 0,
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["clientInfo", "status", "clientCnt"]
            elements = elements + super(raritan.rpc.sx.Sx.ClientConnectionStatusEvent, self).listElements()
            return elements
