# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "TestDisplay.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.test


# interface
class Display(Interface):
    idlType = "test.Display:2.0.0"

    # enumeration
    class Orientation(Enumeration):
        idlType = "test.Display_2_0_0.Orientation:1.0.0"
        values = ["NORMAL", "FLIPPED", "LEFT", "RIGHT"]

    Orientation.NORMAL = Orientation(0)
    Orientation.FLIPPED = Orientation(1)
    Orientation.LEFT = Orientation(2)
    Orientation.RIGHT = Orientation(3)

    # structure
    class Info(Structure):
        idlType = "test.Display_2_0_0.Info:1.0.0"
        elements = ["type", "address", "options", "orientation"]

        def __init__(self, type="", address="", options={}, orientation=None):
            if orientation is None:
                orientation = raritan.rpc.test.Display.Orientation.NORMAL
            if not typecheck._is_int(type):
                typecheck.is_string(type, AssertionError)
            if not typecheck._is_int(address):
                typecheck.is_string(address, AssertionError)
            typecheck.is_enum(orientation, raritan.rpc.test.Display.Orientation, AssertionError)

            self.type = type
            self.address = address
            self.options = options
            self.orientation = orientation

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                type = json['type'] if 'type' in json or not useDefaults else "",
                address = json['address'] if 'address' in json or not useDefaults else "",
                options = dict([(
                    elem['key'],
                    elem['value'])
                    for elem in json['options']]) if 'options' in json or not useDefaults else {},
                orientation = raritan.rpc.test.Display.Orientation.decode(json['orientation']) if 'orientation' in json or not useDefaults else raritan.rpc.test.Display.Orientation.NORMAL,
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = str(self.type)
            json['address'] = str(self.address)
            json['options'] = [dict(
                key = str(k),
                value = str(v))
                for k, v in self.options.items()]
            json['orientation'] = raritan.rpc.test.Display.Orientation.encode(self.orientation)
            return json

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.test.Display.Info.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.test.Display.Info, DecodeException)
            return _ret_

    class _testSequence(Interface.Method):
        name = 'testSequence'

        @staticmethod
        def encode(cycleTime_ms):
            typecheck.is_int(cycleTime_ms, AssertionError)
            args = {}
            args['cycleTime_ms'] = cycleTime_ms
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    # enumeration
    class TestStatus(Enumeration):
        idlType = "test.Display_2_0_0.TestStatus:1.0.0"
        values = ["TEST_IDLE", "TEST_BUSY", "TEST_PASSED", "TEST_FAILED"]

    TestStatus.TEST_IDLE = TestStatus(0)
    TestStatus.TEST_BUSY = TestStatus(1)
    TestStatus.TEST_PASSED = TestStatus(2)
    TestStatus.TEST_FAILED = TestStatus(3)

    class _enterTestMode(Interface.Method):
        name = 'enterTestMode'

        @staticmethod
        def encode(showColorNames):
            typecheck.is_bool(showColorNames, AssertionError)
            args = {}
            args['showColorNames'] = showColorNames
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _getTestStatus(Interface.Method):
        name = 'getTestStatus'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.test.Display.TestStatus.decode(rsp['_ret_'])
            typecheck.is_enum(_ret_, raritan.rpc.test.Display.TestStatus, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Display, self).__init__(target, agent)
        self.getInfo = Display._getInfo(self)
        self.testSequence = Display._testSequence(self)
        self.enterTestMode = Display._enterTestMode(self)
        self.getTestStatus = Display._getTestStatus(self)

#
# Section generated by IdlC from "TestUnit.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.test


# interface
class Unit(Interface):
    idlType = "test.Unit:2.0.0"

    class _getDisplays(Interface.Method):
        name = 'getDisplays'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.test.Display, DecodeException)
            return _ret_

    class _getButtonStates(Interface.Method):
        name = 'getButtonStates'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_bool(x0, DecodeException)
            return _ret_

    class _setBuzzer(Interface.Method):
        name = 'setBuzzer'

        @staticmethod
        def encode(isOn):
            typecheck.is_bool(isOn, AssertionError)
            args = {}
            args['isOn'] = isOn
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _resetAllSubControllers(Interface.Method):
        name = 'resetAllSubControllers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _triggerSubControllerWatchdog(Interface.Method):
        name = 'triggerSubControllerWatchdog'

        @staticmethod
        def encode(rs485Addr):
            typecheck.is_int(rs485Addr, AssertionError)
            args = {}
            args['rs485Addr'] = rs485Addr
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None
    def __init__(self, target, agent):
        super(Unit, self).__init__(target, agent)
        self.getDisplays = Unit._getDisplays(self)
        self.getButtonStates = Unit._getButtonStates(self)
        self.setBuzzer = Unit._setBuzzer(self)
        self.resetAllSubControllers = Unit._resetAllSubControllers(self)
        self.triggerSubControllerWatchdog = Unit._triggerSubControllerWatchdog(self)
