// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2012 Raritan Inc. All rights reserved.

package com.raritan.idl;

public class RpcCtrl {

    public enum Bulk { ALLOW, FORBID };

    private Bulk bulk;

    private static RpcCtrl defaultInst = new RpcCtrl();

    public RpcCtrl() {
        this(Bulk.ALLOW);
    }

    public RpcCtrl(Bulk bulk) {
        this.bulk = bulk;
    }

    public static RpcCtrl getDefault() {
        return defaultInst;
    }

    public Bulk getBulk() {
        return bulk;
    }

}
