// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from AssetStrip.idl.

package com.raritan.idl.assetmgrmodel;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface AssetStrip {
  static public final TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStrip:1.0.0", null);

  public static final int NO_ERROR = 0;

  public static final int ERR_INVALID_PARAM = 1;

  public static final int ERR_NOT_AVAILABLE = 2;

  public static final int ERR_NO_SUCH_OBJECT = 3;

  public enum Events {
    EVT_KEY_STATE_CHANGED,
    EVT_KEY_SETTINGS_CHANGED,
    EVT_KEY_TAGS_CHANGED;
  }

  public enum State {
    DISCONNECTED,
    FIRMWARE_UPDATE,
    UNSUPPORTED,
    AVAILABLE;
  }

  public enum LEDOperationMode {
    LED_OPERATION_MANUAL,
    LED_OPERATION_AUTO;
  }

  public enum LEDMode {
    LED_MODE_ON,
    LED_MODE_OFF,
    LED_MODE_BLINK_FAST,
    LED_MODE_BLINK_SLOW;
  }

  public enum Orientation {
    TOP_CONNECTOR,
    BOTTOM_CONNECTOR,
    UNKNOWN_ORIENTATION;
  }

  public enum NumberingMode {
    TOP_DOWN,
    BOTTOM_UP;
  }

  public enum ScanMode {
    SCANMODE_DISABLED,
    SCANMODE_BOTH;
  }

  static public class DeviceInfo implements Cloneable {
    public int deviceId = 0;
    public int hardwareId = 0;
    public int protocolVersion = 0;
    public int bootVersion = 0;
    public int appVersion = 0;

    public Object clone() {
      DeviceInfo copy = new DeviceInfo();

      copy.deviceId = this.deviceId;
      copy.hardwareId = this.hardwareId;
      copy.protocolVersion = this.protocolVersion;
      copy.bootVersion = this.bootVersion;
      copy.appVersion = this.appVersion;

      return copy;
    }

  }

  static public class TagInfo implements Cloneable {
    public int channel = 0;
    public String familyDesc = new String();
    public String rawId = new String();

    public Object clone() {
      TagInfo copy = new TagInfo();

      copy.channel = this.channel;
      copy.familyDesc = this.familyDesc;
      copy.rawId = this.rawId;

      return copy;
    }

  }

  static public class LEDColor implements Cloneable {
    public int r = 0;
    public int g = 0;
    public int b = 0;

    public Object clone() {
      LEDColor copy = new LEDColor();

      copy.r = this.r;
      copy.g = this.g;
      copy.b = this.b;

      return copy;
    }

  }

  static public class StripSettings implements Cloneable {
    public int channelCount = 0;
    public String name = new String();
    public com.raritan.idl.assetmgrmodel.AssetStrip.ScanMode scanMode = com.raritan.idl.assetmgrmodel.AssetStrip.ScanMode.values()[0];
    public com.raritan.idl.assetmgrmodel.AssetStrip.LEDColor defaultColorConnected = new com.raritan.idl.assetmgrmodel.AssetStrip.LEDColor();
    public com.raritan.idl.assetmgrmodel.AssetStrip.LEDColor defaultColorDisconnected = new com.raritan.idl.assetmgrmodel.AssetStrip.LEDColor();
    public com.raritan.idl.assetmgrmodel.AssetStrip.NumberingMode numberingMode = com.raritan.idl.assetmgrmodel.AssetStrip.NumberingMode.values()[0];
    public int numberingOffset = 0;
    public boolean orientationSensAvailable = false;
    public com.raritan.idl.assetmgrmodel.AssetStrip.Orientation orientation = com.raritan.idl.assetmgrmodel.AssetStrip.Orientation.values()[0];

    public Object clone() {
      StripSettings copy = new StripSettings();

      copy.channelCount = this.channelCount;
      copy.name = this.name;
      copy.scanMode = this.scanMode;
      Object defaultColorConnectedCopy = this.defaultColorConnected.clone();
      copy.defaultColorConnected = (com.raritan.idl.assetmgrmodel.AssetStrip.LEDColor) defaultColorConnectedCopy;
      Object defaultColorDisconnectedCopy = this.defaultColorDisconnected.clone();
      copy.defaultColorDisconnected = (com.raritan.idl.assetmgrmodel.AssetStrip.LEDColor) defaultColorDisconnectedCopy;
      copy.numberingMode = this.numberingMode;
      copy.numberingOffset = this.numberingOffset;
      copy.orientationSensAvailable = this.orientationSensAvailable;
      copy.orientation = this.orientation;

      return copy;
    }

  }

  static public class RackUnitSettings implements Cloneable {
    public com.raritan.idl.assetmgrmodel.AssetStrip.LEDOperationMode opmode = com.raritan.idl.assetmgrmodel.AssetStrip.LEDOperationMode.values()[0];
    public com.raritan.idl.assetmgrmodel.AssetStrip.LEDMode mode = com.raritan.idl.assetmgrmodel.AssetStrip.LEDMode.values()[0];
    public com.raritan.idl.assetmgrmodel.AssetStrip.LEDColor color = new com.raritan.idl.assetmgrmodel.AssetStrip.LEDColor();

    public Object clone() {
      RackUnitSettings copy = new RackUnitSettings();

      copy.opmode = this.opmode;
      copy.mode = this.mode;
      Object colorCopy = this.color.clone();
      copy.color = (com.raritan.idl.assetmgrmodel.AssetStrip.LEDColor) colorCopy;

      return copy;
    }

  }

  static public class RackUnitInfo implements Cloneable {
    public int channel = 0;
    public int rackUnitPosition = 0;
    public com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings settings = new com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings();

    public Object clone() {
      RackUnitInfo copy = new RackUnitInfo();

      copy.channel = this.channel;
      copy.rackUnitPosition = this.rackUnitPosition;
      Object settingsCopy = this.settings.clone();
      copy.settings = (com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings) settingsCopy;

      return copy;
    }

  }

  public class GetStateResult {
    public com.raritan.idl.assetmgrmodel.AssetStrip.State _ret_;
  }

  GetStateResult getState() throws Exception;

  AsyncRequest getState(AsyncRpcResponse<GetStateResult> rsp);

  AsyncRequest getState(AsyncRpcResponse<GetStateResult> rsp, RpcCtrl rpcCtrl);


  public class GetDeviceInfoResult {
    public int _ret_;
    public com.raritan.idl.assetmgrmodel.AssetStrip.DeviceInfo info;
  }

  GetDeviceInfoResult getDeviceInfo() throws Exception;

  AsyncRequest getDeviceInfo(AsyncRpcResponse<GetDeviceInfoResult> rsp);

  AsyncRequest getDeviceInfo(AsyncRpcResponse<GetDeviceInfoResult> rsp, RpcCtrl rpcCtrl);


  public class GetStripSettingsResult {
    public com.raritan.idl.assetmgrmodel.AssetStrip.StripSettings _ret_;
  }

  GetStripSettingsResult getStripSettings() throws Exception;

  AsyncRequest getStripSettings(AsyncRpcResponse<GetStripSettingsResult> rsp);

  AsyncRequest getStripSettings(AsyncRpcResponse<GetStripSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetStripSettingsResult {
    public int _ret_;
  }

  SetStripSettingsResult setStripSettings(com.raritan.idl.assetmgrmodel.AssetStrip.StripSettings settings) throws Exception;

  AsyncRequest setStripSettings(com.raritan.idl.assetmgrmodel.AssetStrip.StripSettings settings, AsyncRpcResponse<SetStripSettingsResult> rsp);

  AsyncRequest setStripSettings(com.raritan.idl.assetmgrmodel.AssetStrip.StripSettings settings, AsyncRpcResponse<SetStripSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetRackUnitSettingsResult {
    public int _ret_;
  }

  SetRackUnitSettingsResult setRackUnitSettings(int channel, com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings settings) throws Exception;

  AsyncRequest setRackUnitSettings(int channel, com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings settings, AsyncRpcResponse<SetRackUnitSettingsResult> rsp);

  AsyncRequest setRackUnitSettings(int channel, com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings settings, AsyncRpcResponse<SetRackUnitSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetMultipleRackUnitSettingsResult {
    public int _ret_;
  }

  SetMultipleRackUnitSettingsResult setMultipleRackUnitSettings(java.util.List<Integer> channels, java.util.List<com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings> settings) throws Exception;

  AsyncRequest setMultipleRackUnitSettings(java.util.List<Integer> channels, java.util.List<com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings> settings, AsyncRpcResponse<SetMultipleRackUnitSettingsResult> rsp);

  AsyncRequest setMultipleRackUnitSettings(java.util.List<Integer> channels, java.util.List<com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitSettings> settings, AsyncRpcResponse<SetMultipleRackUnitSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetRackUnitInfoResult {
    public int _ret_;
    public com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitInfo info;
  }

  GetRackUnitInfoResult getRackUnitInfo(int channel) throws Exception;

  AsyncRequest getRackUnitInfo(int channel, AsyncRpcResponse<GetRackUnitInfoResult> rsp);

  AsyncRequest getRackUnitInfo(int channel, AsyncRpcResponse<GetRackUnitInfoResult> rsp, RpcCtrl rpcCtrl);


  public class GetAllRackUnitInfosResult {
    public java.util.List<com.raritan.idl.assetmgrmodel.AssetStrip.RackUnitInfo> _ret_;
  }

  GetAllRackUnitInfosResult getAllRackUnitInfos() throws Exception;

  AsyncRequest getAllRackUnitInfos(AsyncRpcResponse<GetAllRackUnitInfosResult> rsp);

  AsyncRequest getAllRackUnitInfos(AsyncRpcResponse<GetAllRackUnitInfosResult> rsp, RpcCtrl rpcCtrl);


  public class GetTagResult {
    public int _ret_;
    public com.raritan.idl.assetmgrmodel.AssetStrip.TagInfo tagInfo;
  }

  GetTagResult getTag(int channel) throws Exception;

  AsyncRequest getTag(int channel, AsyncRpcResponse<GetTagResult> rsp);

  AsyncRequest getTag(int channel, AsyncRpcResponse<GetTagResult> rsp, RpcCtrl rpcCtrl);


  public class GetAllTagsResult {
    public int _ret_;
    public java.util.List<com.raritan.idl.assetmgrmodel.AssetStrip.TagInfo> tags;
  }

  GetAllTagsResult getAllTags() throws Exception;

  AsyncRequest getAllTags(AsyncRpcResponse<GetAllTagsResult> rsp);

  AsyncRequest getAllTags(AsyncRpcResponse<GetAllTagsResult> rsp, RpcCtrl rpcCtrl);


  public class TriggerPowercycleResult {
    public int _ret_;
  }

  TriggerPowercycleResult triggerPowercycle(boolean hard) throws Exception;

  AsyncRequest triggerPowercycle(boolean hard, AsyncRpcResponse<TriggerPowercycleResult> rsp);

  AsyncRequest triggerPowercycle(boolean hard, AsyncRpcResponse<TriggerPowercycleResult> rsp, RpcCtrl rpcCtrl);

}
