// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from LdapManager.idl.

package com.raritan.idl.auth;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface LdapManager_5_0_0 {
  static public final TypeInfo typeInfo = new TypeInfo("auth.LdapManager:5.0.0", null);

  public enum ServerType {
    ACTIVE_DIRECTORY,
    OPEN_LDAP;
  }

  public enum SecurityProtocol {
    SEC_PROTO_NONE,
    SEC_PROTO_SSL,
    SEC_PROTO_STARTTLS;
  }

  static public class ServerSettings implements Cloneable {
    public String server = new String();
    public com.raritan.idl.auth.LdapManager_5_0_0.ServerType type = com.raritan.idl.auth.LdapManager_5_0_0.ServerType.values()[0];
    public com.raritan.idl.auth.LdapManager_5_0_0.SecurityProtocol secProto = com.raritan.idl.auth.LdapManager_5_0_0.SecurityProtocol.values()[0];
    public int port = 0;
    public int sslPort = 0;
    public boolean forceTrustedCert = false;
    public boolean allowOffTimeRangeCerts = false;
    public String certificate = new String();
    public String adsDomain = new String();
    public boolean useAnonymousBind = false;
    public String bindDN = new String();
    public String bindPwd = new String();
    public String searchBaseDN = new String();
    public String loginNameAttr = new String();
    public String userEntryObjClass = new String();
    public String userSearchFilter = new String();
    public boolean groupInfoInUserEntry = false;
    public boolean supportNestedGroups = false;
    public String groupMemberAttr = new String();
    public String groupEntryObjClass = new String();
    public String groupSearchFilter = new String();

    public Object clone() {
      ServerSettings copy = new ServerSettings();

      copy.server = this.server;
      copy.type = this.type;
      copy.secProto = this.secProto;
      copy.port = this.port;
      copy.sslPort = this.sslPort;
      copy.forceTrustedCert = this.forceTrustedCert;
      copy.allowOffTimeRangeCerts = this.allowOffTimeRangeCerts;
      copy.certificate = this.certificate;
      copy.adsDomain = this.adsDomain;
      copy.useAnonymousBind = this.useAnonymousBind;
      copy.bindDN = this.bindDN;
      copy.bindPwd = this.bindPwd;
      copy.searchBaseDN = this.searchBaseDN;
      copy.loginNameAttr = this.loginNameAttr;
      copy.userEntryObjClass = this.userEntryObjClass;
      copy.userSearchFilter = this.userSearchFilter;
      copy.groupInfoInUserEntry = this.groupInfoInUserEntry;
      copy.supportNestedGroups = this.supportNestedGroups;
      copy.groupMemberAttr = this.groupMemberAttr;
      copy.groupEntryObjClass = this.groupEntryObjClass;
      copy.groupSearchFilter = this.groupSearchFilter;

      return copy;
    }

  }

  public class GetLdapServersResult {
    public java.util.List<com.raritan.idl.auth.LdapManager_5_0_0.ServerSettings> _ret_;
  }

  GetLdapServersResult getLdapServers() throws Exception;

  AsyncRequest getLdapServers(AsyncRpcResponse<GetLdapServersResult> rsp);

  AsyncRequest getLdapServers(AsyncRpcResponse<GetLdapServersResult> rsp, RpcCtrl rpcCtrl);


  public static final int ERR_CYCLIC_DEP = 1;

  public static final int ERR_INVALID_CFG = 2;

  public class SetLdapServersResult {
    public int _ret_;
  }

  SetLdapServersResult setLdapServers(java.util.List<com.raritan.idl.auth.LdapManager_5_0_0.ServerSettings> serverList) throws Exception;

  AsyncRequest setLdapServers(java.util.List<com.raritan.idl.auth.LdapManager_5_0_0.ServerSettings> serverList, AsyncRpcResponse<SetLdapServersResult> rsp);

  AsyncRequest setLdapServers(java.util.List<com.raritan.idl.auth.LdapManager_5_0_0.ServerSettings> serverList, AsyncRpcResponse<SetLdapServersResult> rsp, RpcCtrl rpcCtrl);


  public static final int ERR_SERVER_UNSPECIFIED = 1;

  public static final int ERR_SERVER_UNREACHABLE = 3;

  public static final int ERR_AUTHENTICATION_FAILED = 4;

  public static final int ERR_NO_ROLES = 5;

  public static final int ERR_NO_KNOWN_ROLES = 6;

  public class TestLdapServerResult {
    public int _ret_;
    public String diagMsg;
  }

  TestLdapServerResult testLdapServer(String username, String password, com.raritan.idl.auth.LdapManager_5_0_0.ServerSettings settings) throws Exception;

  AsyncRequest testLdapServer(String username, String password, com.raritan.idl.auth.LdapManager_5_0_0.ServerSettings settings, AsyncRpcResponse<TestLdapServerResult> rsp);

  AsyncRequest testLdapServer(String username, String password, com.raritan.idl.auth.LdapManager_5_0_0.ServerSettings settings, AsyncRpcResponse<TestLdapServerResult> rsp, RpcCtrl rpcCtrl);

}
