// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ServerSSLCert.idl.

package com.raritan.idl.cert;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface ServerSSLCert_3_0_0 {
  static public final TypeInfo typeInfo = new TypeInfo("cert.ServerSSLCert:3.0.0", null);

  public static final int SUCCESS = 0;

  public static final int ERR_GEN_KEY_LEN_INVALID = 100;

  public static final int ERR_GEN_CSR_OR_CERT_PENDING = 101;

  public static final int ERR_GEN_KEY_GEN_FAILED = 102;

  public static final int ERR_GEN_KEY_TYPE_INVALID = 103;

  public static final int ERR_GEN_ELLIPTIC_CURVE_INVALID = 104;

  public static final int ERR_INSTALL_KEY_MISSING = 200;

  public static final int ERR_INSTALL_CERT_MISSING = 201;

  public static final int ERR_INSTALL_CERT_FORMAT_INVALID = 202;

  public static final int ERR_INSTALL_CERT_KEY_MISMATCH = 203;

  public static final int ERR_INSTALL_KEY_FORMAT_INVALID = 204;

  static public class CommonAttributes implements Cloneable {
    public String country = new String();
    public String stateOrProvince = new String();
    public String locality = new String();
    public String organization = new String();
    public String organizationalUnit = new String();
    public String commonName = new String();
    public String emailAddress = new String();

    public Object clone() {
      CommonAttributes copy = new CommonAttributes();

      copy.country = this.country;
      copy.stateOrProvince = this.stateOrProvince;
      copy.locality = this.locality;
      copy.organization = this.organization;
      copy.organizationalUnit = this.organizationalUnit;
      copy.commonName = this.commonName;
      copy.emailAddress = this.emailAddress;

      return copy;
    }

  }

  public enum KeyType {
    KEY_TYPE_UNKNOWN,
    KEY_TYPE_RSA,
    KEY_TYPE_ECDSA;
  }

  public enum EllipticCurve {
    EC_CURVE_UNKNOWN,
    EC_CURVE_NIST_P256,
    EC_CURVE_NIST_P384,
    EC_CURVE_NIST_P521;
  }

  static public class ReqInfo implements Cloneable {
    public com.raritan.idl.cert.ServerSSLCert_3_0_0.CommonAttributes subject = new com.raritan.idl.cert.ServerSSLCert_3_0_0.CommonAttributes();
    public java.util.List<String> names = new java.util.ArrayList<>();
    public com.raritan.idl.cert.ServerSSLCert_3_0_0.KeyType keyType = com.raritan.idl.cert.ServerSSLCert_3_0_0.KeyType.values()[0];
    public com.raritan.idl.cert.ServerSSLCert_3_0_0.EllipticCurve ellipticCurve = com.raritan.idl.cert.ServerSSLCert_3_0_0.EllipticCurve.values()[0];
    public int rsaKeyLength = 0;

    public Object clone() {
      ReqInfo copy = new ReqInfo();

      Object subjectCopy = this.subject.clone();
      copy.subject = (com.raritan.idl.cert.ServerSSLCert_3_0_0.CommonAttributes) subjectCopy;
      copy.names = new java.util.ArrayList<String>(this.names);
      copy.keyType = this.keyType;
      copy.ellipticCurve = this.ellipticCurve;
      copy.rsaKeyLength = this.rsaKeyLength;

      return copy;
    }

  }

  static public class CertInfo implements Cloneable {
    public com.raritan.idl.cert.ServerSSLCert_3_0_0.CommonAttributes subject = new com.raritan.idl.cert.ServerSSLCert_3_0_0.CommonAttributes();
    public com.raritan.idl.cert.ServerSSLCert_3_0_0.CommonAttributes issuer = new com.raritan.idl.cert.ServerSSLCert_3_0_0.CommonAttributes();
    public java.util.List<String> names = new java.util.ArrayList<>();
    public String invalidBefore = new String();
    public String invalidAfter = new String();
    public String serialNumber = new String();
    public com.raritan.idl.cert.ServerSSLCert_3_0_0.KeyType keyType = com.raritan.idl.cert.ServerSSLCert_3_0_0.KeyType.values()[0];
    public com.raritan.idl.cert.ServerSSLCert_3_0_0.EllipticCurve ellipticCurve = com.raritan.idl.cert.ServerSSLCert_3_0_0.EllipticCurve.values()[0];
    public int rsaKeyLength = 0;

    public Object clone() {
      CertInfo copy = new CertInfo();

      Object subjectCopy = this.subject.clone();
      copy.subject = (com.raritan.idl.cert.ServerSSLCert_3_0_0.CommonAttributes) subjectCopy;
      Object issuerCopy = this.issuer.clone();
      copy.issuer = (com.raritan.idl.cert.ServerSSLCert_3_0_0.CommonAttributes) issuerCopy;
      copy.names = new java.util.ArrayList<String>(this.names);
      copy.invalidBefore = this.invalidBefore;
      copy.invalidAfter = this.invalidAfter;
      copy.serialNumber = this.serialNumber;
      copy.keyType = this.keyType;
      copy.ellipticCurve = this.ellipticCurve;
      copy.rsaKeyLength = this.rsaKeyLength;

      return copy;
    }

  }

  static public class Info implements Cloneable {
    public boolean havePendingReq = false;
    public boolean havePendingCert = false;
    public com.raritan.idl.cert.ServerSSLCert_3_0_0.ReqInfo pendingReqInfo = new com.raritan.idl.cert.ServerSSLCert_3_0_0.ReqInfo();
    public com.raritan.idl.cert.ServerSSLCert_3_0_0.CertInfo pendingCertInfo = new com.raritan.idl.cert.ServerSSLCert_3_0_0.CertInfo();
    public java.util.List<com.raritan.idl.cert.ServerSSLCert_3_0_0.CertInfo> pendingCertChainInfos = new java.util.ArrayList<>();
    public com.raritan.idl.cert.ServerSSLCert_3_0_0.CertInfo activeCertInfo = new com.raritan.idl.cert.ServerSSLCert_3_0_0.CertInfo();
    public java.util.List<com.raritan.idl.cert.ServerSSLCert_3_0_0.CertInfo> activeCertChainInfos = new java.util.ArrayList<>();
    public int maxSignDays = 0;

    public Object clone() {
      Info copy = new Info();

      copy.havePendingReq = this.havePendingReq;
      copy.havePendingCert = this.havePendingCert;
      Object pendingReqInfoCopy = this.pendingReqInfo.clone();
      copy.pendingReqInfo = (com.raritan.idl.cert.ServerSSLCert_3_0_0.ReqInfo) pendingReqInfoCopy;
      Object pendingCertInfoCopy = this.pendingCertInfo.clone();
      copy.pendingCertInfo = (com.raritan.idl.cert.ServerSSLCert_3_0_0.CertInfo) pendingCertInfoCopy;
      copy.pendingCertChainInfos = new java.util.ArrayList<com.raritan.idl.cert.ServerSSLCert_3_0_0.CertInfo>(this.pendingCertChainInfos);
      Object activeCertInfoCopy = this.activeCertInfo.clone();
      copy.activeCertInfo = (com.raritan.idl.cert.ServerSSLCert_3_0_0.CertInfo) activeCertInfoCopy;
      copy.activeCertChainInfos = new java.util.ArrayList<com.raritan.idl.cert.ServerSSLCert_3_0_0.CertInfo>(this.activeCertChainInfos);
      copy.maxSignDays = this.maxSignDays;

      return copy;
    }

  }

  public class GenerateUnsignedKeyPairResult {
    public int _ret_;
  }

  GenerateUnsignedKeyPairResult generateUnsignedKeyPair(com.raritan.idl.cert.ServerSSLCert_3_0_0.ReqInfo reqInfo, String challenge) throws Exception;

  AsyncRequest generateUnsignedKeyPair(com.raritan.idl.cert.ServerSSLCert_3_0_0.ReqInfo reqInfo, String challenge, AsyncRpcResponse<GenerateUnsignedKeyPairResult> rsp);

  AsyncRequest generateUnsignedKeyPair(com.raritan.idl.cert.ServerSSLCert_3_0_0.ReqInfo reqInfo, String challenge, AsyncRpcResponse<GenerateUnsignedKeyPairResult> rsp, RpcCtrl rpcCtrl);


  public class GenerateSelfSignedKeyPairResult {
    public int _ret_;
  }

  GenerateSelfSignedKeyPairResult generateSelfSignedKeyPair(com.raritan.idl.cert.ServerSSLCert_3_0_0.ReqInfo reqInfo, int days) throws Exception;

  AsyncRequest generateSelfSignedKeyPair(com.raritan.idl.cert.ServerSSLCert_3_0_0.ReqInfo reqInfo, int days, AsyncRpcResponse<GenerateSelfSignedKeyPairResult> rsp);

  AsyncRequest generateSelfSignedKeyPair(com.raritan.idl.cert.ServerSSLCert_3_0_0.ReqInfo reqInfo, int days, AsyncRpcResponse<GenerateSelfSignedKeyPairResult> rsp, RpcCtrl rpcCtrl);

  Void deletePending() throws Exception;

  AsyncRequest deletePending(AsyncRpcResponse<Void> rsp);

  AsyncRequest deletePending(AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);


  public class GetInfoResult {
    public com.raritan.idl.cert.ServerSSLCert_3_0_0.Info info;
  }

  GetInfoResult getInfo() throws Exception;

  AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult> rsp);

  AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult> rsp, RpcCtrl rpcCtrl);


  public class InstallPendingKeyPairResult {
    public int _ret_;
  }

  InstallPendingKeyPairResult installPendingKeyPair() throws Exception;

  AsyncRequest installPendingKeyPair(AsyncRpcResponse<InstallPendingKeyPairResult> rsp);

  AsyncRequest installPendingKeyPair(AsyncRpcResponse<InstallPendingKeyPairResult> rsp, RpcCtrl rpcCtrl);

}
