// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from SensorLogger.idl.

package com.raritan.idl.pdumodel;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface SensorLogger_2_0_0 {
  static public final TypeInfo typeInfo = new TypeInfo("pdumodel.SensorLogger:2.0.0", null);

  public enum Events {
    EVT_KEY_SETTINGS_CHANGED,
    EVT_KEY_LOGGED_SENSORS_CHANGED;
  }

  static public class Settings implements Cloneable {
    public boolean isEnabled = false;
    public int samplePeriod = 0;
    public int samplesPerRecord = 0;
    public int oldestRecId = 0;
    public int newestRecId = 0;
    public int logCapacity = 0;

    public Object clone() {
      Settings copy = new Settings();

      copy.isEnabled = this.isEnabled;
      copy.samplePeriod = this.samplePeriod;
      copy.samplesPerRecord = this.samplesPerRecord;
      copy.oldestRecId = this.oldestRecId;
      copy.newestRecId = this.newestRecId;
      copy.logCapacity = this.logCapacity;

      return copy;
    }

  }

  public class GetSettingsResult {
    public com.raritan.idl.pdumodel.SensorLogger_2_0_0.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(boolean isEnabled, int samplesPerRecord) throws Exception;

  AsyncRequest setSettings(boolean isEnabled, int samplesPerRecord, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(boolean isEnabled, int samplesPerRecord, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public enum SensorState {
    UNAVAILABLE,
    OPEN,
    CLOSE,
    BELOW_LOWER_CRITICAL,
    BELOW_LOWER_WARNING,
    NORMAL,
    ABOVE_UPPER_WARNING,
    ABOVE_UPPER_CRITICAL,
    ON,
    OFF,
    ALARMED,
    OK,
    MARGINAL,
    FAIL,
    YES,
    NO,
    STANDBY,
    ONE,
    TWO,
    IN_SYNC,
    OUT_OF_SYNC;
  }

  public class GetTimeStampsResult {
    public int _ret_;
    public java.util.List<java.util.Date> timestamps;
  }

  GetTimeStampsResult getTimeStamps(int recid, int count) throws Exception;

  AsyncRequest getTimeStamps(int recid, int count, AsyncRpcResponse<GetTimeStampsResult> rsp);

  AsyncRequest getTimeStamps(int recid, int count, AsyncRpcResponse<GetTimeStampsResult> rsp, RpcCtrl rpcCtrl);


  static public class Record implements Cloneable {
    public boolean available = false;
    public int takenValidSamples = 0;
    public com.raritan.idl.pdumodel.SensorLogger_2_0_0.SensorState state = com.raritan.idl.pdumodel.SensorLogger_2_0_0.SensorState.values()[0];
    public double minValue = 0.0;
    public double avgValue = 0.0;
    public double maxValue = 0.0;

    public Object clone() {
      Record copy = new Record();

      copy.available = this.available;
      copy.takenValidSamples = this.takenValidSamples;
      copy.state = this.state;
      copy.minValue = this.minValue;
      copy.avgValue = this.avgValue;
      copy.maxValue = this.maxValue;

      return copy;
    }

  }

  public class GetSensorRecordsResult {
    public int _ret_;
    public java.util.List<com.raritan.idl.pdumodel.SensorLogger_2_0_0.Record> recs;
  }

  GetSensorRecordsResult getSensorRecords(com.raritan.idl.sensors.Sensor_3_0_0 sensor, int recid, int count) throws Exception;

  AsyncRequest getSensorRecords(com.raritan.idl.sensors.Sensor_3_0_0 sensor, int recid, int count, AsyncRpcResponse<GetSensorRecordsResult> rsp);

  AsyncRequest getSensorRecords(com.raritan.idl.sensors.Sensor_3_0_0 sensor, int recid, int count, AsyncRpcResponse<GetSensorRecordsResult> rsp, RpcCtrl rpcCtrl);


  public class GetExternalSensorRecordsResult {
    public int _ret_;
    public java.util.List<com.raritan.idl.pdumodel.SensorLogger_2_0_0.Record> recs;
  }

  GetExternalSensorRecordsResult getExternalSensorRecords(com.raritan.idl.sensors.ExternalSensorSlot_3_0_0 extsensor, int recid, int count) throws Exception;

  AsyncRequest getExternalSensorRecords(com.raritan.idl.sensors.ExternalSensorSlot_3_0_0 extsensor, int recid, int count, AsyncRpcResponse<GetExternalSensorRecordsResult> rsp);

  AsyncRequest getExternalSensorRecords(com.raritan.idl.sensors.ExternalSensorSlot_3_0_0 extsensor, int recid, int count, AsyncRpcResponse<GetExternalSensorRecordsResult> rsp, RpcCtrl rpcCtrl);


  static public class TimedRecord implements Cloneable {
    public java.util.Date timestamp = new java.util.Date();
    public com.raritan.idl.pdumodel.SensorLogger_2_0_0.Record record = new com.raritan.idl.pdumodel.SensorLogger_2_0_0.Record();

    public Object clone() {
      TimedRecord copy = new TimedRecord();

      copy.timestamp = this.timestamp;
      Object recordCopy = this.record.clone();
      copy.record = (com.raritan.idl.pdumodel.SensorLogger_2_0_0.Record) recordCopy;

      return copy;
    }

  }

  public class GetSensorTimedRecordsResult {
    public int _ret_;
    public java.util.List<com.raritan.idl.pdumodel.SensorLogger_2_0_0.TimedRecord> recs;
  }

  GetSensorTimedRecordsResult getSensorTimedRecords(com.raritan.idl.sensors.Sensor_3_0_0 sensor, int recid, int count) throws Exception;

  AsyncRequest getSensorTimedRecords(com.raritan.idl.sensors.Sensor_3_0_0 sensor, int recid, int count, AsyncRpcResponse<GetSensorTimedRecordsResult> rsp);

  AsyncRequest getSensorTimedRecords(com.raritan.idl.sensors.Sensor_3_0_0 sensor, int recid, int count, AsyncRpcResponse<GetSensorTimedRecordsResult> rsp, RpcCtrl rpcCtrl);


  public class GetExtSensorTimedRecordsResult {
    public int _ret_;
    public java.util.List<com.raritan.idl.pdumodel.SensorLogger_2_0_0.TimedRecord> recs;
  }

  GetExtSensorTimedRecordsResult getExtSensorTimedRecords(com.raritan.idl.sensors.ExternalSensorSlot_3_0_0 extsensor, int recid, int count) throws Exception;

  AsyncRequest getExtSensorTimedRecords(com.raritan.idl.sensors.ExternalSensorSlot_3_0_0 extsensor, int recid, int count, AsyncRpcResponse<GetExtSensorTimedRecordsResult> rsp);

  AsyncRequest getExtSensorTimedRecords(com.raritan.idl.sensors.ExternalSensorSlot_3_0_0 extsensor, int recid, int count, AsyncRpcResponse<GetExtSensorTimedRecordsResult> rsp, RpcCtrl rpcCtrl);


  static public class SensorSet implements Cloneable {
    public java.util.List<com.raritan.idl.sensors.Sensor_3_0_0> sensors = new java.util.ArrayList<>();
    public java.util.List<com.raritan.idl.sensors.ExternalSensorSlot_3_0_0> extsens = new java.util.ArrayList<>();

    public Object clone() {
      SensorSet copy = new SensorSet();

      copy.sensors = new java.util.ArrayList<com.raritan.idl.sensors.Sensor_3_0_0>(this.sensors);
      copy.extsens = new java.util.ArrayList<com.raritan.idl.sensors.ExternalSensorSlot_3_0_0>(this.extsens);

      return copy;
    }

  }

  public class GetLoggedSensorsResult {
    public com.raritan.idl.pdumodel.SensorLogger_2_0_0.SensorSet _ret_;
  }

  GetLoggedSensorsResult getLoggedSensors() throws Exception;

  AsyncRequest getLoggedSensors(AsyncRpcResponse<GetLoggedSensorsResult> rsp);

  AsyncRequest getLoggedSensors(AsyncRpcResponse<GetLoggedSensorsResult> rsp, RpcCtrl rpcCtrl);


  public class SetLoggedSensorsResult {
    public int _ret_;
  }

  SetLoggedSensorsResult setLoggedSensors(com.raritan.idl.pdumodel.SensorLogger_2_0_0.SensorSet sensors) throws Exception;

  AsyncRequest setLoggedSensors(com.raritan.idl.pdumodel.SensorLogger_2_0_0.SensorSet sensors, AsyncRpcResponse<SetLoggedSensorsResult> rsp);

  AsyncRequest setLoggedSensors(com.raritan.idl.pdumodel.SensorLogger_2_0_0.SensorSet sensors, AsyncRpcResponse<SetLoggedSensorsResult> rsp, RpcCtrl rpcCtrl);

  Void enableAllSensors() throws Exception;

  AsyncRequest enableAllSensors(AsyncRpcResponse<Void> rsp);

  AsyncRequest enableAllSensors(AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);

  Void disableAllSensors() throws Exception;

  AsyncRequest disableAllSensors(AsyncRpcResponse<Void> rsp);

  AsyncRequest disableAllSensors(AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);


  public class GetSensorSetTimestampResult {
    public java.util.Date _ret_;
  }

  GetSensorSetTimestampResult getSensorSetTimestamp() throws Exception;

  AsyncRequest getSensorSetTimestamp(AsyncRpcResponse<GetSensorSetTimestampResult> rsp);

  AsyncRequest getSensorSetTimestamp(AsyncRpcResponse<GetSensorSetTimestampResult> rsp, RpcCtrl rpcCtrl);


  static public class LogRow implements Cloneable {
    public java.util.Date sensorSetTimestamp = new java.util.Date();
    public java.util.Date timestamp = new java.util.Date();
    public java.util.List<com.raritan.idl.pdumodel.SensorLogger_2_0_0.Record> sensorRecords = new java.util.ArrayList<>();
    public java.util.List<com.raritan.idl.pdumodel.SensorLogger_2_0_0.Record> extsensRecords = new java.util.ArrayList<>();

    public Object clone() {
      LogRow copy = new LogRow();

      copy.sensorSetTimestamp = this.sensorSetTimestamp;
      copy.timestamp = this.timestamp;
      copy.sensorRecords = new java.util.ArrayList<com.raritan.idl.pdumodel.SensorLogger_2_0_0.Record>(this.sensorRecords);
      copy.extsensRecords = new java.util.ArrayList<com.raritan.idl.pdumodel.SensorLogger_2_0_0.Record>(this.extsensRecords);

      return copy;
    }

  }

  public class GetLogRowResult {
    public int _ret_;
    public com.raritan.idl.pdumodel.SensorLogger_2_0_0.LogRow row;
  }

  GetLogRowResult getLogRow(int recid) throws Exception;

  AsyncRequest getLogRow(int recid, AsyncRpcResponse<GetLogRowResult> rsp);

  AsyncRequest getLogRow(int recid, AsyncRpcResponse<GetLogRowResult> rsp, RpcCtrl rpcCtrl);

}
