// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from TransferSwitch.idl.

package com.raritan.idl.pdumodel;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface TransferSwitch_4_0_4 extends com.raritan.idl.pdumodel.EDevice {
  static public final TypeInfo typeInfo = new TypeInfo("pdumodel.TransferSwitch:4.0.4", com.raritan.idl.pdumodel.EDevice.typeInfo);

  public static final int ERR_INVALID_PARAM = 1;

  public static final int ERR_SWITCH_PREVENTED = 2;

  public static final int ERR_SWITCH_FAILED = 3;

  public enum Type {
    STS,
    ATS,
    HTS;
  }

  public enum TransferReason {
    REASON_UNKNOWN,
    REASON_STARTUP,
    REASON_MANUAL_TRANSFER,
    REASON_AUTO_RETRANSFER,
    REASON_POWER_FAILURE,
    REASON_POWER_QUALITY,
    REASON_OVERLOAD,
    REASON_OVERHEAT,
    REASON_INTERNAL_FAILURE;
  }

  static public class MetaData implements Cloneable {
    public String label = new String();
    public com.raritan.idl.pdumodel.Nameplate_2_0_0 namePlate = new com.raritan.idl.pdumodel.Nameplate_2_0_0();
    public com.raritan.idl.pdumodel.Rating_2_0_0 rating = new com.raritan.idl.pdumodel.Rating_2_0_0();
    public com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Type type = com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Type.values()[0];
    public int sourceCount = 0;

    public Object clone() {
      MetaData copy = new MetaData();

      copy.label = this.label;
      Object namePlateCopy = this.namePlate.clone();
      copy.namePlate = (com.raritan.idl.pdumodel.Nameplate_2_0_0) namePlateCopy;
      Object ratingCopy = this.rating.clone();
      copy.rating = (com.raritan.idl.pdumodel.Rating_2_0_0) ratingCopy;
      copy.type = this.type;
      copy.sourceCount = this.sourceCount;

      return copy;
    }

  }

  public static final int OPERATIONAL_STATE_OFF = 0;

  public static final int OPERATIONAL_STATE_NORMAL = 1;

  public static final int OPERATIONAL_STATE_STANDBY = 2;

  public static final int OPERATIONAL_STATE_NON_REDUNDANT = 3;

  public static final int SWITCH_FAULT_I1_SHORT = 1;

  public static final int SWITCH_FAULT_I1_OPEN = 2;

  public static final int SWITCH_FAULT_I2_SHORT = 4;

  public static final int SWITCH_FAULT_I2_OPEN = 8;

  static public class Sensors implements Cloneable {
    public com.raritan.idl.sensors.StateSensor_4_0_3 selectedSource = null;
    public com.raritan.idl.sensors.StateSensor_4_0_3 operationalState = null;
    public com.raritan.idl.sensors.NumericSensor_4_0_3 sourceVoltagePhaseSyncAngle = null;
    public com.raritan.idl.sensors.StateSensor_4_0_3 overloadAlarm = null;
    public com.raritan.idl.sensors.StateSensor_4_0_3 phaseSyncAlarm = null;
    public com.raritan.idl.sensors.StateSensor_4_0_3 switchFault = null;

    public Object clone() {
      Sensors copy = new Sensors();

      copy.selectedSource = this.selectedSource;
      copy.operationalState = this.operationalState;
      copy.sourceVoltagePhaseSyncAngle = this.sourceVoltagePhaseSyncAngle;
      copy.overloadAlarm = this.overloadAlarm;
      copy.phaseSyncAlarm = this.phaseSyncAlarm;
      copy.switchFault = this.switchFault;

      return copy;
    }

  }

  static public class Settings implements Cloneable {
    public String name = new String();
    public int preferredSource = 0;
    public boolean autoRetransfer = false;
    public boolean noAutoRetransferIfPhaseFault = false;
    public int autoRetransferWaitTime = 0;
    public boolean manualTransferEnabled = false;

    public Object clone() {
      Settings copy = new Settings();

      copy.name = this.name;
      copy.preferredSource = this.preferredSource;
      copy.autoRetransfer = this.autoRetransfer;
      copy.noAutoRetransferIfPhaseFault = this.noAutoRetransferIfPhaseFault;
      copy.autoRetransferWaitTime = this.autoRetransferWaitTime;
      copy.manualTransferEnabled = this.manualTransferEnabled;

      return copy;
    }

  }

  static public class Statistics implements Cloneable {
    public int transferCount = 0;
    public int powerFailDetectTime = 0;
    public int relayOpenTime = 0;
    public int totalTransferTime = 0;

    public Object clone() {
      Statistics copy = new Statistics();

      copy.transferCount = this.transferCount;
      copy.powerFailDetectTime = this.powerFailDetectTime;
      copy.relayOpenTime = this.relayOpenTime;
      copy.totalTransferTime = this.totalTransferTime;

      return copy;
    }

  }

  static public class WaveformSample implements Cloneable {
    public double voltage = 0.0;
    public double current = 0.0;

    public Object clone() {
      WaveformSample copy = new WaveformSample();

      copy.voltage = this.voltage;
      copy.current = this.current;

      return copy;
    }

  }

  public class SettingsChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("pdumodel.TransferSwitch_4_0_4.SettingsChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Settings oldSettings = new com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Settings();
    public com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Settings newSettings = new com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Settings();
  }

  public class GetMetaDataResult {
    public com.raritan.idl.pdumodel.TransferSwitch_4_0_4.MetaData _ret_;
  }

  GetMetaDataResult getMetaData() throws Exception;

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp);

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp, RpcCtrl rpcCtrl);


  public class GetSensorsResult {
    public com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Sensors _ret_;
  }

  GetSensorsResult getSensors() throws Exception;

  AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult> rsp);

  AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult> rsp, RpcCtrl rpcCtrl);


  public class GetPolesResult {
    public java.util.List<com.raritan.idl.pdumodel.ThrowPole_2_0_0> _ret_;
  }

  GetPolesResult getPoles() throws Exception;

  AsyncRequest getPoles(AsyncRpcResponse<GetPolesResult> rsp);

  AsyncRequest getPoles(AsyncRpcResponse<GetPolesResult> rsp, RpcCtrl rpcCtrl);


  public class GetSettingsResult {
    public com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetStatisticsResult {
    public com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Statistics _ret_;
  }

  GetStatisticsResult getStatistics() throws Exception;

  AsyncRequest getStatistics(AsyncRpcResponse<GetStatisticsResult> rsp);

  AsyncRequest getStatistics(AsyncRpcResponse<GetStatisticsResult> rsp, RpcCtrl rpcCtrl);


  public class TransferToSourceResult {
    public int _ret_;
  }

  TransferToSourceResult transferToSource(int source, boolean faultOverride) throws Exception;

  AsyncRequest transferToSource(int source, boolean faultOverride, AsyncRpcResponse<TransferToSourceResult> rsp);

  AsyncRequest transferToSource(int source, boolean faultOverride, AsyncRpcResponse<TransferToSourceResult> rsp, RpcCtrl rpcCtrl);


  public class GetLastTransferReasonResult {
    public com.raritan.idl.pdumodel.TransferSwitch_4_0_4.TransferReason _ret_;
  }

  GetLastTransferReasonResult getLastTransferReason() throws Exception;

  AsyncRequest getLastTransferReason(AsyncRpcResponse<GetLastTransferReasonResult> rsp);

  AsyncRequest getLastTransferReason(AsyncRpcResponse<GetLastTransferReasonResult> rsp, RpcCtrl rpcCtrl);


  public class GetLastTransferWaveformResult {
    public java.util.List<com.raritan.idl.pdumodel.TransferSwitch_4_0_4.WaveformSample> _ret_;
  }

  GetLastTransferWaveformResult getLastTransferWaveform() throws Exception;

  AsyncRequest getLastTransferWaveform(AsyncRpcResponse<GetLastTransferWaveformResult> rsp);

  AsyncRequest getLastTransferWaveform(AsyncRpcResponse<GetLastTransferWaveformResult> rsp, RpcCtrl rpcCtrl);


  static public class TransferLogEntry implements Cloneable {
    public java.util.Date timestamp = new java.util.Date();
    public int oldInlet = 0;
    public int newInlet = 0;
    public com.raritan.idl.pdumodel.TransferSwitch_4_0_4.TransferReason reason = com.raritan.idl.pdumodel.TransferSwitch_4_0_4.TransferReason.values()[0];
    public java.util.List<com.raritan.idl.pdumodel.TransferSwitch_4_0_4.WaveformSample> waveform = new java.util.ArrayList<>();
    public com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Statistics statistics = new com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Statistics();
    public int switchFault = 0;

    public Object clone() {
      TransferLogEntry copy = new TransferLogEntry();

      copy.timestamp = this.timestamp;
      copy.oldInlet = this.oldInlet;
      copy.newInlet = this.newInlet;
      copy.reason = this.reason;
      copy.waveform = new java.util.ArrayList<com.raritan.idl.pdumodel.TransferSwitch_4_0_4.WaveformSample>(this.waveform);
      Object statisticsCopy = this.statistics.clone();
      copy.statistics = (com.raritan.idl.pdumodel.TransferSwitch_4_0_4.Statistics) statisticsCopy;
      copy.switchFault = this.switchFault;

      return copy;
    }

  }

  public class GetTransferLogResult {
    public java.util.List<com.raritan.idl.pdumodel.TransferSwitch_4_0_4.TransferLogEntry> _ret_;
  }

  GetTransferLogResult getTransferLog() throws Exception;

  AsyncRequest getTransferLog(AsyncRpcResponse<GetTransferLogResult> rsp);

  AsyncRequest getTransferLog(AsyncRpcResponse<GetTransferLogResult> rsp, RpcCtrl rpcCtrl);


  public class GetParametersResult {
    public java.util.Map<String, Integer> _ret_;
  }

  GetParametersResult getParameters() throws Exception;

  AsyncRequest getParameters(AsyncRpcResponse<GetParametersResult> rsp);

  AsyncRequest getParameters(AsyncRpcResponse<GetParametersResult> rsp, RpcCtrl rpcCtrl);


  public class SetParametersResult {
    public int _ret_;
  }

  SetParametersResult setParameters(java.util.Map<String, Integer> parameters) throws Exception;

  AsyncRequest setParameters(java.util.Map<String, Integer> parameters, AsyncRpcResponse<SetParametersResult> rsp);

  AsyncRequest setParameters(java.util.Map<String, Integer> parameters, AsyncRpcResponse<SetParametersResult> rsp, RpcCtrl rpcCtrl);

}
