// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ExternalSensorManager.idl.

package com.raritan.idl.sensors;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface ExternalSensorManager {
  static public final TypeInfo typeInfo = new TypeInfo("sensors.ExternalSensorManager:1.0.0", null);

  public static final int ERR_INVALID_PARAMS = 1;

  public static final int ERR_NOT_SUPPORTED = 2;

  public enum Events {
    EVT_KEY_SETTINGS_CHANGED,
    EVT_KEY_EXTERNALSENSOR_ADDED,
    EVT_KEY_EXTERNALSENSOR_REMOVED;
  }

  public enum ZCoordMode {
    RACKUNITS,
    FREEFORM;
  }

  static public class Settings implements Cloneable {
    public com.raritan.idl.sensors.ExternalSensorManager.ZCoordMode zCoordMode = com.raritan.idl.sensors.ExternalSensorManager.ZCoordMode.values()[0];
    public float deviceAltitude = 0.0f;

    public Object clone() {
      Settings copy = new Settings();

      copy.zCoordMode = this.zCoordMode;
      copy.deviceAltitude = this.deviceAltitude;

      return copy;
    }

  }

  static public class MetaData implements Cloneable {
    public boolean onboardSensors = false;
    public int portCount = 0;
    public boolean isPowControlled = false;

    public Object clone() {
      MetaData copy = new MetaData();

      copy.onboardSensors = this.onboardSensors;
      copy.portCount = this.portCount;
      copy.isPowControlled = this.isPowControlled;

      return copy;
    }

  }

  public class GetExternalSensorSlotsResult {
    public java.util.List<com.raritan.idl.sensors.ExternalSensorSlot> _ret_;
  }

  GetExternalSensorSlotsResult getExternalSensorSlots() throws Exception;

  AsyncRequest getExternalSensorSlots(AsyncRpcResponse<GetExternalSensorSlotsResult> rsp);

  AsyncRequest getExternalSensorSlots(AsyncRpcResponse<GetExternalSensorSlotsResult> rsp, RpcCtrl rpcCtrl);


  public class GetDiscoveredExternalSensorsResult {
    public java.util.List<com.raritan.idl.sensors.ExternalSensorData> _ret_;
  }

  GetDiscoveredExternalSensorsResult getDiscoveredExternalSensors() throws Exception;

  AsyncRequest getDiscoveredExternalSensors(AsyncRpcResponse<GetDiscoveredExternalSensorsResult> rsp);

  AsyncRequest getDiscoveredExternalSensors(AsyncRpcResponse<GetDiscoveredExternalSensorsResult> rsp, RpcCtrl rpcCtrl);


  public class GetSettingsResult {
    public com.raritan.idl.sensors.ExternalSensorManager.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.sensors.ExternalSensorManager.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.sensors.ExternalSensorManager.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.sensors.ExternalSensorManager.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetMetaDataResult {
    public com.raritan.idl.sensors.ExternalSensorManager.MetaData _ret_;
  }

  GetMetaDataResult getMetaData() throws Exception;

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp);

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp, RpcCtrl rpcCtrl);


  public class SetPortPowerResult {
    public int _ret_;
  }

  SetPortPowerResult setPortPower(int port, boolean hasPower) throws Exception;

  AsyncRequest setPortPower(int port, boolean hasPower, AsyncRpcResponse<SetPortPowerResult> rsp);

  AsyncRequest setPortPower(int port, boolean hasPower, AsyncRpcResponse<SetPortPowerResult> rsp, RpcCtrl rpcCtrl);


  public class SetAllPortPowerResult {
    public int _ret_;
  }

  SetAllPortPowerResult setAllPortPower(boolean hasPower) throws Exception;

  AsyncRequest setAllPortPower(boolean hasPower, AsyncRpcResponse<SetAllPortPowerResult> rsp);

  AsyncRequest setAllPortPower(boolean hasPower, AsyncRpcResponse<SetAllPortPowerResult> rsp, RpcCtrl rpcCtrl);

}
