// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from SensorLogger.idl.

package com.raritan.idl.sensors;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface Logger_2_1_6 {
  static public final TypeInfo typeInfo = new TypeInfo("sensors.Logger:2.1.6", null);

  static public class Settings implements Cloneable {
    public boolean isEnabled = false;
    public int samplePeriod = 0;
    public int samplesPerRecord = 0;
    public int oldestRecId = 0;
    public int newestRecId = 0;
    public int logCapacity = 0;

    public Object clone() {
      Settings copy = new Settings();

      copy.isEnabled = this.isEnabled;
      copy.samplePeriod = this.samplePeriod;
      copy.samplesPerRecord = this.samplesPerRecord;
      copy.oldestRecId = this.oldestRecId;
      copy.newestRecId = this.newestRecId;
      copy.logCapacity = this.logCapacity;

      return copy;
    }

  }

  static public class SensorSet implements Cloneable {
    public java.util.List<com.raritan.idl.sensors.Sensor_4_0_3> sensors = new java.util.ArrayList<>();
    public java.util.List<com.raritan.idl.peripheral.DeviceSlot_2_0_3> slots = new java.util.ArrayList<>();

    public Object clone() {
      SensorSet copy = new SensorSet();

      copy.sensors = new java.util.ArrayList<com.raritan.idl.sensors.Sensor_4_0_3>(this.sensors);
      copy.slots = new java.util.ArrayList<com.raritan.idl.peripheral.DeviceSlot_2_0_3>(this.slots);

      return copy;
    }

  }

  public class SettingsChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("sensors.Logger_2_1_6.SettingsChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.sensors.Logger_2_1_6.Settings oldSettings = new com.raritan.idl.sensors.Logger_2_1_6.Settings();
    public com.raritan.idl.sensors.Logger_2_1_6.Settings newSettings = new com.raritan.idl.sensors.Logger_2_1_6.Settings();
  }

  public class LoggedSensorsChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("sensors.Logger_2_1_6.LoggedSensorsChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.sensors.Logger_2_1_6.SensorSet oldSensors = new com.raritan.idl.sensors.Logger_2_1_6.SensorSet();
    public com.raritan.idl.sensors.Logger_2_1_6.SensorSet newSensors = new com.raritan.idl.sensors.Logger_2_1_6.SensorSet();
  }

  public class GetSettingsResult {
    public com.raritan.idl.sensors.Logger_2_1_6.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(boolean isEnabled, int samplesPerRecord) throws Exception;

  AsyncRequest setSettings(boolean isEnabled, int samplesPerRecord, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(boolean isEnabled, int samplesPerRecord, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public static final int STATE_UNAVAILABLE = 0;

  public static final int STATE_OPEN = 1;

  public static final int STATE_CLOSE = 2;

  public static final int STATE_BELOW_LOWER_CRITICAL = 3;

  public static final int STATE_BELOW_LOWER_WARNING = 4;

  public static final int STATE_NORMAL = 5;

  public static final int STATE_ABOVE_UPPER_WARNING = 6;

  public static final int STATE_ABOVE_UPPER_CRITICAL = 7;

  public static final int STATE_ON = 8;

  public static final int STATE_OFF = 9;

  public static final int STATE_ALARMED = 10;

  public static final int STATE_OK = 11;

  public static final int STATE_MARGINAL = 12;

  public static final int STATE_FAIL = 13;

  public static final int STATE_YES = 14;

  public static final int STATE_NO = 15;

  public static final int STATE_STANDBY = 16;

  public static final int STATE_ONE = 17;

  public static final int STATE_TWO = 18;

  public static final int STATE_IN_SYNC = 19;

  public static final int STATE_OUT_OF_SYNC = 20;

  public static final int STATE_FAULT = 21;

  public static final int STATE_SELF_TEST = 22;

  public static final int STATE_I1_OPEN_FAULT = 23;

  public static final int STATE_I1_SHORT_FAULT = 24;

  public static final int STATE_I2_OPEN_FAULT = 25;

  public static final int STATE_I2_SHORT_FAULT = 26;

  public static final int STATE_WARNING = 27;

  public static final int STATE_CRITICAL = 28;

  public static final int STATE_NON_REDUNDANT = 29;

  public class GetTimeStampsResult {
    public int _ret_;
    public java.util.List<java.util.Date> timestamps;
  }

  GetTimeStampsResult getTimeStamps(int recid, int count) throws Exception;

  AsyncRequest getTimeStamps(int recid, int count, AsyncRpcResponse<GetTimeStampsResult> rsp);

  AsyncRequest getTimeStamps(int recid, int count, AsyncRpcResponse<GetTimeStampsResult> rsp, RpcCtrl rpcCtrl);


  static public class Record implements Cloneable {
    public boolean available = false;
    public int takenValidSamples = 0;
    public int state = 0;
    public double minValue = 0.0;
    public double avgValue = 0.0;
    public double maxValue = 0.0;

    public Object clone() {
      Record copy = new Record();

      copy.available = this.available;
      copy.takenValidSamples = this.takenValidSamples;
      copy.state = this.state;
      copy.minValue = this.minValue;
      copy.avgValue = this.avgValue;
      copy.maxValue = this.maxValue;

      return copy;
    }

  }

  public class GetSensorRecordsResult {
    public int _ret_;
    public java.util.List<com.raritan.idl.sensors.Logger_2_1_6.Record> recs;
  }

  GetSensorRecordsResult getSensorRecords(com.raritan.idl.sensors.Sensor_4_0_3 sensor, int recid, int count) throws Exception;

  AsyncRequest getSensorRecords(com.raritan.idl.sensors.Sensor_4_0_3 sensor, int recid, int count, AsyncRpcResponse<GetSensorRecordsResult> rsp);

  AsyncRequest getSensorRecords(com.raritan.idl.sensors.Sensor_4_0_3 sensor, int recid, int count, AsyncRpcResponse<GetSensorRecordsResult> rsp, RpcCtrl rpcCtrl);


  public class GetPeripheralDeviceRecordsResult {
    public int _ret_;
    public java.util.List<com.raritan.idl.sensors.Logger_2_1_6.Record> recs;
  }

  GetPeripheralDeviceRecordsResult getPeripheralDeviceRecords(com.raritan.idl.peripheral.DeviceSlot_2_0_3 slot, int recid, int count) throws Exception;

  AsyncRequest getPeripheralDeviceRecords(com.raritan.idl.peripheral.DeviceSlot_2_0_3 slot, int recid, int count, AsyncRpcResponse<GetPeripheralDeviceRecordsResult> rsp);

  AsyncRequest getPeripheralDeviceRecords(com.raritan.idl.peripheral.DeviceSlot_2_0_3 slot, int recid, int count, AsyncRpcResponse<GetPeripheralDeviceRecordsResult> rsp, RpcCtrl rpcCtrl);


  static public class TimedRecord implements Cloneable {
    public java.util.Date timestamp = new java.util.Date();
    public com.raritan.idl.sensors.Logger_2_1_6.Record record = new com.raritan.idl.sensors.Logger_2_1_6.Record();

    public Object clone() {
      TimedRecord copy = new TimedRecord();

      copy.timestamp = this.timestamp;
      Object recordCopy = this.record.clone();
      copy.record = (com.raritan.idl.sensors.Logger_2_1_6.Record) recordCopy;

      return copy;
    }

  }

  public class GetSensorTimedRecordsResult {
    public int _ret_;
    public java.util.List<com.raritan.idl.sensors.Logger_2_1_6.TimedRecord> recs;
  }

  GetSensorTimedRecordsResult getSensorTimedRecords(com.raritan.idl.sensors.Sensor_4_0_3 sensor, int recid, int count) throws Exception;

  AsyncRequest getSensorTimedRecords(com.raritan.idl.sensors.Sensor_4_0_3 sensor, int recid, int count, AsyncRpcResponse<GetSensorTimedRecordsResult> rsp);

  AsyncRequest getSensorTimedRecords(com.raritan.idl.sensors.Sensor_4_0_3 sensor, int recid, int count, AsyncRpcResponse<GetSensorTimedRecordsResult> rsp, RpcCtrl rpcCtrl);


  public class GetPeripheralDeviceTimedRecordsResult {
    public int _ret_;
    public java.util.List<com.raritan.idl.sensors.Logger_2_1_6.TimedRecord> recs;
  }

  GetPeripheralDeviceTimedRecordsResult getPeripheralDeviceTimedRecords(com.raritan.idl.peripheral.DeviceSlot_2_0_3 slot, int recid, int count) throws Exception;

  AsyncRequest getPeripheralDeviceTimedRecords(com.raritan.idl.peripheral.DeviceSlot_2_0_3 slot, int recid, int count, AsyncRpcResponse<GetPeripheralDeviceTimedRecordsResult> rsp);

  AsyncRequest getPeripheralDeviceTimedRecords(com.raritan.idl.peripheral.DeviceSlot_2_0_3 slot, int recid, int count, AsyncRpcResponse<GetPeripheralDeviceTimedRecordsResult> rsp, RpcCtrl rpcCtrl);


  public class GetLoggedSensorsResult {
    public com.raritan.idl.sensors.Logger_2_1_6.SensorSet _ret_;
  }

  GetLoggedSensorsResult getLoggedSensors() throws Exception;

  AsyncRequest getLoggedSensors(AsyncRpcResponse<GetLoggedSensorsResult> rsp);

  AsyncRequest getLoggedSensors(AsyncRpcResponse<GetLoggedSensorsResult> rsp, RpcCtrl rpcCtrl);


  public class SetLoggedSensorsResult {
    public int _ret_;
  }

  SetLoggedSensorsResult setLoggedSensors(com.raritan.idl.sensors.Logger_2_1_6.SensorSet sensors) throws Exception;

  AsyncRequest setLoggedSensors(com.raritan.idl.sensors.Logger_2_1_6.SensorSet sensors, AsyncRpcResponse<SetLoggedSensorsResult> rsp);

  AsyncRequest setLoggedSensors(com.raritan.idl.sensors.Logger_2_1_6.SensorSet sensors, AsyncRpcResponse<SetLoggedSensorsResult> rsp, RpcCtrl rpcCtrl);


  public class EnableSensorsResult {
    public int _ret_;
  }

  EnableSensorsResult enableSensors(com.raritan.idl.sensors.Logger_2_1_6.SensorSet sensors) throws Exception;

  AsyncRequest enableSensors(com.raritan.idl.sensors.Logger_2_1_6.SensorSet sensors, AsyncRpcResponse<EnableSensorsResult> rsp);

  AsyncRequest enableSensors(com.raritan.idl.sensors.Logger_2_1_6.SensorSet sensors, AsyncRpcResponse<EnableSensorsResult> rsp, RpcCtrl rpcCtrl);


  public class DisableSensorsResult {
    public int _ret_;
  }

  DisableSensorsResult disableSensors(com.raritan.idl.sensors.Logger_2_1_6.SensorSet sensors) throws Exception;

  AsyncRequest disableSensors(com.raritan.idl.sensors.Logger_2_1_6.SensorSet sensors, AsyncRpcResponse<DisableSensorsResult> rsp);

  AsyncRequest disableSensors(com.raritan.idl.sensors.Logger_2_1_6.SensorSet sensors, AsyncRpcResponse<DisableSensorsResult> rsp, RpcCtrl rpcCtrl);


  public class IsSensorEnabledResult {
    public boolean _ret_;
  }

  IsSensorEnabledResult isSensorEnabled(com.raritan.idl.sensors.Sensor_4_0_3 sensor) throws Exception;

  AsyncRequest isSensorEnabled(com.raritan.idl.sensors.Sensor_4_0_3 sensor, AsyncRpcResponse<IsSensorEnabledResult> rsp);

  AsyncRequest isSensorEnabled(com.raritan.idl.sensors.Sensor_4_0_3 sensor, AsyncRpcResponse<IsSensorEnabledResult> rsp, RpcCtrl rpcCtrl);


  public class IsSlotEnabledResult {
    public boolean _ret_;
  }

  IsSlotEnabledResult isSlotEnabled(com.raritan.idl.peripheral.DeviceSlot_2_0_3 slot) throws Exception;

  AsyncRequest isSlotEnabled(com.raritan.idl.peripheral.DeviceSlot_2_0_3 slot, AsyncRpcResponse<IsSlotEnabledResult> rsp);

  AsyncRequest isSlotEnabled(com.raritan.idl.peripheral.DeviceSlot_2_0_3 slot, AsyncRpcResponse<IsSlotEnabledResult> rsp, RpcCtrl rpcCtrl);

  Void enableAllSensors() throws Exception;

  AsyncRequest enableAllSensors(AsyncRpcResponse<Void> rsp);

  AsyncRequest enableAllSensors(AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);

  Void disableAllSensors() throws Exception;

  AsyncRequest disableAllSensors(AsyncRpcResponse<Void> rsp);

  AsyncRequest disableAllSensors(AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);


  public class GetSensorSetTimestampResult {
    public java.util.Date _ret_;
  }

  GetSensorSetTimestampResult getSensorSetTimestamp() throws Exception;

  AsyncRequest getSensorSetTimestamp(AsyncRpcResponse<GetSensorSetTimestampResult> rsp);

  AsyncRequest getSensorSetTimestamp(AsyncRpcResponse<GetSensorSetTimestampResult> rsp, RpcCtrl rpcCtrl);


  static public class LogRow implements Cloneable {
    public java.util.Date sensorSetTimestamp = new java.util.Date();
    public java.util.Date timestamp = new java.util.Date();
    public java.util.List<com.raritan.idl.sensors.Logger_2_1_6.Record> sensorRecords = new java.util.ArrayList<>();
    public java.util.List<com.raritan.idl.sensors.Logger_2_1_6.Record> peripheralDeviceRecords = new java.util.ArrayList<>();

    public Object clone() {
      LogRow copy = new LogRow();

      copy.sensorSetTimestamp = this.sensorSetTimestamp;
      copy.timestamp = this.timestamp;
      copy.sensorRecords = new java.util.ArrayList<com.raritan.idl.sensors.Logger_2_1_6.Record>(this.sensorRecords);
      copy.peripheralDeviceRecords = new java.util.ArrayList<com.raritan.idl.sensors.Logger_2_1_6.Record>(this.peripheralDeviceRecords);

      return copy;
    }

  }

  public class GetLogRowResult {
    public int _ret_;
    public com.raritan.idl.sensors.Logger_2_1_6.LogRow row;
  }

  GetLogRowResult getLogRow(int recid) throws Exception;

  AsyncRequest getLogRow(int recid, AsyncRpcResponse<GetLogRowResult> rsp);

  AsyncRequest getLogRow(int recid, AsyncRpcResponse<GetLogRowResult> rsp, RpcCtrl rpcCtrl);

}
