// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from RoleManager.idl.

package com.raritan.idl.usermgmt;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface RoleManager {
  static public final TypeInfo typeInfo = new TypeInfo("usermgmt.RoleManager:1.0.0", null);

  public static final int ERR_ROLE_ALREADY_EXISTS = 1;

  public static final int ERR_MAX_ROLES_REACHED = 2;

  public static final int ERR_INVALID_VALUE = 3;

  public static final int ERR_ROLE_DOESNT_EXIST = 1;

  public static final int ERR_ROLE_NOT_DELETABLE = 2;

  static public class ArgumentDesc implements Cloneable {
    public String name = new String();
    public String desc = new String();

    public Object clone() {
      ArgumentDesc copy = new ArgumentDesc();

      copy.name = this.name;
      copy.desc = this.desc;

      return copy;
    }

  }

  static public class PrivilegeDesc implements Cloneable {
    public String name = new String();
    public String desc = new String();
    public java.util.List<com.raritan.idl.usermgmt.RoleManager.ArgumentDesc> args = new java.util.ArrayList<>();

    public Object clone() {
      PrivilegeDesc copy = new PrivilegeDesc();

      copy.name = this.name;
      copy.desc = this.desc;
      copy.args = new java.util.ArrayList<com.raritan.idl.usermgmt.RoleManager.ArgumentDesc>(this.args);

      return copy;
    }

  }

  static public class RoleAccount implements Cloneable {
    public int id = 0;
    public String name = new String();
    public com.raritan.idl.usermgmt.Role.Info info = new com.raritan.idl.usermgmt.Role.Info();

    public Object clone() {
      RoleAccount copy = new RoleAccount();

      copy.id = this.id;
      copy.name = this.name;
      Object infoCopy = this.info.clone();
      copy.info = (com.raritan.idl.usermgmt.Role.Info) infoCopy;

      return copy;
    }

  }

  static public class Info implements Cloneable {
    public java.util.List<com.raritan.idl.usermgmt.RoleManager.PrivilegeDesc> privileges = new java.util.ArrayList<>();
    public java.util.List<com.raritan.idl.usermgmt.RoleManager.RoleAccount> roles = new java.util.ArrayList<>();

    public Object clone() {
      Info copy = new Info();

      copy.privileges = new java.util.ArrayList<com.raritan.idl.usermgmt.RoleManager.PrivilegeDesc>(this.privileges);
      copy.roles = new java.util.ArrayList<com.raritan.idl.usermgmt.RoleManager.RoleAccount>(this.roles);

      return copy;
    }

  }

  public class CreateRoleFullResult {
    public int _ret_;
  }

  CreateRoleFullResult createRoleFull(String name, com.raritan.idl.usermgmt.Role.Info info) throws Exception;

  AsyncRequest createRoleFull(String name, com.raritan.idl.usermgmt.Role.Info info, AsyncRpcResponse<CreateRoleFullResult> rsp);

  AsyncRequest createRoleFull(String name, com.raritan.idl.usermgmt.Role.Info info, AsyncRpcResponse<CreateRoleFullResult> rsp, RpcCtrl rpcCtrl);


  public class DeleteRoleResult {
    public int _ret_;
  }

  DeleteRoleResult deleteRole(String name) throws Exception;

  AsyncRequest deleteRole(String name, AsyncRpcResponse<DeleteRoleResult> rsp);

  AsyncRequest deleteRole(String name, AsyncRpcResponse<DeleteRoleResult> rsp, RpcCtrl rpcCtrl);


  public class GetAllRoleNamesResult {
    public java.util.List<String> _ret_;
  }

  GetAllRoleNamesResult getAllRoleNames() throws Exception;

  AsyncRequest getAllRoleNames(AsyncRpcResponse<GetAllRoleNamesResult> rsp);

  AsyncRequest getAllRoleNames(AsyncRpcResponse<GetAllRoleNamesResult> rsp, RpcCtrl rpcCtrl);


  public class GetAllRolesResult {
    public java.util.List<com.raritan.idl.usermgmt.RoleManager.RoleAccount> _ret_;
  }

  GetAllRolesResult getAllRoles() throws Exception;

  AsyncRequest getAllRoles(AsyncRpcResponse<GetAllRolesResult> rsp);

  AsyncRequest getAllRoles(AsyncRpcResponse<GetAllRolesResult> rsp, RpcCtrl rpcCtrl);


  public class GetAllPrivilegesResult {
    public java.util.List<com.raritan.idl.usermgmt.RoleManager.PrivilegeDesc> _ret_;
  }

  GetAllPrivilegesResult getAllPrivileges() throws Exception;

  AsyncRequest getAllPrivileges(AsyncRpcResponse<GetAllPrivilegesResult> rsp);

  AsyncRequest getAllPrivileges(AsyncRpcResponse<GetAllPrivilegesResult> rsp, RpcCtrl rpcCtrl);


  public class GetInfoResult {
    public com.raritan.idl.usermgmt.RoleManager.Info _ret_;
  }

  GetInfoResult getInfo() throws Exception;

  AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult> rsp);

  AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult> rsp, RpcCtrl rpcCtrl);

}
