// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ZigbeeDevice.idl.

package com.raritan.idl.zigbee;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface ZigbeeDevice {
  static public final TypeInfo typeInfo = new TypeInfo("zigbee.ZigbeeDevice:1.0.0", null);

  public static final int CLUSTER_BASIC = 0x0;

  public static final int CLUSTER_POWER_CONFIGURATION = 0x1;

  public static final int CLUSTER_RSSI = 0xb;

  public static final int CLUSTER_CONTACT_CLOSURE = 0xf;

  public static final int CLUSTER_TEMPERATURE = 0x402;

  public static final int CLUSTER_HUMIDITY = 0x405;

  static public class MetaData implements Cloneable {
    public int sourceId = 0;
    public java.util.List<Integer> clusters = new java.util.ArrayList<>();
    public int preferredSlot = 0;

    public Object clone() {
      MetaData copy = new MetaData();

      copy.sourceId = this.sourceId;
      copy.clusters = new java.util.ArrayList<Integer>(this.clusters);
      copy.preferredSlot = this.preferredSlot;

      return copy;
    }

  }

  static public class ClusterValue implements Cloneable {
    public int id = 0;
    public int endpoint = 0;
    public int attribute = 0;
    public java.util.Date timestamp = new java.util.Date();
    public String value = new String();

    public Object clone() {
      ClusterValue copy = new ClusterValue();

      copy.id = this.id;
      copy.endpoint = this.endpoint;
      copy.attribute = this.attribute;
      copy.timestamp = this.timestamp;
      copy.value = this.value;

      return copy;
    }

  }

  public class ClusterDataEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("zigbee.ZigbeeDevice.ClusterDataEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.zigbee.ZigbeeDevice.ClusterValue value = new com.raritan.idl.zigbee.ZigbeeDevice.ClusterValue();
  }

  public class GetMetaDataResult {
    public com.raritan.idl.zigbee.ZigbeeDevice.MetaData _ret_;
  }

  GetMetaDataResult getMetaData() throws Exception;

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp);

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp, RpcCtrl rpcCtrl);


  public class GetClusterValuesResult {
    public java.util.List<com.raritan.idl.zigbee.ZigbeeDevice.ClusterValue> _ret_;
  }

  GetClusterValuesResult getClusterValues() throws Exception;

  AsyncRequest getClusterValues(AsyncRpcResponse<GetClusterValuesResult> rsp);

  AsyncRequest getClusterValues(AsyncRpcResponse<GetClusterValuesResult> rsp, RpcCtrl rpcCtrl);

}
