// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from EventService.idl.

package com.raritan.json_rpc.event;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class Channel_1_0_1_Proxy extends ObjectProxy implements com.raritan.idl.event.Channel_1_0_1 {

  public Channel_1_0_1_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public Channel_1_0_1_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.event.Channel_1_0_1.typeInfo);
  }

  public static Channel_1_0_1_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new Channel_1_0_1_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public Void demandEventType(final TypeInfo type) throws Exception {
    JSONObject params = new JSONObject();
    params.put("type", type);
    rpcCall("demandEventType", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest demandEventType(final TypeInfo type, final AsyncRpcResponse<Void> rsp) {
    return demandEventType(type, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest demandEventType(final TypeInfo type, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("type", type);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("demandEventType", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void cancelEventType(final TypeInfo type) throws Exception {
    JSONObject params = new JSONObject();
    params.put("type", type);
    rpcCall("cancelEventType", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest cancelEventType(final TypeInfo type, final AsyncRpcResponse<Void> rsp) {
    return cancelEventType(type, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest cancelEventType(final TypeInfo type, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("type", type);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("cancelEventType", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void demandEventTypes(final java.util.List<TypeInfo> types) throws Exception {
    JSONObject params = new JSONObject();
    params.put("types", new JSONArray() {{
      final java.util.List<TypeInfo> array0 = types;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(array0.get(i0_f));
      }
    }});
    rpcCall("demandEventTypes", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest demandEventTypes(final java.util.List<TypeInfo> types, final AsyncRpcResponse<Void> rsp) {
    return demandEventTypes(types, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest demandEventTypes(final java.util.List<TypeInfo> types, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("types", new JSONArray() {{
        final java.util.List<TypeInfo> array0 = types;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(array0.get(i0_f));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("demandEventTypes", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void cancelEventTypes(final java.util.List<TypeInfo> types) throws Exception {
    JSONObject params = new JSONObject();
    params.put("types", new JSONArray() {{
      final java.util.List<TypeInfo> array0 = types;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(array0.get(i0_f));
      }
    }});
    rpcCall("cancelEventTypes", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest cancelEventTypes(final java.util.List<TypeInfo> types, final AsyncRpcResponse<Void> rsp) {
    return cancelEventTypes(types, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest cancelEventTypes(final java.util.List<TypeInfo> types, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("types", new JSONArray() {{
        final java.util.List<TypeInfo> array0 = types;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(array0.get(i0_f));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("cancelEventTypes", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void demandEvent(final TypeInfo type, final Object src) throws Exception {
    JSONObject params = new JSONObject();
    params.put("type", type);
    params.put("src", src != null ? ((ObjectProxy) src).encode() : JSONObject.NULL);
    rpcCall("demandEvent", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest demandEvent(final TypeInfo type, final Object src, final AsyncRpcResponse<Void> rsp) {
    return demandEvent(type, src, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest demandEvent(final TypeInfo type, final Object src, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("type", type);
      params.put("src", src != null ? ((ObjectProxy) src).encode() : JSONObject.NULL);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("demandEvent", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void cancelEvent(final TypeInfo type, final Object src) throws Exception {
    JSONObject params = new JSONObject();
    params.put("type", type);
    params.put("src", src != null ? ((ObjectProxy) src).encode() : JSONObject.NULL);
    rpcCall("cancelEvent", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest cancelEvent(final TypeInfo type, final Object src, final AsyncRpcResponse<Void> rsp) {
    return cancelEvent(type, src, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest cancelEvent(final TypeInfo type, final Object src, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("type", type);
      params.put("src", src != null ? ((ObjectProxy) src).encode() : JSONObject.NULL);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("cancelEvent", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void demandEvents(final java.util.List<com.raritan.idl.event.Channel_1_0_1.EventSelect> events) throws Exception {
    JSONObject params = new JSONObject();
    params.put("events", new JSONArray() {{
      final java.util.List<com.raritan.idl.event.Channel_1_0_1.EventSelect> array0 = events;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.event.Channel_1_0_1.EventSelect_Codec.encode(array0.get(i0_f)));
      }
    }});
    rpcCall("demandEvents", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest demandEvents(final java.util.List<com.raritan.idl.event.Channel_1_0_1.EventSelect> events, final AsyncRpcResponse<Void> rsp) {
    return demandEvents(events, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest demandEvents(final java.util.List<com.raritan.idl.event.Channel_1_0_1.EventSelect> events, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("events", new JSONArray() {{
        final java.util.List<com.raritan.idl.event.Channel_1_0_1.EventSelect> array0 = events;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.event.Channel_1_0_1.EventSelect_Codec.encode(array0.get(i0_f)));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("demandEvents", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void cancelEvents(final java.util.List<com.raritan.idl.event.Channel_1_0_1.EventSelect> events) throws Exception {
    JSONObject params = new JSONObject();
    params.put("events", new JSONArray() {{
      final java.util.List<com.raritan.idl.event.Channel_1_0_1.EventSelect> array0 = events;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.event.Channel_1_0_1.EventSelect_Codec.encode(array0.get(i0_f)));
      }
    }});
    rpcCall("cancelEvents", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest cancelEvents(final java.util.List<com.raritan.idl.event.Channel_1_0_1.EventSelect> events, final AsyncRpcResponse<Void> rsp) {
    return cancelEvents(events, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest cancelEvents(final java.util.List<com.raritan.idl.event.Channel_1_0_1.EventSelect> events, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("events", new JSONArray() {{
        final java.util.List<com.raritan.idl.event.Channel_1_0_1.EventSelect> array0 = events;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.event.Channel_1_0_1.EventSelect_Codec.encode(array0.get(i0_f)));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("cancelEvents", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void subscribe(final com.raritan.idl.event.Consumer consumer) throws Exception {
    JSONObject params = new JSONObject();
    params.put("consumer", consumer != null ? ((ObjectProxy) consumer).encode() : JSONObject.NULL);
    rpcCall("subscribe", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest subscribe(final com.raritan.idl.event.Consumer consumer, final AsyncRpcResponse<Void> rsp) {
    return subscribe(consumer, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest subscribe(final com.raritan.idl.event.Consumer consumer, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("consumer", consumer != null ? ((ObjectProxy) consumer).encode() : JSONObject.NULL);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("subscribe", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public UnsubscribeResult unsubscribe(final com.raritan.idl.event.Consumer consumer) throws Exception {
    JSONObject params = new JSONObject();
    params.put("consumer", consumer != null ? ((ObjectProxy) consumer).encode() : JSONObject.NULL);
    final JSONObject result = rpcCall("unsubscribe", params);
    UnsubscribeResult ret = new UnsubscribeResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest unsubscribe(final com.raritan.idl.event.Consumer consumer, final AsyncRpcResponse<UnsubscribeResult> rsp) {
    return unsubscribe(consumer, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest unsubscribe(final com.raritan.idl.event.Consumer consumer, final AsyncRpcResponse<UnsubscribeResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("consumer", consumer != null ? ((ObjectProxy) consumer).encode() : JSONObject.NULL);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("unsubscribe", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          UnsubscribeResult ret = new UnsubscribeResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public PollEventsResult pollEvents() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("pollEvents", params);
    PollEventsResult ret = new PollEventsResult();
    ret._ret_ = result.getBoolean("_ret_");
    ret.events = new java.util.ArrayList<com.raritan.idl.idl.Event>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("events");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add((com.raritan.idl.idl.Event)ValueObjectCodec.decodeAs((array0.isNull(i0_f) ? null : array0.getJSONObject(i0_f)), agent, new TypeInfo("idl.Event:1.0.0", null)));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest pollEvents(final AsyncRpcResponse<PollEventsResult> rsp) {
    return pollEvents(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest pollEvents(final AsyncRpcResponse<PollEventsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("pollEvents", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          PollEventsResult ret = new PollEventsResult();
          ret._ret_ = result.getBoolean("_ret_");
          ret.events = new java.util.ArrayList<com.raritan.idl.idl.Event>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("events");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add((com.raritan.idl.idl.Event)ValueObjectCodec.decodeAs((array0.isNull(i0_f) ? null : array0.getJSONObject(i0_f)), agent, new TypeInfo("idl.Event:1.0.0", null)));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public PollEventsNbResult pollEventsNb() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("pollEventsNb", params);
    PollEventsNbResult ret = new PollEventsNbResult();
    ret._ret_ = result.getBoolean("_ret_");
    ret.events = new java.util.ArrayList<com.raritan.idl.idl.Event>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("events");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add((com.raritan.idl.idl.Event)ValueObjectCodec.decodeAs((array0.isNull(i0_f) ? null : array0.getJSONObject(i0_f)), agent, new TypeInfo("idl.Event:1.0.0", null)));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest pollEventsNb(final AsyncRpcResponse<PollEventsNbResult> rsp) {
    return pollEventsNb(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest pollEventsNb(final AsyncRpcResponse<PollEventsNbResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("pollEventsNb", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          PollEventsNbResult ret = new PollEventsNbResult();
          ret._ret_ = result.getBoolean("_ret_");
          ret.events = new java.util.ArrayList<com.raritan.idl.idl.Event>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("events");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add((com.raritan.idl.idl.Event)ValueObjectCodec.decodeAs((array0.isNull(i0_f) ? null : array0.getJSONObject(i0_f)), agent, new TypeInfo("idl.Event:1.0.0", null)));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
