// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Firmware.idl.

package com.raritan.json_rpc.firmware;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class Firmware_Proxy extends ObjectProxy implements com.raritan.idl.firmware.Firmware {

  public Firmware_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public Firmware_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.firmware.Firmware.typeInfo);
  }

  public static Firmware_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new Firmware_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public Void reboot() throws Exception {
    JSONObject params = null;
    rpcCall("reboot", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest reboot(final AsyncRpcResponse<Void> rsp) {
    return reboot(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest reboot(final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("reboot", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void factoryReset() throws Exception {
    JSONObject params = null;
    rpcCall("factoryReset", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest factoryReset(final AsyncRpcResponse<Void> rsp) {
    return factoryReset(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest factoryReset(final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("factoryReset", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetVersionResult getVersion() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getVersion", params);
    GetVersionResult ret = new GetVersionResult();
    ret._ret_ = result.getString("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest getVersion(final AsyncRpcResponse<GetVersionResult> rsp) {
    return getVersion(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getVersion(final AsyncRpcResponse<GetVersionResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getVersion", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetVersionResult ret = new GetVersionResult();
          ret._ret_ = result.getString("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetUpdateHistoryResult getUpdateHistory() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getUpdateHistory", params);
    GetUpdateHistoryResult ret = new GetUpdateHistoryResult();
    ret._ret_ = new java.util.ArrayList<com.raritan.idl.firmware.UpdateHistoryEntry>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.firmware.UpdateHistoryEntry_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getUpdateHistory(final AsyncRpcResponse<GetUpdateHistoryResult> rsp) {
    return getUpdateHistory(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getUpdateHistory(final AsyncRpcResponse<GetUpdateHistoryResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getUpdateHistory", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetUpdateHistoryResult ret = new GetUpdateHistoryResult();
          ret._ret_ = new java.util.ArrayList<com.raritan.idl.firmware.UpdateHistoryEntry>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.firmware.UpdateHistoryEntry_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public UpdateAvailableResult updateAvailable() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("updateAvailable", params);
    UpdateAvailableResult ret = new UpdateAvailableResult();
    ret._ret_ = result.getBoolean("_ret_");
    ret.failedCheck = result.getBoolean("failedCheck");
    ret.lastChecked = new java.util.Date(((long) result.getInt("lastChecked")) * 1000);
    ret.version = result.getString("version");
    ret.url = result.getString("url");
    return ret;
  }

  @Override
  public AsyncRequest updateAvailable(final AsyncRpcResponse<UpdateAvailableResult> rsp) {
    return updateAvailable(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest updateAvailable(final AsyncRpcResponse<UpdateAvailableResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("updateAvailable", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          UpdateAvailableResult ret = new UpdateAvailableResult();
          ret._ret_ = result.getBoolean("_ret_");
          ret.failedCheck = result.getBoolean("failedCheck");
          ret.lastChecked = new java.util.Date(((long) result.getInt("lastChecked")) * 1000);
          ret.version = result.getString("version");
          ret.url = result.getString("url");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void enableOnlineCheck(final boolean enable) throws Exception {
    JSONObject params = new JSONObject();
    params.put("enable", enable);
    rpcCall("enableOnlineCheck", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest enableOnlineCheck(final boolean enable, final AsyncRpcResponse<Void> rsp) {
    return enableOnlineCheck(enable, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest enableOnlineCheck(final boolean enable, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("enable", enable);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("enableOnlineCheck", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public OnlineCheckEnabledResult onlineCheckEnabled() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("onlineCheckEnabled", params);
    OnlineCheckEnabledResult ret = new OnlineCheckEnabledResult();
    ret._ret_ = result.getBoolean("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest onlineCheckEnabled(final AsyncRpcResponse<OnlineCheckEnabledResult> rsp) {
    return onlineCheckEnabled(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest onlineCheckEnabled(final AsyncRpcResponse<OnlineCheckEnabledResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("onlineCheckEnabled", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          OnlineCheckEnabledResult ret = new OnlineCheckEnabledResult();
          ret._ret_ = result.getBoolean("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void performOnlineCheck() throws Exception {
    JSONObject params = null;
    rpcCall("performOnlineCheck", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest performOnlineCheck(final AsyncRpcResponse<Void> rsp) {
    return performOnlineCheck(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest performOnlineCheck(final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("performOnlineCheck", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public DownloadImageResult downloadImage(final String url) throws Exception {
    JSONObject params = new JSONObject();
    params.put("url", url);
    final JSONObject result = rpcCall("downloadImage", params);
    DownloadImageResult ret = new DownloadImageResult();
    ret._ret_ = result.getBoolean("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest downloadImage(final String url, final AsyncRpcResponse<DownloadImageResult> rsp) {
    return downloadImage(url, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest downloadImage(final String url, final AsyncRpcResponse<DownloadImageResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("url", url);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("downloadImage", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          DownloadImageResult ret = new DownloadImageResult();
          ret._ret_ = result.getBoolean("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void cancelDownload() throws Exception {
    JSONObject params = null;
    rpcCall("cancelDownload", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest cancelDownload(final AsyncRpcResponse<Void> rsp) {
    return cancelDownload(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest cancelDownload(final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("cancelDownload", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetImageStatusResult getImageStatus() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getImageStatus", params);
    GetImageStatusResult ret = new GetImageStatusResult();
    ret._ret_ = com.raritan.json_rpc.firmware.ImageStatus_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getImageStatus(final AsyncRpcResponse<GetImageStatusResult> rsp) {
    return getImageStatus(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getImageStatus(final AsyncRpcResponse<GetImageStatusResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getImageStatus", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetImageStatusResult ret = new GetImageStatusResult();
          ret._ret_ = com.raritan.json_rpc.firmware.ImageStatus_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void discardImage() throws Exception {
    JSONObject params = null;
    rpcCall("discardImage", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest discardImage(final AsyncRpcResponse<Void> rsp) {
    return discardImage(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest discardImage(final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("discardImage", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetImageInfoResult getImageInfo() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getImageInfo", params);
    GetImageInfoResult ret = new GetImageInfoResult();
    ret._ret_ = result.getBoolean("_ret_");
    ret.info = com.raritan.json_rpc.firmware.ImageInfo_Codec.decode(result.getJSONObject("info"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getImageInfo(final AsyncRpcResponse<GetImageInfoResult> rsp) {
    return getImageInfo(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getImageInfo(final AsyncRpcResponse<GetImageInfoResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getImageInfo", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetImageInfoResult ret = new GetImageInfoResult();
          ret._ret_ = result.getBoolean("_ret_");
          ret.info = com.raritan.json_rpc.firmware.ImageInfo_Codec.decode(result.getJSONObject("info"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void startUpdate(final java.util.List<com.raritan.idl.firmware.UpdateFlags> flags) throws Exception {
    JSONObject params = new JSONObject();
    params.put("flags", new JSONArray() {{
      final java.util.List<com.raritan.idl.firmware.UpdateFlags> array0 = flags;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.firmware.UpdateFlags_Codec.encode(array0.get(i0_f)));
      }
    }});
    rpcCall("startUpdate", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest startUpdate(final java.util.List<com.raritan.idl.firmware.UpdateFlags> flags, final AsyncRpcResponse<Void> rsp) {
    return startUpdate(flags, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest startUpdate(final java.util.List<com.raritan.idl.firmware.UpdateFlags> flags, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("flags", new JSONArray() {{
        final java.util.List<com.raritan.idl.firmware.UpdateFlags> array0 = flags;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.firmware.UpdateFlags_Codec.encode(array0.get(i0_f)));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("startUpdate", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
