// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from LuaService.idl.

package com.raritan.json_rpc.luaservice;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class Manager_Proxy extends ObjectProxy implements com.raritan.idl.luaservice.Manager {

  public Manager_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public Manager_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.luaservice.Manager.typeInfo);
  }

  public static Manager_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new Manager_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public SetScriptResult setScript(final String name, final String script, final com.raritan.idl.luaservice.ScriptOptions options) throws Exception {
    JSONObject params = new JSONObject();
    params.put("name", name);
    params.put("script", script);
    params.put("options", com.raritan.json_rpc.luaservice.ScriptOptions_Codec.encode(options));
    final JSONObject result = rpcCall("setScript", params);
    SetScriptResult ret = new SetScriptResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setScript(final String name, final String script, final com.raritan.idl.luaservice.ScriptOptions options, final AsyncRpcResponse<SetScriptResult> rsp) {
    return setScript(name, script, options, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setScript(final String name, final String script, final com.raritan.idl.luaservice.ScriptOptions options, final AsyncRpcResponse<SetScriptResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("name", name);
      params.put("script", script);
      params.put("options", com.raritan.json_rpc.luaservice.ScriptOptions_Codec.encode(options));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setScript", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetScriptResult ret = new SetScriptResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetScriptResult getScript(final String name) throws Exception {
    JSONObject params = new JSONObject();
    params.put("name", name);
    final JSONObject result = rpcCall("getScript", params);
    GetScriptResult ret = new GetScriptResult();
    ret._ret_ = result.getInt("_ret_");
    ret.script = result.getString("script");
    return ret;
  }

  @Override
  public AsyncRequest getScript(final String name, final AsyncRpcResponse<GetScriptResult> rsp) {
    return getScript(name, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getScript(final String name, final AsyncRpcResponse<GetScriptResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("name", name);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getScript", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetScriptResult ret = new GetScriptResult();
          ret._ret_ = result.getInt("_ret_");
          ret.script = result.getString("script");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetScriptNamesResult getScriptNames() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getScriptNames", params);
    GetScriptNamesResult ret = new GetScriptNamesResult();
    ret._ret_ = new java.util.ArrayList<String>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(array0.getString(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getScriptNames(final AsyncRpcResponse<GetScriptNamesResult> rsp) {
    return getScriptNames(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getScriptNames(final AsyncRpcResponse<GetScriptNamesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getScriptNames", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetScriptNamesResult ret = new GetScriptNamesResult();
          ret._ret_ = new java.util.ArrayList<String>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(array0.getString(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public DeleteScriptResult deleteScript(final String name) throws Exception {
    JSONObject params = new JSONObject();
    params.put("name", name);
    final JSONObject result = rpcCall("deleteScript", params);
    DeleteScriptResult ret = new DeleteScriptResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest deleteScript(final String name, final AsyncRpcResponse<DeleteScriptResult> rsp) {
    return deleteScript(name, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest deleteScript(final String name, final AsyncRpcResponse<DeleteScriptResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("name", name);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("deleteScript", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          DeleteScriptResult ret = new DeleteScriptResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetScriptOptionsResult setScriptOptions(final String name, final com.raritan.idl.luaservice.ScriptOptions options) throws Exception {
    JSONObject params = new JSONObject();
    params.put("name", name);
    params.put("options", com.raritan.json_rpc.luaservice.ScriptOptions_Codec.encode(options));
    final JSONObject result = rpcCall("setScriptOptions", params);
    SetScriptOptionsResult ret = new SetScriptOptionsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setScriptOptions(final String name, final com.raritan.idl.luaservice.ScriptOptions options, final AsyncRpcResponse<SetScriptOptionsResult> rsp) {
    return setScriptOptions(name, options, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setScriptOptions(final String name, final com.raritan.idl.luaservice.ScriptOptions options, final AsyncRpcResponse<SetScriptOptionsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("name", name);
      params.put("options", com.raritan.json_rpc.luaservice.ScriptOptions_Codec.encode(options));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setScriptOptions", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetScriptOptionsResult ret = new SetScriptOptionsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetScriptOptionsResult getScriptOptions(final String name) throws Exception {
    JSONObject params = new JSONObject();
    params.put("name", name);
    final JSONObject result = rpcCall("getScriptOptions", params);
    GetScriptOptionsResult ret = new GetScriptOptionsResult();
    ret._ret_ = result.getInt("_ret_");
    ret.options = com.raritan.json_rpc.luaservice.ScriptOptions_Codec.decode(result.getJSONObject("options"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getScriptOptions(final String name, final AsyncRpcResponse<GetScriptOptionsResult> rsp) {
    return getScriptOptions(name, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getScriptOptions(final String name, final AsyncRpcResponse<GetScriptOptionsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("name", name);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getScriptOptions", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetScriptOptionsResult ret = new GetScriptOptionsResult();
          ret._ret_ = result.getInt("_ret_");
          ret.options = com.raritan.json_rpc.luaservice.ScriptOptions_Codec.decode(result.getJSONObject("options"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetEnvironmentResult getEnvironment() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getEnvironment", params);
    GetEnvironmentResult ret = new GetEnvironmentResult();
    ret._ret_ = com.raritan.json_rpc.luaservice.Environment_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getEnvironment(final AsyncRpcResponse<GetEnvironmentResult> rsp) {
    return getEnvironment(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getEnvironment(final AsyncRpcResponse<GetEnvironmentResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getEnvironment", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetEnvironmentResult ret = new GetEnvironmentResult();
          ret._ret_ = com.raritan.json_rpc.luaservice.Environment_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetScriptOutputResult getScriptOutput(final String name, final long iAddr) throws Exception {
    JSONObject params = new JSONObject();
    params.put("name", name);
    params.put("iAddr", iAddr);
    final JSONObject result = rpcCall("getScriptOutput", params);
    GetScriptOutputResult ret = new GetScriptOutputResult();
    ret._ret_ = result.getInt("_ret_");
    ret.oAddr = result.getLong("oAddr");
    ret.nAddr = result.getLong("nAddr");
    ret.oString = result.getString("oString");
    ret.more = result.getBoolean("more");
    return ret;
  }

  @Override
  public AsyncRequest getScriptOutput(final String name, final long iAddr, final AsyncRpcResponse<GetScriptOutputResult> rsp) {
    return getScriptOutput(name, iAddr, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getScriptOutput(final String name, final long iAddr, final AsyncRpcResponse<GetScriptOutputResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("name", name);
      params.put("iAddr", iAddr);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getScriptOutput", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetScriptOutputResult ret = new GetScriptOutputResult();
          ret._ret_ = result.getInt("_ret_");
          ret.oAddr = result.getLong("oAddr");
          ret.nAddr = result.getLong("nAddr");
          ret.oString = result.getString("oString");
          ret.more = result.getBoolean("more");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public StartScriptResult startScript(final String name) throws Exception {
    JSONObject params = new JSONObject();
    params.put("name", name);
    final JSONObject result = rpcCall("startScript", params);
    StartScriptResult ret = new StartScriptResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest startScript(final String name, final AsyncRpcResponse<StartScriptResult> rsp) {
    return startScript(name, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest startScript(final String name, final AsyncRpcResponse<StartScriptResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("name", name);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("startScript", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          StartScriptResult ret = new StartScriptResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public TerminateScriptResult terminateScript(final String name) throws Exception {
    JSONObject params = new JSONObject();
    params.put("name", name);
    final JSONObject result = rpcCall("terminateScript", params);
    TerminateScriptResult ret = new TerminateScriptResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest terminateScript(final String name, final AsyncRpcResponse<TerminateScriptResult> rsp) {
    return terminateScript(name, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest terminateScript(final String name, final AsyncRpcResponse<TerminateScriptResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("name", name);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("terminateScript", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          TerminateScriptResult ret = new TerminateScriptResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetScriptStateResult getScriptState(final String name) throws Exception {
    JSONObject params = new JSONObject();
    params.put("name", name);
    final JSONObject result = rpcCall("getScriptState", params);
    GetScriptStateResult ret = new GetScriptStateResult();
    ret._ret_ = result.getInt("_ret_");
    ret.state = com.raritan.json_rpc.luaservice.ScriptState_Codec.decode(result.getJSONObject("state"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getScriptState(final String name, final AsyncRpcResponse<GetScriptStateResult> rsp) {
    return getScriptState(name, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getScriptState(final String name, final AsyncRpcResponse<GetScriptStateResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("name", name);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getScriptState", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetScriptStateResult ret = new GetScriptStateResult();
          ret._ret_ = result.getInt("_ret_");
          ret.state = com.raritan.json_rpc.luaservice.ScriptState_Codec.decode(result.getJSONObject("state"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetScriptStatesResult getScriptStates() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getScriptStates", params);
    GetScriptStatesResult ret = new GetScriptStatesResult();
    ret._ret_ = new java.util.HashMap<String, com.raritan.idl.luaservice.ScriptState>() {{
      final JSONArray array0 = result.getJSONArray("_ret_");
      for (int i0 = 0; i0 < array0.length(); i0++) {
        JSONObject elem0 = array0.getJSONObject(i0);
        final String key0 = elem0.getString("key");
        final com.raritan.idl.luaservice.ScriptState value0 = com.raritan.json_rpc.luaservice.ScriptState_Codec.decode(elem0.getJSONObject("value"), agent);
        this.put(key0, value0);
      }
    }};
    return ret;
  }

  @Override
  public AsyncRequest getScriptStates(final AsyncRpcResponse<GetScriptStatesResult> rsp) {
    return getScriptStates(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getScriptStates(final AsyncRpcResponse<GetScriptStatesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getScriptStates", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetScriptStatesResult ret = new GetScriptStatesResult();
          ret._ret_ = new java.util.HashMap<String, com.raritan.idl.luaservice.ScriptState>() {{
            final JSONArray array0 = result.getJSONArray("_ret_");
            for (int i0 = 0; i0 < array0.length(); i0++) {
              JSONObject elem0 = array0.getJSONObject(i0);
              final String key0 = elem0.getString("key");
              final com.raritan.idl.luaservice.ScriptState value0 = com.raritan.json_rpc.luaservice.ScriptState_Codec.decode(elem0.getJSONObject("value"), agent);
              this.put(key0, value0);
            }
          }};
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
