// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from SensorLogger.idl.

package com.raritan.json_rpc.sensors;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class Logger_3_1_3_Proxy extends ObjectProxy implements com.raritan.idl.sensors.Logger_3_1_3 {

  public Logger_3_1_3_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public Logger_3_1_3_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.sensors.Logger_3_1_3.typeInfo);
  }

  public static Logger_3_1_3_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new Logger_3_1_3_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public GetInfoResult getInfo() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getInfo", params);
    GetInfoResult ret = new GetInfoResult();
    ret._ret_ = com.raritan.json_rpc.sensors.Logger_3_1_3.Info_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getInfo(final AsyncRpcResponse<GetInfoResult> rsp) {
    return getInfo(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getInfo(final AsyncRpcResponse<GetInfoResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getInfo", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetInfoResult ret = new GetInfoResult();
          ret._ret_ = com.raritan.json_rpc.sensors.Logger_3_1_3.Info_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetSettingsResult getSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getSettings", params);
    GetSettingsResult ret = new GetSettingsResult();
    ret._ret_ = com.raritan.json_rpc.sensors.Logger_3_1_3.Settings_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getSettings(final AsyncRpcResponse<GetSettingsResult> rsp) {
    return getSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSettings(final AsyncRpcResponse<GetSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSettingsResult ret = new GetSettingsResult();
          ret._ret_ = com.raritan.json_rpc.sensors.Logger_3_1_3.Settings_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetSettingsResult setSettings(final com.raritan.idl.sensors.Logger_3_1_3.Settings settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("settings", com.raritan.json_rpc.sensors.Logger_3_1_3.Settings_Codec.encode(settings));
    final JSONObject result = rpcCall("setSettings", params);
    SetSettingsResult ret = new SetSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setSettings(final com.raritan.idl.sensors.Logger_3_1_3.Settings settings, final AsyncRpcResponse<SetSettingsResult> rsp) {
    return setSettings(settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setSettings(final com.raritan.idl.sensors.Logger_3_1_3.Settings settings, final AsyncRpcResponse<SetSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("settings", com.raritan.json_rpc.sensors.Logger_3_1_3.Settings_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetSettingsResult ret = new SetSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetTimeStampsResult getTimeStamps(final int recid, final int count) throws Exception {
    JSONObject params = new JSONObject();
    params.put("recid", recid);
    params.put("count", count);
    final JSONObject result = rpcCall("getTimeStamps", params);
    GetTimeStampsResult ret = new GetTimeStampsResult();
    ret._ret_ = result.getInt("_ret_");
    ret.timestamps = new java.util.ArrayList<java.util.Date>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("timestamps");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(new java.util.Date(((long) array0.getInt(i0_f)) * 1000));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getTimeStamps(final int recid, final int count, final AsyncRpcResponse<GetTimeStampsResult> rsp) {
    return getTimeStamps(recid, count, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getTimeStamps(final int recid, final int count, final AsyncRpcResponse<GetTimeStampsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("recid", recid);
      params.put("count", count);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getTimeStamps", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetTimeStampsResult ret = new GetTimeStampsResult();
          ret._ret_ = result.getInt("_ret_");
          ret.timestamps = new java.util.ArrayList<java.util.Date>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("timestamps");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(new java.util.Date(((long) array0.getInt(i0_f)) * 1000));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetSensorRecordsResult getSensorRecords(final com.raritan.idl.sensors.Sensor_4_0_7 sensor, final int recid, final int count) throws Exception {
    JSONObject params = new JSONObject();
    params.put("sensor", sensor != null ? ((ObjectProxy) sensor).encode() : JSONObject.NULL);
    params.put("recid", recid);
    params.put("count", count);
    final JSONObject result = rpcCall("getSensorRecords", params);
    GetSensorRecordsResult ret = new GetSensorRecordsResult();
    ret._ret_ = result.getInt("_ret_");
    ret.recs = new java.util.ArrayList<com.raritan.idl.sensors.Logger_3_1_3.Record>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("recs");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.sensors.Logger_3_1_3.Record_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getSensorRecords(final com.raritan.idl.sensors.Sensor_4_0_7 sensor, final int recid, final int count, final AsyncRpcResponse<GetSensorRecordsResult> rsp) {
    return getSensorRecords(sensor, recid, count, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSensorRecords(final com.raritan.idl.sensors.Sensor_4_0_7 sensor, final int recid, final int count, final AsyncRpcResponse<GetSensorRecordsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("sensor", sensor != null ? ((ObjectProxy) sensor).encode() : JSONObject.NULL);
      params.put("recid", recid);
      params.put("count", count);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getSensorRecords", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSensorRecordsResult ret = new GetSensorRecordsResult();
          ret._ret_ = result.getInt("_ret_");
          ret.recs = new java.util.ArrayList<com.raritan.idl.sensors.Logger_3_1_3.Record>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("recs");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.sensors.Logger_3_1_3.Record_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetPeripheralDeviceRecordsResult getPeripheralDeviceRecords(final com.raritan.idl.peripheral.DeviceSlot_5_0_2 slot, final int recid, final int count) throws Exception {
    JSONObject params = new JSONObject();
    params.put("slot", slot != null ? ((ObjectProxy) slot).encode() : JSONObject.NULL);
    params.put("recid", recid);
    params.put("count", count);
    final JSONObject result = rpcCall("getPeripheralDeviceRecords", params);
    GetPeripheralDeviceRecordsResult ret = new GetPeripheralDeviceRecordsResult();
    ret._ret_ = result.getInt("_ret_");
    ret.recs = new java.util.ArrayList<com.raritan.idl.sensors.Logger_3_1_3.Record>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("recs");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.sensors.Logger_3_1_3.Record_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getPeripheralDeviceRecords(final com.raritan.idl.peripheral.DeviceSlot_5_0_2 slot, final int recid, final int count, final AsyncRpcResponse<GetPeripheralDeviceRecordsResult> rsp) {
    return getPeripheralDeviceRecords(slot, recid, count, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getPeripheralDeviceRecords(final com.raritan.idl.peripheral.DeviceSlot_5_0_2 slot, final int recid, final int count, final AsyncRpcResponse<GetPeripheralDeviceRecordsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("slot", slot != null ? ((ObjectProxy) slot).encode() : JSONObject.NULL);
      params.put("recid", recid);
      params.put("count", count);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getPeripheralDeviceRecords", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetPeripheralDeviceRecordsResult ret = new GetPeripheralDeviceRecordsResult();
          ret._ret_ = result.getInt("_ret_");
          ret.recs = new java.util.ArrayList<com.raritan.idl.sensors.Logger_3_1_3.Record>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("recs");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.sensors.Logger_3_1_3.Record_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetSensorTimedRecordsResult getSensorTimedRecords(final com.raritan.idl.sensors.Sensor_4_0_7 sensor, final int recid, final int count) throws Exception {
    JSONObject params = new JSONObject();
    params.put("sensor", sensor != null ? ((ObjectProxy) sensor).encode() : JSONObject.NULL);
    params.put("recid", recid);
    params.put("count", count);
    final JSONObject result = rpcCall("getSensorTimedRecords", params);
    GetSensorTimedRecordsResult ret = new GetSensorTimedRecordsResult();
    ret._ret_ = result.getInt("_ret_");
    ret.recs = new java.util.ArrayList<com.raritan.idl.sensors.Logger_3_1_3.TimedRecord>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("recs");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.sensors.Logger_3_1_3.TimedRecord_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getSensorTimedRecords(final com.raritan.idl.sensors.Sensor_4_0_7 sensor, final int recid, final int count, final AsyncRpcResponse<GetSensorTimedRecordsResult> rsp) {
    return getSensorTimedRecords(sensor, recid, count, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSensorTimedRecords(final com.raritan.idl.sensors.Sensor_4_0_7 sensor, final int recid, final int count, final AsyncRpcResponse<GetSensorTimedRecordsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("sensor", sensor != null ? ((ObjectProxy) sensor).encode() : JSONObject.NULL);
      params.put("recid", recid);
      params.put("count", count);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getSensorTimedRecords", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSensorTimedRecordsResult ret = new GetSensorTimedRecordsResult();
          ret._ret_ = result.getInt("_ret_");
          ret.recs = new java.util.ArrayList<com.raritan.idl.sensors.Logger_3_1_3.TimedRecord>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("recs");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.sensors.Logger_3_1_3.TimedRecord_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetPeripheralDeviceTimedRecordsResult getPeripheralDeviceTimedRecords(final com.raritan.idl.peripheral.DeviceSlot_5_0_2 slot, final int recid, final int count) throws Exception {
    JSONObject params = new JSONObject();
    params.put("slot", slot != null ? ((ObjectProxy) slot).encode() : JSONObject.NULL);
    params.put("recid", recid);
    params.put("count", count);
    final JSONObject result = rpcCall("getPeripheralDeviceTimedRecords", params);
    GetPeripheralDeviceTimedRecordsResult ret = new GetPeripheralDeviceTimedRecordsResult();
    ret._ret_ = result.getInt("_ret_");
    ret.recs = new java.util.ArrayList<com.raritan.idl.sensors.Logger_3_1_3.TimedRecord>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("recs");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.sensors.Logger_3_1_3.TimedRecord_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getPeripheralDeviceTimedRecords(final com.raritan.idl.peripheral.DeviceSlot_5_0_2 slot, final int recid, final int count, final AsyncRpcResponse<GetPeripheralDeviceTimedRecordsResult> rsp) {
    return getPeripheralDeviceTimedRecords(slot, recid, count, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getPeripheralDeviceTimedRecords(final com.raritan.idl.peripheral.DeviceSlot_5_0_2 slot, final int recid, final int count, final AsyncRpcResponse<GetPeripheralDeviceTimedRecordsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("slot", slot != null ? ((ObjectProxy) slot).encode() : JSONObject.NULL);
      params.put("recid", recid);
      params.put("count", count);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getPeripheralDeviceTimedRecords", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetPeripheralDeviceTimedRecordsResult ret = new GetPeripheralDeviceTimedRecordsResult();
          ret._ret_ = result.getInt("_ret_");
          ret.recs = new java.util.ArrayList<com.raritan.idl.sensors.Logger_3_1_3.TimedRecord>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("recs");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.sensors.Logger_3_1_3.TimedRecord_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetLoggedSensorsResult getLoggedSensors() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getLoggedSensors", params);
    GetLoggedSensorsResult ret = new GetLoggedSensorsResult();
    ret._ret_ = com.raritan.json_rpc.sensors.Logger_3_1_3.SensorSet_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getLoggedSensors(final AsyncRpcResponse<GetLoggedSensorsResult> rsp) {
    return getLoggedSensors(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getLoggedSensors(final AsyncRpcResponse<GetLoggedSensorsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getLoggedSensors", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetLoggedSensorsResult ret = new GetLoggedSensorsResult();
          ret._ret_ = com.raritan.json_rpc.sensors.Logger_3_1_3.SensorSet_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetLoggedSensorsResult setLoggedSensors(final com.raritan.idl.sensors.Logger_3_1_3.SensorSet sensors) throws Exception {
    JSONObject params = new JSONObject();
    params.put("sensors", com.raritan.json_rpc.sensors.Logger_3_1_3.SensorSet_Codec.encode(sensors));
    final JSONObject result = rpcCall("setLoggedSensors", params);
    SetLoggedSensorsResult ret = new SetLoggedSensorsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setLoggedSensors(final com.raritan.idl.sensors.Logger_3_1_3.SensorSet sensors, final AsyncRpcResponse<SetLoggedSensorsResult> rsp) {
    return setLoggedSensors(sensors, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setLoggedSensors(final com.raritan.idl.sensors.Logger_3_1_3.SensorSet sensors, final AsyncRpcResponse<SetLoggedSensorsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("sensors", com.raritan.json_rpc.sensors.Logger_3_1_3.SensorSet_Codec.encode(sensors));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setLoggedSensors", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetLoggedSensorsResult ret = new SetLoggedSensorsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public EnableSensorsResult enableSensors(final com.raritan.idl.sensors.Logger_3_1_3.SensorSet sensors) throws Exception {
    JSONObject params = new JSONObject();
    params.put("sensors", com.raritan.json_rpc.sensors.Logger_3_1_3.SensorSet_Codec.encode(sensors));
    final JSONObject result = rpcCall("enableSensors", params);
    EnableSensorsResult ret = new EnableSensorsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest enableSensors(final com.raritan.idl.sensors.Logger_3_1_3.SensorSet sensors, final AsyncRpcResponse<EnableSensorsResult> rsp) {
    return enableSensors(sensors, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest enableSensors(final com.raritan.idl.sensors.Logger_3_1_3.SensorSet sensors, final AsyncRpcResponse<EnableSensorsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("sensors", com.raritan.json_rpc.sensors.Logger_3_1_3.SensorSet_Codec.encode(sensors));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("enableSensors", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          EnableSensorsResult ret = new EnableSensorsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public DisableSensorsResult disableSensors(final com.raritan.idl.sensors.Logger_3_1_3.SensorSet sensors) throws Exception {
    JSONObject params = new JSONObject();
    params.put("sensors", com.raritan.json_rpc.sensors.Logger_3_1_3.SensorSet_Codec.encode(sensors));
    final JSONObject result = rpcCall("disableSensors", params);
    DisableSensorsResult ret = new DisableSensorsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest disableSensors(final com.raritan.idl.sensors.Logger_3_1_3.SensorSet sensors, final AsyncRpcResponse<DisableSensorsResult> rsp) {
    return disableSensors(sensors, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest disableSensors(final com.raritan.idl.sensors.Logger_3_1_3.SensorSet sensors, final AsyncRpcResponse<DisableSensorsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("sensors", com.raritan.json_rpc.sensors.Logger_3_1_3.SensorSet_Codec.encode(sensors));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("disableSensors", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          DisableSensorsResult ret = new DisableSensorsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public IsSensorEnabledResult isSensorEnabled(final com.raritan.idl.sensors.Sensor_4_0_7 sensor) throws Exception {
    JSONObject params = new JSONObject();
    params.put("sensor", sensor != null ? ((ObjectProxy) sensor).encode() : JSONObject.NULL);
    final JSONObject result = rpcCall("isSensorEnabled", params);
    IsSensorEnabledResult ret = new IsSensorEnabledResult();
    ret._ret_ = result.getBoolean("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest isSensorEnabled(final com.raritan.idl.sensors.Sensor_4_0_7 sensor, final AsyncRpcResponse<IsSensorEnabledResult> rsp) {
    return isSensorEnabled(sensor, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest isSensorEnabled(final com.raritan.idl.sensors.Sensor_4_0_7 sensor, final AsyncRpcResponse<IsSensorEnabledResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("sensor", sensor != null ? ((ObjectProxy) sensor).encode() : JSONObject.NULL);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("isSensorEnabled", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          IsSensorEnabledResult ret = new IsSensorEnabledResult();
          ret._ret_ = result.getBoolean("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public IsSlotEnabledResult isSlotEnabled(final com.raritan.idl.peripheral.DeviceSlot_5_0_2 slot) throws Exception {
    JSONObject params = new JSONObject();
    params.put("slot", slot != null ? ((ObjectProxy) slot).encode() : JSONObject.NULL);
    final JSONObject result = rpcCall("isSlotEnabled", params);
    IsSlotEnabledResult ret = new IsSlotEnabledResult();
    ret._ret_ = result.getBoolean("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest isSlotEnabled(final com.raritan.idl.peripheral.DeviceSlot_5_0_2 slot, final AsyncRpcResponse<IsSlotEnabledResult> rsp) {
    return isSlotEnabled(slot, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest isSlotEnabled(final com.raritan.idl.peripheral.DeviceSlot_5_0_2 slot, final AsyncRpcResponse<IsSlotEnabledResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("slot", slot != null ? ((ObjectProxy) slot).encode() : JSONObject.NULL);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("isSlotEnabled", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          IsSlotEnabledResult ret = new IsSlotEnabledResult();
          ret._ret_ = result.getBoolean("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void enableAllSensors() throws Exception {
    JSONObject params = null;
    rpcCall("enableAllSensors", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest enableAllSensors(final AsyncRpcResponse<Void> rsp) {
    return enableAllSensors(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest enableAllSensors(final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("enableAllSensors", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void disableAllSensors() throws Exception {
    JSONObject params = null;
    rpcCall("disableAllSensors", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest disableAllSensors(final AsyncRpcResponse<Void> rsp) {
    return disableAllSensors(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest disableAllSensors(final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("disableAllSensors", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetSensorSetTimestampResult getSensorSetTimestamp() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getSensorSetTimestamp", params);
    GetSensorSetTimestampResult ret = new GetSensorSetTimestampResult();
    ret._ret_ = new java.util.Date(((long) result.getInt("_ret_")) * 1000);
    return ret;
  }

  @Override
  public AsyncRequest getSensorSetTimestamp(final AsyncRpcResponse<GetSensorSetTimestampResult> rsp) {
    return getSensorSetTimestamp(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSensorSetTimestamp(final AsyncRpcResponse<GetSensorSetTimestampResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getSensorSetTimestamp", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSensorSetTimestampResult ret = new GetSensorSetTimestampResult();
          ret._ret_ = new java.util.Date(((long) result.getInt("_ret_")) * 1000);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetLogRowResult getLogRow(final int recid) throws Exception {
    JSONObject params = new JSONObject();
    params.put("recid", recid);
    final JSONObject result = rpcCall("getLogRow", params);
    GetLogRowResult ret = new GetLogRowResult();
    ret._ret_ = result.getInt("_ret_");
    ret.row = com.raritan.json_rpc.sensors.Logger_3_1_3.LogRow_Codec.decode(result.getJSONObject("row"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getLogRow(final int recid, final AsyncRpcResponse<GetLogRowResult> rsp) {
    return getLogRow(recid, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getLogRow(final int recid, final AsyncRpcResponse<GetLogRowResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("recid", recid);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getLogRow", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetLogRowResult ret = new GetLogRowResult();
          ret._ret_ = result.getInt("_ret_");
          ret.row = com.raritan.json_rpc.sensors.Logger_3_1_3.LogRow_Codec.decode(result.getJSONObject("row"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
