// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from User.idl.

package com.raritan.json_rpc.usermgmt;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class User_Proxy extends ObjectProxy implements com.raritan.idl.usermgmt.User {

  public User_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public User_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.usermgmt.User.typeInfo);
  }

  public static User_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new User_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public GetInfoResult getInfo() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getInfo", params);
    GetInfoResult ret = new GetInfoResult();
    ret._ret_ = com.raritan.json_rpc.usermgmt.UserInfo_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getInfo(final AsyncRpcResponse<GetInfoResult> rsp) {
    return getInfo(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getInfo(final AsyncRpcResponse<GetInfoResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getInfo", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetInfoResult ret = new GetInfoResult();
          ret._ret_ = com.raritan.json_rpc.usermgmt.UserInfo_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetAccountPasswordResult setAccountPassword(final String password) throws Exception {
    JSONObject params = new JSONObject();
    params.put("password", password);
    final JSONObject result = rpcCall("setAccountPassword", params);
    SetAccountPasswordResult ret = new SetAccountPasswordResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setAccountPassword(final String password, final AsyncRpcResponse<SetAccountPasswordResult> rsp) {
    return setAccountPassword(password, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setAccountPassword(final String password, final AsyncRpcResponse<SetAccountPasswordResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("password", password);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setAccountPassword", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetAccountPasswordResult ret = new SetAccountPasswordResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public UpdateAccountFullResult updateAccountFull(final String password, final com.raritan.idl.usermgmt.UserInfo info) throws Exception {
    JSONObject params = new JSONObject();
    params.put("password", password);
    params.put("info", com.raritan.json_rpc.usermgmt.UserInfo_Codec.encode(info));
    final JSONObject result = rpcCall("updateAccountFull", params);
    UpdateAccountFullResult ret = new UpdateAccountFullResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest updateAccountFull(final String password, final com.raritan.idl.usermgmt.UserInfo info, final AsyncRpcResponse<UpdateAccountFullResult> rsp) {
    return updateAccountFull(password, info, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest updateAccountFull(final String password, final com.raritan.idl.usermgmt.UserInfo info, final AsyncRpcResponse<UpdateAccountFullResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("password", password);
      params.put("info", com.raritan.json_rpc.usermgmt.UserInfo_Codec.encode(info));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("updateAccountFull", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          UpdateAccountFullResult ret = new UpdateAccountFullResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetInfoAndPrivilegesResult getInfoAndPrivileges() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getInfoAndPrivileges", params);
    GetInfoAndPrivilegesResult ret = new GetInfoAndPrivilegesResult();
    ret.info = com.raritan.json_rpc.usermgmt.UserInfo_Codec.decode(result.getJSONObject("info"), agent);
    ret.privileges = new java.util.ArrayList<com.raritan.idl.usermgmt.Role.Privilege>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("privileges");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.usermgmt.Role.Privilege_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getInfoAndPrivileges(final AsyncRpcResponse<GetInfoAndPrivilegesResult> rsp) {
    return getInfoAndPrivileges(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getInfoAndPrivileges(final AsyncRpcResponse<GetInfoAndPrivilegesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getInfoAndPrivileges", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetInfoAndPrivilegesResult ret = new GetInfoAndPrivilegesResult();
          ret.info = com.raritan.json_rpc.usermgmt.UserInfo_Codec.decode(result.getJSONObject("info"), agent);
          ret.privileges = new java.util.ArrayList<com.raritan.idl.usermgmt.Role.Privilege>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("privileges");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.usermgmt.Role.Privilege_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
