// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from RadiusManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.auth {
  public class RadiusManager_4_0_0 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("auth.RadiusManager:4.0.0", null);

    public RadiusManager_4_0_0(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public RadiusManager_4_0_0(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new RadiusManager_4_0_0 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new RadiusManager_4_0_0(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum AuthType {
      PAP,
      CHAP,
      MSCHAPv2,
    }

    public class ServerSettings : ICloneable {
      public object Clone() {
        ServerSettings copy = new ServerSettings();
        copy.id = this.id;
        copy.server = this.server;
        copy.sharedSecret = this.sharedSecret;
        copy.udpAuthPort = this.udpAuthPort;
        copy.udpAccountPort = this.udpAccountPort;
        copy.timeout = this.timeout;
        copy.retries = this.retries;
        copy.authType = this.authType;
        copy.disableAccounting = this.disableAccounting;
        copy.messageAuthenticatorOptional = this.messageAuthenticatorOptional;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["id"] = this.id;
        json["server"] = this.server;
        json["sharedSecret"] = this.sharedSecret;
        json["udpAuthPort"] = this.udpAuthPort;
        json["udpAccountPort"] = this.udpAccountPort;
        json["timeout"] = this.timeout;
        json["retries"] = this.retries;
        json["authType"] = (int)this.authType;
        json["disableAccounting"] = this.disableAccounting;
        json["messageAuthenticatorOptional"] = this.messageAuthenticatorOptional;
        return json;
      }

      public static ServerSettings Decode(LightJson.JsonObject json, Agent agent) {
        ServerSettings inst = new ServerSettings();
        inst.id = (string)json["id"];
        inst.server = (string)json["server"];
        inst.sharedSecret = (string)json["sharedSecret"];
        inst.udpAuthPort = (int)json["udpAuthPort"];
        inst.udpAccountPort = (int)json["udpAccountPort"];
        inst.timeout = (int)json["timeout"];
        inst.retries = (int)json["retries"];
        inst.authType = (Com.Raritan.Idl.auth.RadiusManager_4_0_0.AuthType)(int)json["authType"];
        inst.disableAccounting = (bool)json["disableAccounting"];
        inst.messageAuthenticatorOptional = (bool)json["messageAuthenticatorOptional"];
        return inst;
      }

      public string id = "";
      public string server = "";
      public string sharedSecret = "";
      public int udpAuthPort = 0;
      public int udpAccountPort = 0;
      public int timeout = 0;
      public int retries = 0;
      public Com.Raritan.Idl.auth.RadiusManager_4_0_0.AuthType authType = Com.Raritan.Idl.auth.RadiusManager_4_0_0.AuthType.PAP;
      public bool disableAccounting = false;
      public bool messageAuthenticatorOptional = false;
    }

    public const int ERR_INVALID_CFG = 1;

    public const int ERR_SERVER_UNSPECIFIED = 2;

    public const int ERR_INVALID_SHARED_SECRET = 3;

    public const int ERR_SERVER_UNREACHABLE = 4;

    public const int ERR_AUTHENTICATION_FAILED = 5;

    public const int ERR_NO_ROLES = 6;

    public const int ERR_NO_KNOWN_ROLES = 7;

    public const int ERR_MSG_AUTH_ATTR_MISSING = 8;

    public class GetRadiusServersResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.RadiusManager_4_0_0.ServerSettings> _ret_;
    }

    public GetRadiusServersResult getRadiusServers() {
      JsonObject _parameters = null;
      var _result = RpcCall("getRadiusServers", _parameters);
      var _ret = new GetRadiusServersResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.auth.RadiusManager_4_0_0.ServerSettings>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.auth.RadiusManager_4_0_0.ServerSettings.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getRadiusServers(AsyncRpcResponse<GetRadiusServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getRadiusServers(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getRadiusServers(AsyncRpcResponse<GetRadiusServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getRadiusServers", _parameters,
        _result => {
          try {
            var _ret = new GetRadiusServersResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.auth.RadiusManager_4_0_0.ServerSettings>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.auth.RadiusManager_4_0_0.ServerSettings.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetRadiusServersResult {
      public int _ret_;
    }

    public SetRadiusServersResult setRadiusServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.RadiusManager_4_0_0.ServerSettings> serverList) {
      var _parameters = new LightJson.JsonObject();
      _parameters["serverList"] = new JsonArray(serverList.Select(
        _value => (JsonValue)(_value.Encode())));

      var _result = RpcCall("setRadiusServers", _parameters);
      var _ret = new SetRadiusServersResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setRadiusServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.RadiusManager_4_0_0.ServerSettings> serverList, AsyncRpcResponse<SetRadiusServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setRadiusServers(serverList, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setRadiusServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.RadiusManager_4_0_0.ServerSettings> serverList, AsyncRpcResponse<SetRadiusServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["serverList"] = new JsonArray(serverList.Select(
          _value => (JsonValue)(_value.Encode())));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setRadiusServers", _parameters,
        _result => {
          try {
            var _ret = new SetRadiusServersResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class TestRadiusServerResult {
      public int _ret_;
    }

    public TestRadiusServerResult testRadiusServer(string username, string password, Com.Raritan.Idl.auth.RadiusManager_4_0_0.ServerSettings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["username"] = username;
      _parameters["password"] = password;
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("testRadiusServer", _parameters);
      var _ret = new TestRadiusServerResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest testRadiusServer(string username, string password, Com.Raritan.Idl.auth.RadiusManager_4_0_0.ServerSettings settings, AsyncRpcResponse<TestRadiusServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return testRadiusServer(username, password, settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest testRadiusServer(string username, string password, Com.Raritan.Idl.auth.RadiusManager_4_0_0.ServerSettings settings, AsyncRpcResponse<TestRadiusServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["username"] = username;
        _parameters["password"] = password;
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("testRadiusServer", _parameters,
        _result => {
          try {
            var _ret = new TestRadiusServerResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
