// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Net.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.net {

  public class NetworkConfigIPv6 : ICloneable {
    public object Clone() {
      NetworkConfigIPv6 copy = new NetworkConfigIPv6();
      copy.enabled = this.enabled;
      copy.autocfg = this.autocfg;
      copy.ipaddr = this.ipaddr;
      copy.gateway = this.gateway;
      copy.hostname = this.hostname;
      copy.dns_suffixes = this.dns_suffixes;
      copy.override_dns = this.override_dns;
      copy.dns_ip_1 = this.dns_ip_1;
      copy.dns_ip_2 = this.dns_ip_2;
      copy.domain_name = this.domain_name;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["enabled"] = this.enabled;
      json["autocfg"] = (int)this.autocfg;
      json["ipaddr"] = this.ipaddr;
      json["gateway"] = this.gateway;
      json["hostname"] = this.hostname;
      json["dns_suffixes"] = new JsonArray(this.dns_suffixes.Select(
        _value => (JsonValue)(_value)));
      json["override_dns"] = this.override_dns;
      json["dns_ip_1"] = this.dns_ip_1;
      json["dns_ip_2"] = this.dns_ip_2;
      json["domain_name"] = this.domain_name;
      return json;
    }

    public static NetworkConfigIPv6 Decode(LightJson.JsonObject json, Agent agent) {
      NetworkConfigIPv6 inst = new NetworkConfigIPv6();
      inst.enabled = (bool)json["enabled"];
      inst.autocfg = (Com.Raritan.Idl.net.AutoConfigs)(int)json["autocfg"];
      inst.ipaddr = (string)json["ipaddr"];
      inst.gateway = (string)json["gateway"];
      inst.hostname = (string)json["hostname"];
      inst.dns_suffixes = new System.Collections.Generic.List<string>(json["dns_suffixes"].AsJsonArray.Select(
        _value => (string)_value));
      inst.override_dns = (bool)json["override_dns"];
      inst.dns_ip_1 = (string)json["dns_ip_1"];
      inst.dns_ip_2 = (string)json["dns_ip_2"];
      inst.domain_name = (string)json["domain_name"];
      return inst;
    }

    public bool enabled = false;
    public Com.Raritan.Idl.net.AutoConfigs autocfg = Com.Raritan.Idl.net.AutoConfigs.STATIC;
    public string ipaddr = "";
    public string gateway = "";
    public string hostname = "";
    public System.Collections.Generic.IEnumerable<string> dns_suffixes = new System.Collections.Generic.List<string>();
    public bool override_dns = false;
    public string dns_ip_1 = "";
    public string dns_ip_2 = "";
    public string domain_name = "";
  }
}
