# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from PortForwardingAutoSetup.idl.

use strict;

package Raritan::RPC::net::PortForwardingAutoSetup;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "net.PortForwardingAutoSetup:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::net::PortForwardingAutoSetup::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant SUCCESS => 0;

use constant ERR_PF_AUTO_SETUP_NOT_A_PRIMARY_UNIT => 1;

use constant ERR_PF_AUTO_SETUP_ALREADY_RUNNING => 2;

use constant ERR_PF_AUTO_SETUP_INVALID_PARAM => 3;

sub start($$$$$$) {
    my ($self, $numberOfExpansionUnits, $username, $password, $newPassword, $disableStrongPasswordReq) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'numberOfExpansionUnits'} = 1 * $numberOfExpansionUnits;
    $args->{'username'} = "$username";
    $args->{'password'} = "$password";
    $args->{'newPassword'} = "$newPassword";
    $args->{'disableStrongPasswordReq'} = ($disableStrongPasswordReq) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'start', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::net::PortForwardingAutoSetupStatus;

sub getStatus($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getStatus', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::net::PortForwardingAutoSetupStatus::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

sub cancel($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'cancel', $args);
}

Raritan::RPC::Registry::registerProxyClass('net.PortForwardingAutoSetup', 1, 0, 0, 'Raritan::RPC::net::PortForwardingAutoSetup');
1;
