# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from Security.idl.

use strict;

package Raritan::RPC::security::Security_5_0_1;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "security.Security:5.0.1";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::security::Security_5_0_1::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant ERR_INVALID_VALUE => 1;

sub getHttpRedirSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getHttpRedirSettings', $args);
    my $_ret_;
    $_ret_ = ($rsp->{'_ret_'}) ? 1 : 0;
    return $_ret_;
}

sub setHttpRedirSettings($$) {
    my ($self, $http2httpsRedir) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'http2httpsRedir'} = ($http2httpsRedir) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setHttpRedirSettings', $args);
}

sub isHstsEnabled($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'isHstsEnabled', $args);
    my $_ret_;
    $_ret_ = ($rsp->{'_ret_'}) ? 1 : 0;
    return $_ret_;
}

sub setHstsEnabled($$) {
    my ($self, $enable) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'enable'} = ($enable) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setHstsEnabled', $args);
}

use Raritan::RPC::security::IpFw_2_0_0;

sub getIpFwSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getIpFwSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::security::IpFw_2_0_0::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::security::IpFw_2_0_0;

sub setIpFwSettings($$) {
    my ($self, $ipFw) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'ipFw'} = Raritan::RPC::security::IpFw_2_0_0::encode($ipFw);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setIpFwSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::security::IpFw_2_0_0;

sub getIpV6FwSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getIpV6FwSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::security::IpFw_2_0_0::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::security::IpFw_2_0_0;

sub setIpV6FwSettings($$) {
    my ($self, $ipV6Fw) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'ipV6Fw'} = Raritan::RPC::security::IpFw_2_0_0::encode($ipV6Fw);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setIpV6FwSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::security::RoleAccessControl;

sub getRoleAccessControlSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getRoleAccessControlSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::security::RoleAccessControl::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::security::RoleAccessControl;

sub setRoleAccessControlSettings($$) {
    my ($self, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = Raritan::RPC::security::RoleAccessControl::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setRoleAccessControlSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::security::RoleAccessControl;

sub getRoleAccessControlSettingsV6($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getRoleAccessControlSettingsV6', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::security::RoleAccessControl::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::security::RoleAccessControl;

sub setRoleAccessControlSettingsV6($$) {
    my ($self, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = Raritan::RPC::security::RoleAccessControl::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setRoleAccessControlSettingsV6', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::security::BlockSettings;

sub getBlockSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getBlockSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::security::BlockSettings::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::security::BlockSettings;

sub setBlockSettings($$) {
    my ($self, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = Raritan::RPC::security::BlockSettings::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setBlockSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::security::PasswordSettings;

sub getPwSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getPwSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::security::PasswordSettings::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::security::PasswordSettings;

sub setPwSettings($$) {
    my ($self, $pwSettings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'pwSettings'} = Raritan::RPC::security::PasswordSettings::encode($pwSettings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setPwSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub getIdleTimeoutSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getIdleTimeoutSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub setIdleTimeoutSettings($$) {
    my ($self, $idleTimeout) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'idleTimeout'} = 1 * $idleTimeout;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setIdleTimeoutSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub getSingleLoginLimitation($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSingleLoginLimitation', $args);
    my $_ret_;
    $_ret_ = ($rsp->{'_ret_'}) ? 1 : 0;
    return $_ret_;
}

sub setSingleLoginLimitation($$) {
    my ($self, $singleLogin) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'singleLogin'} = ($singleLogin) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setSingleLoginLimitation', $args);
}

use Raritan::RPC::security::SSHSettings;

sub getSSHSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSSHSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::security::SSHSettings::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::security::SSHSettings;

sub setSSHSettings($$) {
    my ($self, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = Raritan::RPC::security::SSHSettings::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setSSHSettings', $args);
}

use Raritan::RPC::security::SSHHostKey_2_0_0;

sub getSSHHostKeys($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSSHHostKeys', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::security::SSHHostKey_2_0_0::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

use Raritan::RPC::security::RestrictedServiceAgreement;

sub getRestrictedServiceAgreement($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getRestrictedServiceAgreement', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::security::RestrictedServiceAgreement::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::security::RestrictedServiceAgreement;

sub setRestrictedServiceAgreement($$) {
    my ($self, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = Raritan::RPC::security::RestrictedServiceAgreement::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setRestrictedServiceAgreement', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub getSupportedFrontPanelPrivileges($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSupportedFrontPanelPrivileges', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = $rsp->{'_ret_'}->[$i0];
    }
    return $_ret_;
}

sub getFrontPanelPrivileges($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getFrontPanelPrivileges', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = $rsp->{'_ret_'}->[$i0];
    }
    return $_ret_;
}

sub setFrontPanelPrivileges($$) {
    my ($self, $privileges) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'privileges'} = [];
    for (my $i0 = 0; $i0 <= $#{$privileges}; $i0++) {
        $args->{'privileges'}->[$i0] = "$privileges->[$i0]";
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setFrontPanelPrivileges', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub setDefaultAdminAccountPassword($$$) {
    my ($self, $password, $disableStrongPasswordReq) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'password'} = "$password";
    $args->{'disableStrongPasswordReq'} = ($disableStrongPasswordReq) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setDefaultAdminAccountPassword', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub setAdminAccountPasswordHash($$) {
    my ($self, $passwordHash) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'passwordHash'} = "$passwordHash";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setAdminAccountPasswordHash', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub isSecureBootActive($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'isSecureBootActive', $args);
    my $_ret_;
    $_ret_ = ($rsp->{'_ret_'}) ? 1 : 0;
    return $_ret_;
}

use Raritan::RPC::security::TpmInfo;

sub getTpmInfo($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getTpmInfo', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::security::TpmInfo::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::security::FipsSettings;

sub getActiveFipsSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getActiveFipsSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::security::FipsSettings::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::security::FipsSettings;

sub getPersistentFipsSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getPersistentFipsSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::security::FipsSettings::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::security::FipsSettings;

sub setPersistentFipsSettings($$) {
    my ($self, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = Raritan::RPC::security::FipsSettings::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setPersistentFipsSettings', $args);
}

Raritan::RPC::Registry::registerProxyClass('security.Security', 5, 0, 1, 'Raritan::RPC::security::Security_5_0_1');
1;
