# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "AuthManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.auth


# enumeration
class Type(Enumeration):
    idlType = "auth.Type:1.0.0"
    values = ["LOCAL", "RADIUS", "KERBEROS", "TACACS_PLUS", "LDAP"]

Type.LOCAL = Type(0)
Type.RADIUS = Type(1)
Type.KERBEROS = Type(2)
Type.TACACS_PLUS = Type(3)
Type.LDAP = Type(4)

# structure
class Policy(Structure):
    idlType = "auth.Policy:1.0.0"
    elements = ["type", "useLocalIfRemoteFailed"]

    def __init__(self, type=None, useLocalIfRemoteFailed=False):
        if type is None:
            type = raritan.rpc.auth.Type.LOCAL
        typecheck.is_enum(type, raritan.rpc.auth.Type, AssertionError)
        typecheck.is_bool(useLocalIfRemoteFailed, AssertionError)

        self.type = type
        self.useLocalIfRemoteFailed = useLocalIfRemoteFailed

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            type = raritan.rpc.auth.Type.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.auth.Type.LOCAL,
            useLocalIfRemoteFailed = json['useLocalIfRemoteFailed'] if 'useLocalIfRemoteFailed' in json or not useDefaults else False,
        )
        return obj

    def encode(self):
        json = {}
        json['type'] = raritan.rpc.auth.Type.encode(self.type)
        json['useLocalIfRemoteFailed'] = self.useLocalIfRemoteFailed
        return json

# interface
class AuthManager(Interface):
    idlType = "auth.AuthManager:1.0.0"

    ERR_UNSUPPORTED_TYPE = 1

    class _getPolicy(Interface.Method):
        name = 'getPolicy'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.auth.Policy.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.auth.Policy, DecodeException)
            return _ret_

    class _setPolicy(Interface.Method):
        name = 'setPolicy'

        @staticmethod
        def encode(p):
            typecheck.is_struct(p, raritan.rpc.auth.Policy, AssertionError)
            args = {}
            args['p'] = raritan.rpc.auth.Policy.encode(p)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(AuthManager, self).__init__(target, agent)
        self.getPolicy = AuthManager._getPolicy(self)
        self.setPolicy = AuthManager._setPolicy(self)

#
# Section generated by IdlC from "LdapManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.auth


# interface
class LdapManager(Interface):
    idlType = "auth.LdapManager:5.0.0"

    # enumeration
    class ServerType(Enumeration):
        idlType = "auth.LdapManager_5_0_0.ServerType:1.0.0"
        values = ["ACTIVE_DIRECTORY", "OPEN_LDAP"]

    ServerType.ACTIVE_DIRECTORY = ServerType(0)
    ServerType.OPEN_LDAP = ServerType(1)

    # enumeration
    class SecurityProtocol(Enumeration):
        idlType = "auth.LdapManager_5_0_0.SecurityProtocol:1.0.0"
        values = ["SEC_PROTO_NONE", "SEC_PROTO_SSL", "SEC_PROTO_STARTTLS"]

    SecurityProtocol.SEC_PROTO_NONE = SecurityProtocol(0)
    SecurityProtocol.SEC_PROTO_SSL = SecurityProtocol(1)
    SecurityProtocol.SEC_PROTO_STARTTLS = SecurityProtocol(2)

    # structure
    class ServerSettings(Structure):
        idlType = "auth.LdapManager_5_0_0.ServerSettings:1.0.0"
        elements = ["server", "type", "secProto", "port", "sslPort", "forceTrustedCert", "allowOffTimeRangeCerts", "certificate", "adsDomain", "useAnonymousBind", "bindDN", "bindPwd", "searchBaseDN", "loginNameAttr", "userEntryObjClass", "userSearchFilter", "groupInfoInUserEntry", "supportNestedGroups", "groupMemberAttr", "groupEntryObjClass", "groupSearchFilter"]

        def __init__(self, server="", type=None, secProto=None, port=0, sslPort=0, forceTrustedCert=False, allowOffTimeRangeCerts=False, certificate="", adsDomain="", useAnonymousBind=False, bindDN="", bindPwd="", searchBaseDN="", loginNameAttr="", userEntryObjClass="", userSearchFilter="", groupInfoInUserEntry=False, supportNestedGroups=False, groupMemberAttr="", groupEntryObjClass="", groupSearchFilter=""):
            if type is None:
                type = raritan.rpc.auth.LdapManager.ServerType.ACTIVE_DIRECTORY
            if secProto is None:
                secProto = raritan.rpc.auth.LdapManager.SecurityProtocol.SEC_PROTO_NONE
            if not typecheck._is_int(server):
                typecheck.is_string(server, AssertionError)
            typecheck.is_enum(type, raritan.rpc.auth.LdapManager.ServerType, AssertionError)
            typecheck.is_enum(secProto, raritan.rpc.auth.LdapManager.SecurityProtocol, AssertionError)
            typecheck.is_int(port, AssertionError)
            typecheck.is_int(sslPort, AssertionError)
            typecheck.is_bool(forceTrustedCert, AssertionError)
            typecheck.is_bool(allowOffTimeRangeCerts, AssertionError)
            if not typecheck._is_int(certificate):
                typecheck.is_string(certificate, AssertionError)
            if not typecheck._is_int(adsDomain):
                typecheck.is_string(adsDomain, AssertionError)
            typecheck.is_bool(useAnonymousBind, AssertionError)
            if not typecheck._is_int(bindDN):
                typecheck.is_string(bindDN, AssertionError)
            if not typecheck._is_int(bindPwd):
                typecheck.is_string(bindPwd, AssertionError)
            if not typecheck._is_int(searchBaseDN):
                typecheck.is_string(searchBaseDN, AssertionError)
            if not typecheck._is_int(loginNameAttr):
                typecheck.is_string(loginNameAttr, AssertionError)
            if not typecheck._is_int(userEntryObjClass):
                typecheck.is_string(userEntryObjClass, AssertionError)
            if not typecheck._is_int(userSearchFilter):
                typecheck.is_string(userSearchFilter, AssertionError)
            typecheck.is_bool(groupInfoInUserEntry, AssertionError)
            typecheck.is_bool(supportNestedGroups, AssertionError)
            if not typecheck._is_int(groupMemberAttr):
                typecheck.is_string(groupMemberAttr, AssertionError)
            if not typecheck._is_int(groupEntryObjClass):
                typecheck.is_string(groupEntryObjClass, AssertionError)
            if not typecheck._is_int(groupSearchFilter):
                typecheck.is_string(groupSearchFilter, AssertionError)

            self.server = server
            self.type = type
            self.secProto = secProto
            self.port = port
            self.sslPort = sslPort
            self.forceTrustedCert = forceTrustedCert
            self.allowOffTimeRangeCerts = allowOffTimeRangeCerts
            self.certificate = certificate
            self.adsDomain = adsDomain
            self.useAnonymousBind = useAnonymousBind
            self.bindDN = bindDN
            self.bindPwd = bindPwd
            self.searchBaseDN = searchBaseDN
            self.loginNameAttr = loginNameAttr
            self.userEntryObjClass = userEntryObjClass
            self.userSearchFilter = userSearchFilter
            self.groupInfoInUserEntry = groupInfoInUserEntry
            self.supportNestedGroups = supportNestedGroups
            self.groupMemberAttr = groupMemberAttr
            self.groupEntryObjClass = groupEntryObjClass
            self.groupSearchFilter = groupSearchFilter

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                server = json['server'] if 'server' in json or not useDefaults else "",
                type = raritan.rpc.auth.LdapManager.ServerType.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.auth.LdapManager.ServerType.ACTIVE_DIRECTORY,
                secProto = raritan.rpc.auth.LdapManager.SecurityProtocol.decode(json['secProto']) if 'secProto' in json or not useDefaults else raritan.rpc.auth.LdapManager.SecurityProtocol.SEC_PROTO_NONE,
                port = json['port'] if 'port' in json or not useDefaults else 0,
                sslPort = json['sslPort'] if 'sslPort' in json or not useDefaults else 0,
                forceTrustedCert = json['forceTrustedCert'] if 'forceTrustedCert' in json or not useDefaults else False,
                allowOffTimeRangeCerts = json['allowOffTimeRangeCerts'] if 'allowOffTimeRangeCerts' in json or not useDefaults else False,
                certificate = json['certificate'] if 'certificate' in json or not useDefaults else "",
                adsDomain = json['adsDomain'] if 'adsDomain' in json or not useDefaults else "",
                useAnonymousBind = json['useAnonymousBind'] if 'useAnonymousBind' in json or not useDefaults else False,
                bindDN = json['bindDN'] if 'bindDN' in json or not useDefaults else "",
                bindPwd = json['bindPwd'] if 'bindPwd' in json or not useDefaults else "",
                searchBaseDN = json['searchBaseDN'] if 'searchBaseDN' in json or not useDefaults else "",
                loginNameAttr = json['loginNameAttr'] if 'loginNameAttr' in json or not useDefaults else "",
                userEntryObjClass = json['userEntryObjClass'] if 'userEntryObjClass' in json or not useDefaults else "",
                userSearchFilter = json['userSearchFilter'] if 'userSearchFilter' in json or not useDefaults else "",
                groupInfoInUserEntry = json['groupInfoInUserEntry'] if 'groupInfoInUserEntry' in json or not useDefaults else False,
                supportNestedGroups = json['supportNestedGroups'] if 'supportNestedGroups' in json or not useDefaults else False,
                groupMemberAttr = json['groupMemberAttr'] if 'groupMemberAttr' in json or not useDefaults else "",
                groupEntryObjClass = json['groupEntryObjClass'] if 'groupEntryObjClass' in json or not useDefaults else "",
                groupSearchFilter = json['groupSearchFilter'] if 'groupSearchFilter' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['server'] = str(self.server)
            json['type'] = raritan.rpc.auth.LdapManager.ServerType.encode(self.type)
            json['secProto'] = raritan.rpc.auth.LdapManager.SecurityProtocol.encode(self.secProto)
            json['port'] = self.port
            json['sslPort'] = self.sslPort
            json['forceTrustedCert'] = self.forceTrustedCert
            json['allowOffTimeRangeCerts'] = self.allowOffTimeRangeCerts
            json['certificate'] = str(self.certificate)
            json['adsDomain'] = str(self.adsDomain)
            json['useAnonymousBind'] = self.useAnonymousBind
            json['bindDN'] = str(self.bindDN)
            json['bindPwd'] = str(self.bindPwd)
            json['searchBaseDN'] = str(self.searchBaseDN)
            json['loginNameAttr'] = str(self.loginNameAttr)
            json['userEntryObjClass'] = str(self.userEntryObjClass)
            json['userSearchFilter'] = str(self.userSearchFilter)
            json['groupInfoInUserEntry'] = self.groupInfoInUserEntry
            json['supportNestedGroups'] = self.supportNestedGroups
            json['groupMemberAttr'] = str(self.groupMemberAttr)
            json['groupEntryObjClass'] = str(self.groupEntryObjClass)
            json['groupSearchFilter'] = str(self.groupSearchFilter)
            return json

    class _getLdapServers(Interface.Method):
        name = 'getLdapServers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.auth.LdapManager.ServerSettings.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.auth.LdapManager.ServerSettings, DecodeException)
            return _ret_

    ERR_CYCLIC_DEP = 1

    ERR_INVALID_CFG = 2

    class _setLdapServers(Interface.Method):
        name = 'setLdapServers'

        @staticmethod
        def encode(serverList):
            for x0 in serverList:
                typecheck.is_struct(x0, raritan.rpc.auth.LdapManager.ServerSettings, AssertionError)
            args = {}
            args['serverList'] = [raritan.rpc.auth.LdapManager.ServerSettings.encode(x0) for x0 in serverList]
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    ERR_SERVER_UNSPECIFIED = 1

    ERR_SERVER_UNREACHABLE = 3

    ERR_AUTHENTICATION_FAILED = 4

    ERR_NO_ROLES = 5

    ERR_NO_KNOWN_ROLES = 6

    class _testLdapServer(Interface.Method):
        name = 'testLdapServer'

        @staticmethod
        def encode(username, password, settings):
            if not typecheck._is_int(username):
                typecheck.is_string(username, AssertionError)
            if not typecheck._is_int(password):
                typecheck.is_string(password, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.auth.LdapManager.ServerSettings, AssertionError)
            args = {}
            args['username'] = str(username)
            args['password'] = str(password)
            args['settings'] = raritan.rpc.auth.LdapManager.ServerSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            diagMsg = rsp['diagMsg']
            typecheck.is_int(_ret_, DecodeException)
            if not typecheck._is_int(diagMsg):
                typecheck.is_string(diagMsg, DecodeException)
            return (_ret_, diagMsg)
    def __init__(self, target, agent):
        super(LdapManager, self).__init__(target, agent)
        self.getLdapServers = LdapManager._getLdapServers(self)
        self.setLdapServers = LdapManager._setLdapServers(self)
        self.testLdapServer = LdapManager._testLdapServer(self)

#
# Section generated by IdlC from "RadiusManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.auth


# interface
class RadiusManager(Interface):
    idlType = "auth.RadiusManager:4.0.0"

    # enumeration
    class AuthType(Enumeration):
        idlType = "auth.RadiusManager_4_0_0.AuthType:1.0.0"
        values = ["PAP", "CHAP", "MSCHAPv2"]

    AuthType.PAP = AuthType(0)
    AuthType.CHAP = AuthType(1)
    AuthType.MSCHAPv2 = AuthType(2)

    # structure
    class ServerSettings(Structure):
        idlType = "auth.RadiusManager_4_0_0.ServerSettings:1.0.0"
        elements = ["id", "server", "sharedSecret", "udpAuthPort", "udpAccountPort", "timeout", "retries", "authType", "disableAccounting", "messageAuthenticatorOptional"]

        def __init__(self, id="", server="", sharedSecret="", udpAuthPort=0, udpAccountPort=0, timeout=0, retries=0, authType=None, disableAccounting=False, messageAuthenticatorOptional=False):
            if authType is None:
                authType = raritan.rpc.auth.RadiusManager.AuthType.PAP
            if not typecheck._is_int(id):
                typecheck.is_string(id, AssertionError)
            if not typecheck._is_int(server):
                typecheck.is_string(server, AssertionError)
            if not typecheck._is_int(sharedSecret):
                typecheck.is_string(sharedSecret, AssertionError)
            typecheck.is_int(udpAuthPort, AssertionError)
            typecheck.is_int(udpAccountPort, AssertionError)
            typecheck.is_int(timeout, AssertionError)
            typecheck.is_int(retries, AssertionError)
            typecheck.is_enum(authType, raritan.rpc.auth.RadiusManager.AuthType, AssertionError)
            typecheck.is_bool(disableAccounting, AssertionError)
            typecheck.is_bool(messageAuthenticatorOptional, AssertionError)

            self.id = id
            self.server = server
            self.sharedSecret = sharedSecret
            self.udpAuthPort = udpAuthPort
            self.udpAccountPort = udpAccountPort
            self.timeout = timeout
            self.retries = retries
            self.authType = authType
            self.disableAccounting = disableAccounting
            self.messageAuthenticatorOptional = messageAuthenticatorOptional

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else "",
                server = json['server'] if 'server' in json or not useDefaults else "",
                sharedSecret = json['sharedSecret'] if 'sharedSecret' in json or not useDefaults else "",
                udpAuthPort = json['udpAuthPort'] if 'udpAuthPort' in json or not useDefaults else 0,
                udpAccountPort = json['udpAccountPort'] if 'udpAccountPort' in json or not useDefaults else 0,
                timeout = json['timeout'] if 'timeout' in json or not useDefaults else 0,
                retries = json['retries'] if 'retries' in json or not useDefaults else 0,
                authType = raritan.rpc.auth.RadiusManager.AuthType.decode(json['authType']) if 'authType' in json or not useDefaults else raritan.rpc.auth.RadiusManager.AuthType.PAP,
                disableAccounting = json['disableAccounting'] if 'disableAccounting' in json or not useDefaults else False,
                messageAuthenticatorOptional = json['messageAuthenticatorOptional'] if 'messageAuthenticatorOptional' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = str(self.id)
            json['server'] = str(self.server)
            json['sharedSecret'] = str(self.sharedSecret)
            json['udpAuthPort'] = self.udpAuthPort
            json['udpAccountPort'] = self.udpAccountPort
            json['timeout'] = self.timeout
            json['retries'] = self.retries
            json['authType'] = raritan.rpc.auth.RadiusManager.AuthType.encode(self.authType)
            json['disableAccounting'] = self.disableAccounting
            json['messageAuthenticatorOptional'] = self.messageAuthenticatorOptional
            return json

    ERR_INVALID_CFG = 1

    ERR_SERVER_UNSPECIFIED = 2

    ERR_INVALID_SHARED_SECRET = 3

    ERR_SERVER_UNREACHABLE = 4

    ERR_AUTHENTICATION_FAILED = 5

    ERR_NO_ROLES = 6

    ERR_NO_KNOWN_ROLES = 7

    ERR_MSG_AUTH_ATTR_MISSING = 8

    class _getRadiusServers(Interface.Method):
        name = 'getRadiusServers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.auth.RadiusManager.ServerSettings.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.auth.RadiusManager.ServerSettings, DecodeException)
            return _ret_

    class _setRadiusServers(Interface.Method):
        name = 'setRadiusServers'

        @staticmethod
        def encode(serverList):
            for x0 in serverList:
                typecheck.is_struct(x0, raritan.rpc.auth.RadiusManager.ServerSettings, AssertionError)
            args = {}
            args['serverList'] = [raritan.rpc.auth.RadiusManager.ServerSettings.encode(x0) for x0 in serverList]
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _testRadiusServer(Interface.Method):
        name = 'testRadiusServer'

        @staticmethod
        def encode(username, password, settings):
            if not typecheck._is_int(username):
                typecheck.is_string(username, AssertionError)
            if not typecheck._is_int(password):
                typecheck.is_string(password, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.auth.RadiusManager.ServerSettings, AssertionError)
            args = {}
            args['username'] = str(username)
            args['password'] = str(password)
            args['settings'] = raritan.rpc.auth.RadiusManager.ServerSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(RadiusManager, self).__init__(target, agent)
        self.getRadiusServers = RadiusManager._getRadiusServers(self)
        self.setRadiusServers = RadiusManager._setRadiusServers(self)
        self.testRadiusServer = RadiusManager._testRadiusServer(self)

#
# Section generated by IdlC from "TacPlusManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.auth


# interface
class TacPlusManager(Interface):
    idlType = "auth.TacPlusManager:1.0.1"

    # enumeration
    class AuthenType(Enumeration):
        idlType = "auth.TacPlusManager_1_0_1.AuthenType:1.0.0"
        values = ["ASCII", "PAP", "CHAP", "MSCHAP"]

    AuthenType.ASCII = AuthenType(0)
    AuthenType.PAP = AuthenType(1)
    AuthenType.CHAP = AuthenType(2)
    AuthenType.MSCHAP = AuthenType(3)

    # structure
    class ServerSettings(Structure):
        idlType = "auth.TacPlusManager_1_0_1.ServerSettings:1.0.0"
        elements = ["server", "port", "timeoutSeconds", "retries", "sharedSecret", "authenType", "disableAccounting"]

        def __init__(self, server="", port=0, timeoutSeconds=0, retries=0, sharedSecret="", authenType=None, disableAccounting=False):
            if authenType is None:
                authenType = raritan.rpc.auth.TacPlusManager.AuthenType.ASCII
            if not typecheck._is_int(server):
                typecheck.is_string(server, AssertionError)
            typecheck.is_int(port, AssertionError)
            typecheck.is_int(timeoutSeconds, AssertionError)
            typecheck.is_int(retries, AssertionError)
            if not typecheck._is_int(sharedSecret):
                typecheck.is_string(sharedSecret, AssertionError)
            typecheck.is_enum(authenType, raritan.rpc.auth.TacPlusManager.AuthenType, AssertionError)
            typecheck.is_bool(disableAccounting, AssertionError)

            self.server = server
            self.port = port
            self.timeoutSeconds = timeoutSeconds
            self.retries = retries
            self.sharedSecret = sharedSecret
            self.authenType = authenType
            self.disableAccounting = disableAccounting

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                server = json['server'] if 'server' in json or not useDefaults else "",
                port = json['port'] if 'port' in json or not useDefaults else 0,
                timeoutSeconds = json['timeoutSeconds'] if 'timeoutSeconds' in json or not useDefaults else 0,
                retries = json['retries'] if 'retries' in json or not useDefaults else 0,
                sharedSecret = json['sharedSecret'] if 'sharedSecret' in json or not useDefaults else "",
                authenType = raritan.rpc.auth.TacPlusManager.AuthenType.decode(json['authenType']) if 'authenType' in json or not useDefaults else raritan.rpc.auth.TacPlusManager.AuthenType.ASCII,
                disableAccounting = json['disableAccounting'] if 'disableAccounting' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['server'] = str(self.server)
            json['port'] = self.port
            json['timeoutSeconds'] = self.timeoutSeconds
            json['retries'] = self.retries
            json['sharedSecret'] = str(self.sharedSecret)
            json['authenType'] = raritan.rpc.auth.TacPlusManager.AuthenType.encode(self.authenType)
            json['disableAccounting'] = self.disableAccounting
            return json

    ERR_INVALID_CFG = 1

    ERR_SERVER_UNSPECIFIED = 2

    ERR_INVALID_SHARED_SECRET = 3

    ERR_SERVER_UNREACHABLE = 4

    ERR_AUTHENTICATION_FAILED = 5

    ERR_NO_ROLES = 6

    ERR_NO_KNOWN_ROLES = 7

    class _getTacPlusServers(Interface.Method):
        name = 'getTacPlusServers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.auth.TacPlusManager.ServerSettings.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.auth.TacPlusManager.ServerSettings, DecodeException)
            return _ret_

    class _setTacPlusServers(Interface.Method):
        name = 'setTacPlusServers'

        @staticmethod
        def encode(serverList):
            for x0 in serverList:
                typecheck.is_struct(x0, raritan.rpc.auth.TacPlusManager.ServerSettings, AssertionError)
            args = {}
            args['serverList'] = [raritan.rpc.auth.TacPlusManager.ServerSettings.encode(x0) for x0 in serverList]
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _testTacPlusServer(Interface.Method):
        name = 'testTacPlusServer'

        @staticmethod
        def encode(username, password, settings):
            if not typecheck._is_int(username):
                typecheck.is_string(username, AssertionError)
            if not typecheck._is_int(password):
                typecheck.is_string(password, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.auth.TacPlusManager.ServerSettings, AssertionError)
            args = {}
            args['username'] = str(username)
            args['password'] = str(password)
            args['settings'] = raritan.rpc.auth.TacPlusManager.ServerSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(TacPlusManager, self).__init__(target, agent)
        self.getTacPlusServers = TacPlusManager._getTacPlusServers(self)
        self.setTacPlusServers = TacPlusManager._setTacPlusServers(self)
        self.testTacPlusServer = TacPlusManager._testTacPlusServer(self)
