# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "ServerMonitor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.servermon


# interface
class ServerMonitor(Interface):
    idlType = "servermon.ServerMonitor:2.0.1"

    # enumeration
    class ServerReachability(Enumeration):
        idlType = "servermon.ServerMonitor_2_0_1.ServerReachability:1.0.0"
        values = ["WAITING", "REACHABLE", "UNREACHABLE", "ERROR"]

    ServerReachability.WAITING = ServerReachability(0)
    ServerReachability.REACHABLE = ServerReachability(1)
    ServerReachability.UNREACHABLE = ServerReachability(2)
    ServerReachability.ERROR = ServerReachability(3)

    # enumeration
    class ServerPowerState(Enumeration):
        idlType = "servermon.ServerMonitor_2_0_1.ServerPowerState:1.0.0"
        values = ["UNKNOWN", "ON", "OFF", "SHUTTING_DOWN"]

    ServerPowerState.UNKNOWN = ServerPowerState(0)
    ServerPowerState.ON = ServerPowerState(1)
    ServerPowerState.OFF = ServerPowerState(2)
    ServerPowerState.SHUTTING_DOWN = ServerPowerState(3)

    # enumeration
    class ServerPowerControlResult(Enumeration):
        idlType = "servermon.ServerMonitor_2_0_1.ServerPowerControlResult:1.0.0"
        values = ["NO_ERROR", "SHUTDOWN_CMD_FAILED", "SWITCHING_OFF_FAILED", "SWITCHING_ON_FAILED", "POWER_CHECK_TIMEOUT"]

    ServerPowerControlResult.NO_ERROR = ServerPowerControlResult(0)
    ServerPowerControlResult.SHUTDOWN_CMD_FAILED = ServerPowerControlResult(1)
    ServerPowerControlResult.SWITCHING_OFF_FAILED = ServerPowerControlResult(2)
    ServerPowerControlResult.SWITCHING_ON_FAILED = ServerPowerControlResult(3)
    ServerPowerControlResult.POWER_CHECK_TIMEOUT = ServerPowerControlResult(4)

    # enumeration
    class ServerPowerCheckMethod(Enumeration):
        idlType = "servermon.ServerMonitor_2_0_1.ServerPowerCheckMethod:1.0.0"
        values = ["TIMER", "POWER_DROP"]

    ServerPowerCheckMethod.TIMER = ServerPowerCheckMethod(0)
    ServerPowerCheckMethod.POWER_DROP = ServerPowerCheckMethod(1)

    # structure
    class ServerPowerSettings(Structure):
        idlType = "servermon.ServerMonitor_2_0_1.ServerPowerSettings:1.0.0"
        elements = ["enabled", "target", "powerCheck", "powerThreshold", "timeout", "shutdownCmd", "username", "password", "sshPort"]

        def __init__(self, enabled=False, target=None, powerCheck=None, powerThreshold=0.0, timeout=0, shutdownCmd="", username="", password="", sshPort=0):
            if powerCheck is None:
                powerCheck = raritan.rpc.servermon.ServerMonitor.ServerPowerCheckMethod.TIMER
            typecheck.is_bool(enabled, AssertionError)
            typecheck.is_remote_obj(target, AssertionError)
            typecheck.is_enum(powerCheck, raritan.rpc.servermon.ServerMonitor.ServerPowerCheckMethod, AssertionError)
            typecheck.is_double(powerThreshold, AssertionError)
            typecheck.is_int(timeout, AssertionError)
            if not typecheck._is_int(shutdownCmd):
                typecheck.is_string(shutdownCmd, AssertionError)
            if not typecheck._is_int(username):
                typecheck.is_string(username, AssertionError)
            if not typecheck._is_int(password):
                typecheck.is_string(password, AssertionError)
            typecheck.is_int(sshPort, AssertionError)

            self.enabled = enabled
            self.target = target
            self.powerCheck = powerCheck
            self.powerThreshold = powerThreshold
            self.timeout = timeout
            self.shutdownCmd = shutdownCmd
            self.username = username
            self.password = password
            self.sshPort = sshPort

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
                target = Interface.decode(json['target'], agent) if 'target' in json or not useDefaults else None,
                powerCheck = raritan.rpc.servermon.ServerMonitor.ServerPowerCheckMethod.decode(json['powerCheck']) if 'powerCheck' in json or not useDefaults else raritan.rpc.servermon.ServerMonitor.ServerPowerCheckMethod.TIMER,
                powerThreshold = json['powerThreshold'] if 'powerThreshold' in json or not useDefaults else 0.0,
                timeout = json['timeout'] if 'timeout' in json or not useDefaults else 0,
                shutdownCmd = json['shutdownCmd'] if 'shutdownCmd' in json or not useDefaults else "",
                username = json['username'] if 'username' in json or not useDefaults else "",
                password = json['password'] if 'password' in json or not useDefaults else "",
                sshPort = json['sshPort'] if 'sshPort' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['enabled'] = self.enabled
            json['target'] = Interface.encode(self.target)
            json['powerCheck'] = raritan.rpc.servermon.ServerMonitor.ServerPowerCheckMethod.encode(self.powerCheck)
            json['powerThreshold'] = self.powerThreshold
            json['timeout'] = self.timeout
            json['shutdownCmd'] = str(self.shutdownCmd)
            json['username'] = str(self.username)
            json['password'] = str(self.password)
            json['sshPort'] = self.sshPort
            return json

    # structure
    class ServerSettings(Structure):
        idlType = "servermon.ServerMonitor_2_0_1.ServerSettings:1.0.0"
        elements = ["host", "enabled", "pingInterval", "retryInterval", "activationCount", "failureCount", "resumeDelay", "resumeCount", "powerSettings"]

        def __init__(self, host="", enabled=False, pingInterval=0, retryInterval=0, activationCount=0, failureCount=0, resumeDelay=0, resumeCount=0, powerSettings=None):
            if powerSettings is None:
                powerSettings = raritan.rpc.servermon.ServerMonitor.ServerPowerSettings()
            if not typecheck._is_int(host):
                typecheck.is_string(host, AssertionError)
            typecheck.is_bool(enabled, AssertionError)
            typecheck.is_int(pingInterval, AssertionError)
            typecheck.is_int(retryInterval, AssertionError)
            typecheck.is_int(activationCount, AssertionError)
            typecheck.is_int(failureCount, AssertionError)
            typecheck.is_int(resumeDelay, AssertionError)
            typecheck.is_int(resumeCount, AssertionError)
            typecheck.is_struct(powerSettings, raritan.rpc.servermon.ServerMonitor.ServerPowerSettings, AssertionError)

            self.host = host
            self.enabled = enabled
            self.pingInterval = pingInterval
            self.retryInterval = retryInterval
            self.activationCount = activationCount
            self.failureCount = failureCount
            self.resumeDelay = resumeDelay
            self.resumeCount = resumeCount
            self.powerSettings = powerSettings

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                host = json['host'] if 'host' in json or not useDefaults else "",
                enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
                pingInterval = json['pingInterval'] if 'pingInterval' in json or not useDefaults else 0,
                retryInterval = json['retryInterval'] if 'retryInterval' in json or not useDefaults else 0,
                activationCount = json['activationCount'] if 'activationCount' in json or not useDefaults else 0,
                failureCount = json['failureCount'] if 'failureCount' in json or not useDefaults else 0,
                resumeDelay = json['resumeDelay'] if 'resumeDelay' in json or not useDefaults else 0,
                resumeCount = json['resumeCount'] if 'resumeCount' in json or not useDefaults else 0,
                powerSettings = raritan.rpc.servermon.ServerMonitor.ServerPowerSettings.decode(json['powerSettings'], agent, useDefaults=useDefaults) if 'powerSettings' in json or not useDefaults else raritan.rpc.servermon.ServerMonitor.ServerPowerSettings(),
            )
            return obj

        def encode(self):
            json = {}
            json['host'] = str(self.host)
            json['enabled'] = self.enabled
            json['pingInterval'] = self.pingInterval
            json['retryInterval'] = self.retryInterval
            json['activationCount'] = self.activationCount
            json['failureCount'] = self.failureCount
            json['resumeDelay'] = self.resumeDelay
            json['resumeCount'] = self.resumeCount
            json['powerSettings'] = raritan.rpc.servermon.ServerMonitor.ServerPowerSettings.encode(self.powerSettings)
            return json

    # structure
    class ServerStatus(Structure):
        idlType = "servermon.ServerMonitor_2_0_1.ServerStatus:1.0.0"
        elements = ["powerState", "lastPowerControlResult", "reachable", "lastRequest", "lastResponse", "requests", "responses", "failures", "resumes"]

        def __init__(self, powerState=None, lastPowerControlResult=None, reachable=None, lastRequest=None, lastResponse=None, requests=0, responses=0, failures=0, resumes=0):
            if powerState is None:
                powerState = raritan.rpc.servermon.ServerMonitor.ServerPowerState.UNKNOWN
            if lastPowerControlResult is None:
                lastPowerControlResult = raritan.rpc.servermon.ServerMonitor.ServerPowerControlResult.NO_ERROR
            if reachable is None:
                reachable = raritan.rpc.servermon.ServerMonitor.ServerReachability.WAITING
            typecheck.is_enum(powerState, raritan.rpc.servermon.ServerMonitor.ServerPowerState, AssertionError)
            typecheck.is_enum(lastPowerControlResult, raritan.rpc.servermon.ServerMonitor.ServerPowerControlResult, AssertionError)
            typecheck.is_enum(reachable, raritan.rpc.servermon.ServerMonitor.ServerReachability, AssertionError)
            typecheck.is_time(lastRequest, AssertionError)
            typecheck.is_time(lastResponse, AssertionError)
            typecheck.is_int(requests, AssertionError)
            typecheck.is_int(responses, AssertionError)
            typecheck.is_int(failures, AssertionError)
            typecheck.is_int(resumes, AssertionError)

            self.powerState = powerState
            self.lastPowerControlResult = lastPowerControlResult
            self.reachable = reachable
            self.lastRequest = lastRequest
            self.lastResponse = lastResponse
            self.requests = requests
            self.responses = responses
            self.failures = failures
            self.resumes = resumes

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                powerState = raritan.rpc.servermon.ServerMonitor.ServerPowerState.decode(json['powerState']) if 'powerState' in json or not useDefaults else raritan.rpc.servermon.ServerMonitor.ServerPowerState.UNKNOWN,
                lastPowerControlResult = raritan.rpc.servermon.ServerMonitor.ServerPowerControlResult.decode(json['lastPowerControlResult']) if 'lastPowerControlResult' in json or not useDefaults else raritan.rpc.servermon.ServerMonitor.ServerPowerControlResult.NO_ERROR,
                reachable = raritan.rpc.servermon.ServerMonitor.ServerReachability.decode(json['reachable']) if 'reachable' in json or not useDefaults else raritan.rpc.servermon.ServerMonitor.ServerReachability.WAITING,
                lastRequest = raritan.rpc.Time.decode(json['lastRequest']) if 'lastRequest' in json or not useDefaults else None,
                lastResponse = raritan.rpc.Time.decode(json['lastResponse']) if 'lastResponse' in json or not useDefaults else None,
                requests = json['requests'] if 'requests' in json or not useDefaults else 0,
                responses = json['responses'] if 'responses' in json or not useDefaults else 0,
                failures = json['failures'] if 'failures' in json or not useDefaults else 0,
                resumes = json['resumes'] if 'resumes' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['powerState'] = raritan.rpc.servermon.ServerMonitor.ServerPowerState.encode(self.powerState)
            json['lastPowerControlResult'] = raritan.rpc.servermon.ServerMonitor.ServerPowerControlResult.encode(self.lastPowerControlResult)
            json['reachable'] = raritan.rpc.servermon.ServerMonitor.ServerReachability.encode(self.reachable)
            json['lastRequest'] = raritan.rpc.Time.encode(self.lastRequest)
            json['lastResponse'] = raritan.rpc.Time.encode(self.lastResponse)
            json['requests'] = self.requests
            json['responses'] = self.responses
            json['failures'] = self.failures
            json['resumes'] = self.resumes
            return json

    # value object
    class ServerPowerStateEvent(raritan.rpc.idl.Event):
        idlType = "servermon.ServerMonitor_2_0_1.ServerPowerStateEvent:1.0.0"

        def __init__(self, id=0, host="", oldPowerState=None, newPowerState=None, source=None):
            super(raritan.rpc.servermon.ServerMonitor.ServerPowerStateEvent, self).__init__(source)
            if oldPowerState is None:
                oldPowerState = raritan.rpc.servermon.ServerMonitor.ServerPowerState.UNKNOWN
            if newPowerState is None:
                newPowerState = raritan.rpc.servermon.ServerMonitor.ServerPowerState.UNKNOWN
            typecheck.is_int(id, AssertionError)
            if not typecheck._is_int(host):
                typecheck.is_string(host, AssertionError)
            typecheck.is_enum(oldPowerState, raritan.rpc.servermon.ServerMonitor.ServerPowerState, AssertionError)
            typecheck.is_enum(newPowerState, raritan.rpc.servermon.ServerMonitor.ServerPowerState, AssertionError)

            self.id = id
            self.host = host
            self.oldPowerState = oldPowerState
            self.newPowerState = newPowerState

        def encode(self):
            json = super(raritan.rpc.servermon.ServerMonitor.ServerPowerStateEvent, self).encode()
            json['id'] = self.id
            json['host'] = str(self.host)
            json['oldPowerState'] = raritan.rpc.servermon.ServerMonitor.ServerPowerState.encode(self.oldPowerState)
            json['newPowerState'] = raritan.rpc.servermon.ServerMonitor.ServerPowerState.encode(self.newPowerState)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else 0,
                host = json['host'] if 'host' in json or not useDefaults else "",
                oldPowerState = raritan.rpc.servermon.ServerMonitor.ServerPowerState.decode(json['oldPowerState']) if 'oldPowerState' in json or not useDefaults else raritan.rpc.servermon.ServerMonitor.ServerPowerState.UNKNOWN,
                newPowerState = raritan.rpc.servermon.ServerMonitor.ServerPowerState.decode(json['newPowerState']) if 'newPowerState' in json or not useDefaults else raritan.rpc.servermon.ServerMonitor.ServerPowerState.UNKNOWN,
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["id", "host", "oldPowerState", "newPowerState"]
            elements = elements + super(raritan.rpc.servermon.ServerMonitor.ServerPowerStateEvent, self).listElements()
            return elements

    # value object
    class ServerPowerControlInitiatedEvent(raritan.rpc.event.UserEvent):
        idlType = "servermon.ServerMonitor_2_0_1.ServerPowerControlInitiatedEvent:1.0.0"

        def __init__(self, id=0, host="", on=False, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.servermon.ServerMonitor.ServerPowerControlInitiatedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_int(id, AssertionError)
            if not typecheck._is_int(host):
                typecheck.is_string(host, AssertionError)
            typecheck.is_bool(on, AssertionError)

            self.id = id
            self.host = host
            self.on = on

        def encode(self):
            json = super(raritan.rpc.servermon.ServerMonitor.ServerPowerControlInitiatedEvent, self).encode()
            json['id'] = self.id
            json['host'] = str(self.host)
            json['on'] = self.on
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else 0,
                host = json['host'] if 'host' in json or not useDefaults else "",
                on = json['on'] if 'on' in json or not useDefaults else False,
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["id", "host", "on"]
            elements = elements + super(raritan.rpc.servermon.ServerMonitor.ServerPowerControlInitiatedEvent, self).listElements()
            return elements

    # value object
    class ServerPowerControlCompletedEvent(raritan.rpc.idl.Event):
        idlType = "servermon.ServerMonitor_2_0_1.ServerPowerControlCompletedEvent:1.0.0"

        def __init__(self, id=0, host="", result=None, source=None):
            super(raritan.rpc.servermon.ServerMonitor.ServerPowerControlCompletedEvent, self).__init__(source)
            if result is None:
                result = raritan.rpc.servermon.ServerMonitor.ServerPowerControlResult.NO_ERROR
            typecheck.is_int(id, AssertionError)
            if not typecheck._is_int(host):
                typecheck.is_string(host, AssertionError)
            typecheck.is_enum(result, raritan.rpc.servermon.ServerMonitor.ServerPowerControlResult, AssertionError)

            self.id = id
            self.host = host
            self.result = result

        def encode(self):
            json = super(raritan.rpc.servermon.ServerMonitor.ServerPowerControlCompletedEvent, self).encode()
            json['id'] = self.id
            json['host'] = str(self.host)
            json['result'] = raritan.rpc.servermon.ServerMonitor.ServerPowerControlResult.encode(self.result)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else 0,
                host = json['host'] if 'host' in json or not useDefaults else "",
                result = raritan.rpc.servermon.ServerMonitor.ServerPowerControlResult.decode(json['result']) if 'result' in json or not useDefaults else raritan.rpc.servermon.ServerMonitor.ServerPowerControlResult.NO_ERROR,
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["id", "host", "result"]
            elements = elements + super(raritan.rpc.servermon.ServerMonitor.ServerPowerControlCompletedEvent, self).listElements()
            return elements

    # value object
    class ServerReachabilityEvent(raritan.rpc.idl.Event):
        idlType = "servermon.ServerMonitor_2_0_1.ServerReachabilityEvent:1.0.0"

        def __init__(self, id=0, host="", reachable=None, source=None):
            super(raritan.rpc.servermon.ServerMonitor.ServerReachabilityEvent, self).__init__(source)
            if reachable is None:
                reachable = raritan.rpc.servermon.ServerMonitor.ServerReachability.WAITING
            typecheck.is_int(id, AssertionError)
            if not typecheck._is_int(host):
                typecheck.is_string(host, AssertionError)
            typecheck.is_enum(reachable, raritan.rpc.servermon.ServerMonitor.ServerReachability, AssertionError)

            self.id = id
            self.host = host
            self.reachable = reachable

        def encode(self):
            json = super(raritan.rpc.servermon.ServerMonitor.ServerReachabilityEvent, self).encode()
            json['id'] = self.id
            json['host'] = str(self.host)
            json['reachable'] = raritan.rpc.servermon.ServerMonitor.ServerReachability.encode(self.reachable)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else 0,
                host = json['host'] if 'host' in json or not useDefaults else "",
                reachable = raritan.rpc.servermon.ServerMonitor.ServerReachability.decode(json['reachable']) if 'reachable' in json or not useDefaults else raritan.rpc.servermon.ServerMonitor.ServerReachability.WAITING,
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["id", "host", "reachable"]
            elements = elements + super(raritan.rpc.servermon.ServerMonitor.ServerReachabilityEvent, self).listElements()
            return elements

    # value object
    class ServerAddedEvent(raritan.rpc.event.UserEvent):
        idlType = "servermon.ServerMonitor_2_0_1.ServerAddedEvent:1.0.0"

        def __init__(self, id=0, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.servermon.ServerMonitor.ServerAddedEvent, self).__init__(actUserName, actIpAddr, source)
            if settings is None:
                settings = raritan.rpc.servermon.ServerMonitor.ServerSettings()
            typecheck.is_int(id, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.servermon.ServerMonitor.ServerSettings, AssertionError)

            self.id = id
            self.settings = settings

        def encode(self):
            json = super(raritan.rpc.servermon.ServerMonitor.ServerAddedEvent, self).encode()
            json['id'] = self.id
            json['settings'] = raritan.rpc.servermon.ServerMonitor.ServerSettings.encode(self.settings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else 0,
                settings = raritan.rpc.servermon.ServerMonitor.ServerSettings.decode(json['settings'], agent, useDefaults=useDefaults) if 'settings' in json or not useDefaults else raritan.rpc.servermon.ServerMonitor.ServerSettings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["id", "settings"]
            elements = elements + super(raritan.rpc.servermon.ServerMonitor.ServerAddedEvent, self).listElements()
            return elements

    # value object
    class ServerSettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "servermon.ServerMonitor_2_0_1.ServerSettingsChangedEvent:1.0.0"

        def __init__(self, id=0, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.servermon.ServerMonitor.ServerSettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.servermon.ServerMonitor.ServerSettings()
            if newSettings is None:
                newSettings = raritan.rpc.servermon.ServerMonitor.ServerSettings()
            typecheck.is_int(id, AssertionError)
            typecheck.is_struct(oldSettings, raritan.rpc.servermon.ServerMonitor.ServerSettings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.servermon.ServerMonitor.ServerSettings, AssertionError)

            self.id = id
            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.servermon.ServerMonitor.ServerSettingsChangedEvent, self).encode()
            json['id'] = self.id
            json['oldSettings'] = raritan.rpc.servermon.ServerMonitor.ServerSettings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.servermon.ServerMonitor.ServerSettings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else 0,
                oldSettings = raritan.rpc.servermon.ServerMonitor.ServerSettings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.servermon.ServerMonitor.ServerSettings(),
                newSettings = raritan.rpc.servermon.ServerMonitor.ServerSettings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.servermon.ServerMonitor.ServerSettings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["id", "oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.servermon.ServerMonitor.ServerSettingsChangedEvent, self).listElements()
            return elements

    # value object
    class ServerDeletedEvent(raritan.rpc.event.UserEvent):
        idlType = "servermon.ServerMonitor_2_0_1.ServerDeletedEvent:1.0.0"

        def __init__(self, id=0, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.servermon.ServerMonitor.ServerDeletedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_int(id, AssertionError)

            self.id = id

        def encode(self):
            json = super(raritan.rpc.servermon.ServerMonitor.ServerDeletedEvent, self).encode()
            json['id'] = self.id
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else 0,
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["id"]
            elements = elements + super(raritan.rpc.servermon.ServerMonitor.ServerDeletedEvent, self).listElements()
            return elements

    # structure
    class Server(Structure):
        idlType = "servermon.ServerMonitor_2_0_1.Server:1.0.0"
        elements = ["settings", "status"]

        def __init__(self, settings=None, status=None):
            if settings is None:
                settings = raritan.rpc.servermon.ServerMonitor.ServerSettings()
            if status is None:
                status = raritan.rpc.servermon.ServerMonitor.ServerStatus()
            typecheck.is_struct(settings, raritan.rpc.servermon.ServerMonitor.ServerSettings, AssertionError)
            typecheck.is_struct(status, raritan.rpc.servermon.ServerMonitor.ServerStatus, AssertionError)

            self.settings = settings
            self.status = status

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                settings = raritan.rpc.servermon.ServerMonitor.ServerSettings.decode(json['settings'], agent, useDefaults=useDefaults) if 'settings' in json or not useDefaults else raritan.rpc.servermon.ServerMonitor.ServerSettings(),
                status = raritan.rpc.servermon.ServerMonitor.ServerStatus.decode(json['status'], agent, useDefaults=useDefaults) if 'status' in json or not useDefaults else raritan.rpc.servermon.ServerMonitor.ServerStatus(),
            )
            return obj

        def encode(self):
            json = {}
            json['settings'] = raritan.rpc.servermon.ServerMonitor.ServerSettings.encode(self.settings)
            json['status'] = raritan.rpc.servermon.ServerMonitor.ServerStatus.encode(self.status)
            return json

    ERR_NO_SUCH_ID = 1

    ERR_INVALID_SETTINGS = 2

    ERR_DUPLICATE_HOSTNAME = 3

    ERR_MAX_SERVERS_REACHED = 4

    class _addServer(Interface.Method):
        name = 'addServer'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.servermon.ServerMonitor.ServerSettings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.servermon.ServerMonitor.ServerSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            id = rsp['id']
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_int(id, DecodeException)
            return (_ret_, id)

    class _modifyServer(Interface.Method):
        name = 'modifyServer'

        @staticmethod
        def encode(id, settings):
            typecheck.is_int(id, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.servermon.ServerMonitor.ServerSettings, AssertionError)
            args = {}
            args['id'] = id
            args['settings'] = raritan.rpc.servermon.ServerMonitor.ServerSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _deleteServer(Interface.Method):
        name = 'deleteServer'

        @staticmethod
        def encode(id):
            typecheck.is_int(id, AssertionError)
            args = {}
            args['id'] = id
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getServer(Interface.Method):
        name = 'getServer'

        @staticmethod
        def encode(id):
            typecheck.is_int(id, AssertionError)
            args = {}
            args['id'] = id
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            server = raritan.rpc.servermon.ServerMonitor.Server.decode(rsp['server'], agent, useDefaults=useDefaults)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_struct(server, raritan.rpc.servermon.ServerMonitor.Server, DecodeException)
            return (_ret_, server)

    class _listServers(Interface.Method):
        name = 'listServers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = dict([(
                elem['key'],
                raritan.rpc.servermon.ServerMonitor.Server.decode(elem['value'], agent, useDefaults=useDefaults))
                for elem in rsp['_ret_']])
            return _ret_

    class _powerControl(Interface.Method):
        name = 'powerControl'

        @staticmethod
        def encode(id, on):
            typecheck.is_int(id, AssertionError)
            typecheck.is_bool(on, AssertionError)
            args = {}
            args['id'] = id
            args['on'] = on
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(ServerMonitor, self).__init__(target, agent)
        self.addServer = ServerMonitor._addServer(self)
        self.modifyServer = ServerMonitor._modifyServer(self)
        self.deleteServer = ServerMonitor._deleteServer(self)
        self.getServer = ServerMonitor._getServer(self)
        self.listServers = ServerMonitor._listServers(self)
        self.powerControl = ServerMonitor._powerControl(self)
