// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from AssetStripConfig.idl.

package com.raritan.idl.assetmgrmodel;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface AssetStripConfig {
  static public final TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStripConfig:1.0.0", null);

  public enum Events {
    EVT_KEY_SETTINGS_CHANGED;
  }

  public enum ScanMode {
    SCANMODE_DISABLED,
    SCANMODE_BOTH;
  }

  public enum NumberingMode {
    TOP_DOWN,
    BOTTOM_UP;
  }

  public enum Orientation {
    TOP_CONNECTOR,
    BOTTOM_CONNECTOR;
  }

  public enum LEDOperationMode {
    LED_OPERATION_MANUAL,
    LED_OPERATION_AUTO;
  }

  public enum LEDMode {
    LED_MODE_ON,
    LED_MODE_OFF,
    LED_MODE_BLINK_FAST,
    LED_MODE_BLINK_SLOW;
  }

  static public class LEDColor implements Cloneable {
    public int r = 0;
    public int g = 0;
    public int b = 0;

    public Object clone() {
      LEDColor copy = new LEDColor();

      copy.r = this.r;
      copy.g = this.g;
      copy.b = this.b;

      return copy;
    }

  }

  static public class StripSettings implements Cloneable {
    public int rackUnitCount = 0;
    public String name = new String();
    public com.raritan.idl.assetmgrmodel.AssetStripConfig.ScanMode scanMode = com.raritan.idl.assetmgrmodel.AssetStripConfig.ScanMode.values()[0];
    public com.raritan.idl.assetmgrmodel.AssetStripConfig.LEDColor defaultColorConnected = new com.raritan.idl.assetmgrmodel.AssetStripConfig.LEDColor();
    public com.raritan.idl.assetmgrmodel.AssetStripConfig.LEDColor defaultColorDisconnected = new com.raritan.idl.assetmgrmodel.AssetStripConfig.LEDColor();
    public com.raritan.idl.assetmgrmodel.AssetStripConfig.NumberingMode numberingMode = com.raritan.idl.assetmgrmodel.AssetStripConfig.NumberingMode.values()[0];
    public int numberingOffset = 0;
    public com.raritan.idl.assetmgrmodel.AssetStripConfig.Orientation orientation = com.raritan.idl.assetmgrmodel.AssetStripConfig.Orientation.values()[0];

    public Object clone() {
      StripSettings copy = new StripSettings();

      copy.rackUnitCount = this.rackUnitCount;
      copy.name = this.name;
      copy.scanMode = this.scanMode;
      Object defaultColorConnectedCopy = this.defaultColorConnected.clone();
      copy.defaultColorConnected = (com.raritan.idl.assetmgrmodel.AssetStripConfig.LEDColor) defaultColorConnectedCopy;
      Object defaultColorDisconnectedCopy = this.defaultColorDisconnected.clone();
      copy.defaultColorDisconnected = (com.raritan.idl.assetmgrmodel.AssetStripConfig.LEDColor) defaultColorDisconnectedCopy;
      copy.numberingMode = this.numberingMode;
      copy.numberingOffset = this.numberingOffset;
      copy.orientation = this.orientation;

      return copy;
    }

  }

  static public class RackUnitSettings implements Cloneable {
    public com.raritan.idl.assetmgrmodel.AssetStripConfig.LEDOperationMode opmode = com.raritan.idl.assetmgrmodel.AssetStripConfig.LEDOperationMode.values()[0];
    public com.raritan.idl.assetmgrmodel.AssetStripConfig.LEDMode mode = com.raritan.idl.assetmgrmodel.AssetStripConfig.LEDMode.values()[0];
    public com.raritan.idl.assetmgrmodel.AssetStripConfig.LEDColor color = new com.raritan.idl.assetmgrmodel.AssetStripConfig.LEDColor();
    public String name = new String();

    public Object clone() {
      RackUnitSettings copy = new RackUnitSettings();

      copy.opmode = this.opmode;
      copy.mode = this.mode;
      Object colorCopy = this.color.clone();
      copy.color = (com.raritan.idl.assetmgrmodel.AssetStripConfig.LEDColor) colorCopy;
      copy.name = this.name;

      return copy;
    }

  }

  public class GetStripSettingsResult {
    public com.raritan.idl.assetmgrmodel.AssetStripConfig.StripSettings _ret_;
  }

  GetStripSettingsResult getStripSettings() throws Exception;

  AsyncRequest getStripSettings(AsyncRpcResponse<GetStripSettingsResult> rsp);

  AsyncRequest getStripSettings(AsyncRpcResponse<GetStripSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetStripSettingsResult {
    public int _ret_;
  }

  SetStripSettingsResult setStripSettings(com.raritan.idl.assetmgrmodel.AssetStripConfig.StripSettings settings) throws Exception;

  AsyncRequest setStripSettings(com.raritan.idl.assetmgrmodel.AssetStripConfig.StripSettings settings, AsyncRpcResponse<SetStripSettingsResult> rsp);

  AsyncRequest setStripSettings(com.raritan.idl.assetmgrmodel.AssetStripConfig.StripSettings settings, AsyncRpcResponse<SetStripSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetRackUnitSettingsResult {
    public int _ret_;
    public com.raritan.idl.assetmgrmodel.AssetStripConfig.RackUnitSettings settings;
  }

  GetRackUnitSettingsResult getRackUnitSettings(int rackUnitNumber) throws Exception;

  AsyncRequest getRackUnitSettings(int rackUnitNumber, AsyncRpcResponse<GetRackUnitSettingsResult> rsp);

  AsyncRequest getRackUnitSettings(int rackUnitNumber, AsyncRpcResponse<GetRackUnitSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetAllRackUnitSettingsResult {
    public java.util.List<com.raritan.idl.assetmgrmodel.AssetStripConfig.RackUnitSettings> _ret_;
  }

  GetAllRackUnitSettingsResult getAllRackUnitSettings() throws Exception;

  AsyncRequest getAllRackUnitSettings(AsyncRpcResponse<GetAllRackUnitSettingsResult> rsp);

  AsyncRequest getAllRackUnitSettings(AsyncRpcResponse<GetAllRackUnitSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetRackUnitSettingsResult {
    public int _ret_;
  }

  SetRackUnitSettingsResult setRackUnitSettings(int rackUnitNumber, com.raritan.idl.assetmgrmodel.AssetStripConfig.RackUnitSettings settings) throws Exception;

  AsyncRequest setRackUnitSettings(int rackUnitNumber, com.raritan.idl.assetmgrmodel.AssetStripConfig.RackUnitSettings settings, AsyncRpcResponse<SetRackUnitSettingsResult> rsp);

  AsyncRequest setRackUnitSettings(int rackUnitNumber, com.raritan.idl.assetmgrmodel.AssetStripConfig.RackUnitSettings settings, AsyncRpcResponse<SetRackUnitSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetMultipleRackUnitSettingsResult {
    public int _ret_;
  }

  SetMultipleRackUnitSettingsResult setMultipleRackUnitSettings(java.util.Map<Integer, com.raritan.idl.assetmgrmodel.AssetStripConfig.RackUnitSettings> settings) throws Exception;

  AsyncRequest setMultipleRackUnitSettings(java.util.Map<Integer, com.raritan.idl.assetmgrmodel.AssetStripConfig.RackUnitSettings> settings, AsyncRpcResponse<SetMultipleRackUnitSettingsResult> rsp);

  AsyncRequest setMultipleRackUnitSettings(java.util.Map<Integer, com.raritan.idl.assetmgrmodel.AssetStripConfig.RackUnitSettings> settings, AsyncRpcResponse<SetMultipleRackUnitSettingsResult> rsp, RpcCtrl rpcCtrl);

}
