// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from GsmModem.idl.

package com.raritan.idl.serial;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface GsmModem_1_0_1 {
  static public final TypeInfo typeInfo = new TypeInfo("serial.GsmModem:1.0.1", null);

  public static final int SUCCESS = 0;

  public static final int ERR_INVALID_VALUE = 1;

  public static final int ERR_WRONG_PIN = 2;

  public static final int ERR_SMS_SEND_FAILED = 3;

  public static final int ERR_COMMUNICATION_FAILURE = 4;

  public static final int ERR_SIM_LOCKED = 5;

  public static final int ERR_WRONG_SIM_STATUS = 6;

  public static final int ERR_WRONG_PUK = 7;

  public enum SimSecurityStatus {
    UNLOCKED,
    WAITFORPIN,
    WAITFORPUK,
    UNKNOWN;
  }

  static public class Settings implements Cloneable {
    public String pin = new String();
    public String smsc = new String();

    public Object clone() {
      Settings copy = new Settings();

      copy.pin = this.pin;
      copy.smsc = this.smsc;

      return copy;
    }

  }

  static public class Information implements Cloneable {
    public String imei = new String();
    public String imsi = new String();
    public String manufacturer = new String();
    public String model = new String();
    public String revision = new String();
    public String ownNumber = new String();
    public String simSmsc = new String();
    public String networkName = new String();
    public String serviceProviderName = new String();
    public int receptionLevel = 0;

    public Object clone() {
      Information copy = new Information();

      copy.imei = this.imei;
      copy.imsi = this.imsi;
      copy.manufacturer = this.manufacturer;
      copy.model = this.model;
      copy.revision = this.revision;
      copy.ownNumber = this.ownNumber;
      copy.simSmsc = this.simSmsc;
      copy.networkName = this.networkName;
      copy.serviceProviderName = this.serviceProviderName;
      copy.receptionLevel = this.receptionLevel;

      return copy;
    }

  }

  public class SimSecurityStatusChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("serial.GsmModem_1_0_1.SimSecurityStatusChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.serial.GsmModem_1_0_1.SimSecurityStatus newSimStatus = com.raritan.idl.serial.GsmModem_1_0_1.SimSecurityStatus.values()[0];
  }

  public class SimPinUpdatedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("serial.GsmModem_1_0_1.SimPinUpdatedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public String newPin = new String();
  }

  public class GetSettingsResult {
    public com.raritan.idl.serial.GsmModem_1_0_1.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.serial.GsmModem_1_0_1.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.serial.GsmModem_1_0_1.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.serial.GsmModem_1_0_1.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SendSmsResult {
    public int _ret_;
  }

  SendSmsResult sendSms(String recipient, String text) throws Exception;

  AsyncRequest sendSms(String recipient, String text, AsyncRpcResponse<SendSmsResult> rsp);

  AsyncRequest sendSms(String recipient, String text, AsyncRpcResponse<SendSmsResult> rsp, RpcCtrl rpcCtrl);


  public class SendTestSmsResult {
    public int _ret_;
  }

  SendTestSmsResult sendTestSms(String recipient, com.raritan.idl.serial.GsmModem_1_0_1.Settings testSettings) throws Exception;

  AsyncRequest sendTestSms(String recipient, com.raritan.idl.serial.GsmModem_1_0_1.Settings testSettings, AsyncRpcResponse<SendTestSmsResult> rsp);

  AsyncRequest sendTestSms(String recipient, com.raritan.idl.serial.GsmModem_1_0_1.Settings testSettings, AsyncRpcResponse<SendTestSmsResult> rsp, RpcCtrl rpcCtrl);


  public class GetInformationResult {
    public int _ret_;
    public com.raritan.idl.serial.GsmModem_1_0_1.Information info;
  }

  GetInformationResult getInformation() throws Exception;

  AsyncRequest getInformation(AsyncRpcResponse<GetInformationResult> rsp);

  AsyncRequest getInformation(AsyncRpcResponse<GetInformationResult> rsp, RpcCtrl rpcCtrl);


  public class GetInformationWithPinResult {
    public int _ret_;
    public com.raritan.idl.serial.GsmModem_1_0_1.Information info;
  }

  GetInformationWithPinResult getInformationWithPin(String pin) throws Exception;

  AsyncRequest getInformationWithPin(String pin, AsyncRpcResponse<GetInformationWithPinResult> rsp);

  AsyncRequest getInformationWithPin(String pin, AsyncRpcResponse<GetInformationWithPinResult> rsp, RpcCtrl rpcCtrl);


  public class GetSimSecurityStatusResult {
    public int _ret_;
    public com.raritan.idl.serial.GsmModem_1_0_1.SimSecurityStatus simStatus;
  }

  GetSimSecurityStatusResult getSimSecurityStatus() throws Exception;

  AsyncRequest getSimSecurityStatus(AsyncRpcResponse<GetSimSecurityStatusResult> rsp);

  AsyncRequest getSimSecurityStatus(AsyncRpcResponse<GetSimSecurityStatusResult> rsp, RpcCtrl rpcCtrl);


  public class UnlockSimCardResult {
    public int _ret_;
  }

  UnlockSimCardResult unlockSimCard(String puk, String newPin) throws Exception;

  AsyncRequest unlockSimCard(String puk, String newPin, AsyncRpcResponse<UnlockSimCardResult> rsp);

  AsyncRequest unlockSimCard(String puk, String newPin, AsyncRpcResponse<UnlockSimCardResult> rsp, RpcCtrl rpcCtrl);

}
