// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ServerMonitor.idl.

package com.raritan.idl.servermon;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface ServerMonitor {
  static public final TypeInfo typeInfo = new TypeInfo("servermon.ServerMonitor:1.0.0", null);

  public enum ServerReachability {
    WAITING,
    REACHABLE,
    UNREACHABLE,
    ERROR;
  }

  static public class ServerSettings implements Cloneable {
    public String host = new String();
    public boolean enabled = false;
    public int pingInterval = 0;
    public int retryInterval = 0;
    public int activationCount = 0;
    public int failureCount = 0;
    public int resumeDelay = 0;

    public Object clone() {
      ServerSettings copy = new ServerSettings();

      copy.host = this.host;
      copy.enabled = this.enabled;
      copy.pingInterval = this.pingInterval;
      copy.retryInterval = this.retryInterval;
      copy.activationCount = this.activationCount;
      copy.failureCount = this.failureCount;
      copy.resumeDelay = this.resumeDelay;

      return copy;
    }

  }

  static public class ServerStatus implements Cloneable {
    public com.raritan.idl.servermon.ServerMonitor.ServerReachability reachable = com.raritan.idl.servermon.ServerMonitor.ServerReachability.values()[0];
    public java.util.Date lastRequest = new java.util.Date();
    public java.util.Date lastResponse = new java.util.Date();
    public int requests = 0;
    public int responses = 0;
    public int failures = 0;

    public Object clone() {
      ServerStatus copy = new ServerStatus();

      copy.reachable = this.reachable;
      copy.lastRequest = this.lastRequest;
      copy.lastResponse = this.lastResponse;
      copy.requests = this.requests;
      copy.responses = this.responses;
      copy.failures = this.failures;

      return copy;
    }

  }

  static public class Server implements Cloneable {
    public com.raritan.idl.servermon.ServerMonitor.ServerSettings settings = new com.raritan.idl.servermon.ServerMonitor.ServerSettings();
    public com.raritan.idl.servermon.ServerMonitor.ServerStatus status = new com.raritan.idl.servermon.ServerMonitor.ServerStatus();

    public Object clone() {
      Server copy = new Server();

      Object settingsCopy = this.settings.clone();
      copy.settings = (com.raritan.idl.servermon.ServerMonitor.ServerSettings) settingsCopy;
      Object statusCopy = this.status.clone();
      copy.status = (com.raritan.idl.servermon.ServerMonitor.ServerStatus) statusCopy;

      return copy;
    }

  }

  public static final int MAX_SERVERS = 8;

  public static final int ERR_NO_SUCH_ID = 1;

  public static final int ERR_INVALID_SETTINGS = 2;

  public static final int ERR_DUPLICATE_HOSTNAME = 3;

  public static final int ERR_MAX_SERVERS_REACHED = 4;

  public class AddServerResult {
    public int _ret_;
    public int id;
  }

  AddServerResult addServer(com.raritan.idl.servermon.ServerMonitor.ServerSettings settings) throws Exception;

  AsyncRequest addServer(com.raritan.idl.servermon.ServerMonitor.ServerSettings settings, AsyncRpcResponse<AddServerResult> rsp);

  AsyncRequest addServer(com.raritan.idl.servermon.ServerMonitor.ServerSettings settings, AsyncRpcResponse<AddServerResult> rsp, RpcCtrl rpcCtrl);


  public class ModifyServerResult {
    public int _ret_;
  }

  ModifyServerResult modifyServer(int id, com.raritan.idl.servermon.ServerMonitor.ServerSettings settings) throws Exception;

  AsyncRequest modifyServer(int id, com.raritan.idl.servermon.ServerMonitor.ServerSettings settings, AsyncRpcResponse<ModifyServerResult> rsp);

  AsyncRequest modifyServer(int id, com.raritan.idl.servermon.ServerMonitor.ServerSettings settings, AsyncRpcResponse<ModifyServerResult> rsp, RpcCtrl rpcCtrl);


  public class DeleteServerResult {
    public int _ret_;
  }

  DeleteServerResult deleteServer(int id) throws Exception;

  AsyncRequest deleteServer(int id, AsyncRpcResponse<DeleteServerResult> rsp);

  AsyncRequest deleteServer(int id, AsyncRpcResponse<DeleteServerResult> rsp, RpcCtrl rpcCtrl);


  public class GetServerResult {
    public int _ret_;
    public com.raritan.idl.servermon.ServerMonitor.Server server;
  }

  GetServerResult getServer(int id) throws Exception;

  AsyncRequest getServer(int id, AsyncRpcResponse<GetServerResult> rsp);

  AsyncRequest getServer(int id, AsyncRpcResponse<GetServerResult> rsp, RpcCtrl rpcCtrl);


  public class ListServersResult {
    public java.util.Map<Integer, com.raritan.idl.servermon.ServerMonitor.Server> _ret_;
  }

  ListServersResult listServers() throws Exception;

  AsyncRequest listServers(AsyncRpcResponse<ListServersResult> rsp);

  AsyncRequest listServers(AsyncRpcResponse<ListServersResult> rsp, RpcCtrl rpcCtrl);

}
