// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2012 Raritan Inc. All rights reserved.

package com.raritan.json_rpc;

import org.json.JSONException;
import org.json.JSONObject;

import com.raritan.idl.TypeInfo;

public class ValueObject {

    static public final TypeInfo typeInfo = new TypeInfo("idl.ValueObject:1.0.0", null);

    /* package */ JSONObject origData;
    /* package */ TypeInfo origType;
    /* package */ Agent agent;

    public TypeInfo getTypeInfo() {
        return origType != null ? origType : getClassTypeInfo();
    }

    protected TypeInfo getClassTypeInfo() {
        return typeInfo;
    }

    @SuppressWarnings("unchecked")
    public <T extends ValueObject> T interpretAs(TypeInfo type) {
        if (origData == null) {
            return null;
        }

        ValueObjectCodec voc = ValueObjectCodec.getCodec(type);

        if (voc == null) {
            return null;
        }

        try {
            ValueObject result = voc.decodeValObj(null, origData, agent);
            if (result != null) {
                result.origData = origData;
                result.origType = origType;
                result.agent = agent;
                return (T) result;
            }
        } catch (ClassCastException e) {
        } catch (JSONException e) {
        }

        return null;
    }
}
