// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from InternalBeeper.idl.

package com.raritan.json_rpc.hmi;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class InternalBeeper_Proxy extends ObjectProxy implements com.raritan.idl.hmi.InternalBeeper {

  public InternalBeeper_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public InternalBeeper_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.hmi.InternalBeeper.typeInfo);
  }

  public static InternalBeeper_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new InternalBeeper_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public Void mute(final boolean muted) throws Exception {
    JSONObject params = new JSONObject();
    params.put("muted", muted);
    rpcCall("mute", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest mute(final boolean muted, final AsyncRpcResponse<Void> rsp) {
    return mute(muted, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest mute(final boolean muted, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("muted", muted);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("mute", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public IsMutedResult isMuted() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("isMuted", params);
    IsMutedResult ret = new IsMutedResult();
    ret._ret_ = result.getBoolean("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest isMuted(final AsyncRpcResponse<IsMutedResult> rsp) {
    return isMuted(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest isMuted(final AsyncRpcResponse<IsMutedResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("isMuted", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          IsMutedResult ret = new IsMutedResult();
          ret._ret_ = result.getBoolean("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void activate(final boolean on, final String reason, final int timeout) throws Exception {
    JSONObject params = new JSONObject();
    params.put("on", on);
    params.put("reason", reason);
    params.put("timeout", timeout);
    rpcCall("activate", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest activate(final boolean on, final String reason, final int timeout, final AsyncRpcResponse<Void> rsp) {
    return activate(on, reason, timeout, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest activate(final boolean on, final String reason, final int timeout, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("on", on);
      params.put("reason", reason);
      params.put("timeout", timeout);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("activate", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetStateResult getState() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getState", params);
    GetStateResult ret = new GetStateResult();
    ret._ret_ = com.raritan.json_rpc.hmi.InternalBeeper.State_Codec.decode(result.getInt("_ret_"));
    ret.reason = result.getString("reason");
    return ret;
  }

  @Override
  public AsyncRequest getState(final AsyncRpcResponse<GetStateResult> rsp) {
    return getState(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getState(final AsyncRpcResponse<GetStateResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getState", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetStateResult ret = new GetStateResult();
          ret._ret_ = com.raritan.json_rpc.hmi.InternalBeeper.State_Codec.decode(result.getInt("_ret_"));
          ret.reason = result.getString("reason");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
