// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PeripheralG2Production.idl.

package com.raritan.json_rpc.peripheral;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class G2Production_Proxy extends ObjectProxy implements com.raritan.idl.peripheral.G2Production {

  public G2Production_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public G2Production_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.peripheral.G2Production.typeInfo);
  }

  public static G2Production_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new G2Production_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public UpdateFirmwareResult updateFirmware(final String romcode) throws Exception {
    JSONObject params = new JSONObject();
    params.put("romcode", romcode);
    final JSONObject result = rpcCall("updateFirmware", params);
    UpdateFirmwareResult ret = new UpdateFirmwareResult();
    ret._ret_ = result.getInt("_ret_");
    ret.info = com.raritan.json_rpc.peripheral.G2Production.FirmwareInfo_Codec.decode(result.getJSONObject("info"), agent);
    return ret;
  }

  @Override
  public AsyncRequest updateFirmware(final String romcode, final AsyncRpcResponse<UpdateFirmwareResult> rsp) {
    return updateFirmware(romcode, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest updateFirmware(final String romcode, final AsyncRpcResponse<UpdateFirmwareResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("romcode", romcode);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("updateFirmware", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          UpdateFirmwareResult ret = new UpdateFirmwareResult();
          ret._ret_ = result.getInt("_ret_");
          ret.info = com.raritan.json_rpc.peripheral.G2Production.FirmwareInfo_Codec.decode(result.getJSONObject("info"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public UpdateFirmwarePosResult updateFirmwarePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position) throws Exception {
    JSONObject params = new JSONObject();
    params.put("position", new JSONArray() {{
      final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
      }
    }});
    final JSONObject result = rpcCall("updateFirmwarePos", params);
    UpdateFirmwarePosResult ret = new UpdateFirmwarePosResult();
    ret._ret_ = result.getInt("_ret_");
    ret.info = com.raritan.json_rpc.peripheral.G2Production.FirmwareInfo_Codec.decode(result.getJSONObject("info"), agent);
    return ret;
  }

  @Override
  public AsyncRequest updateFirmwarePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final AsyncRpcResponse<UpdateFirmwarePosResult> rsp) {
    return updateFirmwarePos(position, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest updateFirmwarePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final AsyncRpcResponse<UpdateFirmwarePosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("position", new JSONArray() {{
        final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("updateFirmwarePos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          UpdateFirmwarePosResult ret = new UpdateFirmwarePosResult();
          ret._ret_ = result.getInt("_ret_");
          ret.info = com.raritan.json_rpc.peripheral.G2Production.FirmwareInfo_Codec.decode(result.getJSONObject("info"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetFirmwareInfoResult getFirmwareInfo(final String romcode) throws Exception {
    JSONObject params = new JSONObject();
    params.put("romcode", romcode);
    final JSONObject result = rpcCall("getFirmwareInfo", params);
    GetFirmwareInfoResult ret = new GetFirmwareInfoResult();
    ret._ret_ = result.getInt("_ret_");
    ret.info = com.raritan.json_rpc.peripheral.G2Production.FirmwareInfo_Codec.decode(result.getJSONObject("info"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getFirmwareInfo(final String romcode, final AsyncRpcResponse<GetFirmwareInfoResult> rsp) {
    return getFirmwareInfo(romcode, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getFirmwareInfo(final String romcode, final AsyncRpcResponse<GetFirmwareInfoResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("romcode", romcode);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getFirmwareInfo", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetFirmwareInfoResult ret = new GetFirmwareInfoResult();
          ret._ret_ = result.getInt("_ret_");
          ret.info = com.raritan.json_rpc.peripheral.G2Production.FirmwareInfo_Codec.decode(result.getJSONObject("info"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetFirmwareInfoPosResult getFirmwareInfoPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position) throws Exception {
    JSONObject params = new JSONObject();
    params.put("position", new JSONArray() {{
      final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
      }
    }});
    final JSONObject result = rpcCall("getFirmwareInfoPos", params);
    GetFirmwareInfoPosResult ret = new GetFirmwareInfoPosResult();
    ret._ret_ = result.getInt("_ret_");
    ret.info = com.raritan.json_rpc.peripheral.G2Production.FirmwareInfo_Codec.decode(result.getJSONObject("info"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getFirmwareInfoPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final AsyncRpcResponse<GetFirmwareInfoPosResult> rsp) {
    return getFirmwareInfoPos(position, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getFirmwareInfoPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final AsyncRpcResponse<GetFirmwareInfoPosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("position", new JSONArray() {{
        final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getFirmwareInfoPos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetFirmwareInfoPosResult ret = new GetFirmwareInfoPosResult();
          ret._ret_ = result.getInt("_ret_");
          ret.info = com.raritan.json_rpc.peripheral.G2Production.FirmwareInfo_Codec.decode(result.getJSONObject("info"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ReadConfigurationSpaceResult readConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs) throws Exception {
    JSONObject params = new JSONObject();
    params.put("romcode", romcode);
    params.put("cs", com.raritan.json_rpc.peripheral.G2Production.ConfigurationSpace_Codec.encode(cs));
    final JSONObject result = rpcCall("readConfigurationSpace", params);
    ReadConfigurationSpaceResult ret = new ReadConfigurationSpaceResult();
    ret._ret_ = result.getInt("_ret_");
    ret.cfg = new java.util.ArrayList<Byte>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("cfg");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add((byte) array0.getInt(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest readConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, final AsyncRpcResponse<ReadConfigurationSpaceResult> rsp) {
    return readConfigurationSpace(romcode, cs, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest readConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, final AsyncRpcResponse<ReadConfigurationSpaceResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("romcode", romcode);
      params.put("cs", com.raritan.json_rpc.peripheral.G2Production.ConfigurationSpace_Codec.encode(cs));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("readConfigurationSpace", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ReadConfigurationSpaceResult ret = new ReadConfigurationSpaceResult();
          ret._ret_ = result.getInt("_ret_");
          ret.cfg = new java.util.ArrayList<Byte>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("cfg");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add((byte) array0.getInt(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ReadConfigurationSpacePosResult readConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs) throws Exception {
    JSONObject params = new JSONObject();
    params.put("position", new JSONArray() {{
      final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
      }
    }});
    params.put("cs", com.raritan.json_rpc.peripheral.G2Production.ConfigurationSpace_Codec.encode(cs));
    final JSONObject result = rpcCall("readConfigurationSpacePos", params);
    ReadConfigurationSpacePosResult ret = new ReadConfigurationSpacePosResult();
    ret._ret_ = result.getInt("_ret_");
    ret.cfg = new java.util.ArrayList<Byte>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("cfg");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add((byte) array0.getInt(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest readConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, final AsyncRpcResponse<ReadConfigurationSpacePosResult> rsp) {
    return readConfigurationSpacePos(position, cs, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest readConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, final AsyncRpcResponse<ReadConfigurationSpacePosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("position", new JSONArray() {{
        final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
        }
      }});
      params.put("cs", com.raritan.json_rpc.peripheral.G2Production.ConfigurationSpace_Codec.encode(cs));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("readConfigurationSpacePos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ReadConfigurationSpacePosResult ret = new ReadConfigurationSpacePosResult();
          ret._ret_ = result.getInt("_ret_");
          ret.cfg = new java.util.ArrayList<Byte>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("cfg");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add((byte) array0.getInt(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public WriteConfigurationSpaceResult writeConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, final java.util.List<Byte> cfg) throws Exception {
    JSONObject params = new JSONObject();
    params.put("romcode", romcode);
    params.put("cs", com.raritan.json_rpc.peripheral.G2Production.ConfigurationSpace_Codec.encode(cs));
    params.put("cfg", new JSONArray() {{
      final java.util.List<Byte> array0 = cfg;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(array0.get(i0_f));
      }
    }});
    final JSONObject result = rpcCall("writeConfigurationSpace", params);
    WriteConfigurationSpaceResult ret = new WriteConfigurationSpaceResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest writeConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, final java.util.List<Byte> cfg, final AsyncRpcResponse<WriteConfigurationSpaceResult> rsp) {
    return writeConfigurationSpace(romcode, cs, cfg, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest writeConfigurationSpace(final String romcode, final com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, final java.util.List<Byte> cfg, final AsyncRpcResponse<WriteConfigurationSpaceResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("romcode", romcode);
      params.put("cs", com.raritan.json_rpc.peripheral.G2Production.ConfigurationSpace_Codec.encode(cs));
      params.put("cfg", new JSONArray() {{
        final java.util.List<Byte> array0 = cfg;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(array0.get(i0_f));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("writeConfigurationSpace", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          WriteConfigurationSpaceResult ret = new WriteConfigurationSpaceResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public WriteConfigurationSpacePosResult writeConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, final java.util.List<Byte> cfg) throws Exception {
    JSONObject params = new JSONObject();
    params.put("position", new JSONArray() {{
      final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
      }
    }});
    params.put("cs", com.raritan.json_rpc.peripheral.G2Production.ConfigurationSpace_Codec.encode(cs));
    params.put("cfg", new JSONArray() {{
      final java.util.List<Byte> array0 = cfg;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(array0.get(i0_f));
      }
    }});
    final JSONObject result = rpcCall("writeConfigurationSpacePos", params);
    WriteConfigurationSpacePosResult ret = new WriteConfigurationSpacePosResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest writeConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, final java.util.List<Byte> cfg, final AsyncRpcResponse<WriteConfigurationSpacePosResult> rsp) {
    return writeConfigurationSpacePos(position, cs, cfg, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest writeConfigurationSpacePos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, final java.util.List<Byte> cfg, final AsyncRpcResponse<WriteConfigurationSpacePosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("position", new JSONArray() {{
        final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
        }
      }});
      params.put("cs", com.raritan.json_rpc.peripheral.G2Production.ConfigurationSpace_Codec.encode(cs));
      params.put("cfg", new JSONArray() {{
        final java.util.List<Byte> array0 = cfg;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(array0.get(i0_f));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("writeConfigurationSpacePos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          WriteConfigurationSpacePosResult ret = new WriteConfigurationSpacePosResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ResetResult reset(final String romcode, final com.raritan.idl.peripheral.G2Production.ResetMethod method) throws Exception {
    JSONObject params = new JSONObject();
    params.put("romcode", romcode);
    params.put("method", com.raritan.json_rpc.peripheral.G2Production.ResetMethod_Codec.encode(method));
    final JSONObject result = rpcCall("reset", params);
    ResetResult ret = new ResetResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest reset(final String romcode, final com.raritan.idl.peripheral.G2Production.ResetMethod method, final AsyncRpcResponse<ResetResult> rsp) {
    return reset(romcode, method, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest reset(final String romcode, final com.raritan.idl.peripheral.G2Production.ResetMethod method, final AsyncRpcResponse<ResetResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("romcode", romcode);
      params.put("method", com.raritan.json_rpc.peripheral.G2Production.ResetMethod_Codec.encode(method));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("reset", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ResetResult ret = new ResetResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ResetPosResult resetPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production.ResetMethod method) throws Exception {
    JSONObject params = new JSONObject();
    params.put("position", new JSONArray() {{
      final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
      }
    }});
    params.put("method", com.raritan.json_rpc.peripheral.G2Production.ResetMethod_Codec.encode(method));
    final JSONObject result = rpcCall("resetPos", params);
    ResetPosResult ret = new ResetPosResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest resetPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production.ResetMethod method, final AsyncRpcResponse<ResetPosResult> rsp) {
    return resetPos(position, method, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest resetPos(final java.util.List<com.raritan.idl.peripheral.PosElement> position, final com.raritan.idl.peripheral.G2Production.ResetMethod method, final AsyncRpcResponse<ResetPosResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("position", new JSONArray() {{
        final java.util.List<com.raritan.idl.peripheral.PosElement> array0 = position;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.peripheral.PosElement_Codec.encode(array0.get(i0_f)));
        }
      }});
      params.put("method", com.raritan.json_rpc.peripheral.G2Production.ResetMethod_Codec.encode(method));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("resetPos", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ResetPosResult ret = new ResetPosResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
