// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Security.idl.

package com.raritan.json_rpc.security;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class Security_Proxy extends ObjectProxy implements com.raritan.idl.security.Security {

  public Security_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public Security_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.security.Security.typeInfo);
  }

  public static Security_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new Security_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public GetSettingsResult getSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getSettings", params);
    GetSettingsResult ret = new GetSettingsResult();
    ret._ret_ = com.raritan.json_rpc.security.Security.Settings_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getSettings(final AsyncRpcResponse<GetSettingsResult> rsp) {
    return getSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSettings(final AsyncRpcResponse<GetSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSettingsResult ret = new GetSettingsResult();
          ret._ret_ = com.raritan.json_rpc.security.Security.Settings_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetSettingsResult setSettings(final com.raritan.idl.security.Security.Settings settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("settings", com.raritan.json_rpc.security.Security.Settings_Codec.encode(settings));
    final JSONObject result = rpcCall("setSettings", params);
    SetSettingsResult ret = new SetSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setSettings(final com.raritan.idl.security.Security.Settings settings, final AsyncRpcResponse<SetSettingsResult> rsp) {
    return setSettings(settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setSettings(final com.raritan.idl.security.Security.Settings settings, final AsyncRpcResponse<SetSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("settings", com.raritan.json_rpc.security.Security.Settings_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetSettingsResult ret = new SetSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void setHttpRedirSettings(final boolean http2httpsRedir) throws Exception {
    JSONObject params = new JSONObject();
    params.put("http2httpsRedir", http2httpsRedir);
    rpcCall("setHttpRedirSettings", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest setHttpRedirSettings(final boolean http2httpsRedir, final AsyncRpcResponse<Void> rsp) {
    return setHttpRedirSettings(http2httpsRedir, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setHttpRedirSettings(final boolean http2httpsRedir, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("http2httpsRedir", http2httpsRedir);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setHttpRedirSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetIpFwSettingsResult setIpFwSettings(final com.raritan.idl.security.IpFw ipFw) throws Exception {
    JSONObject params = new JSONObject();
    params.put("ipFw", com.raritan.json_rpc.security.IpFw_Codec.encode(ipFw));
    final JSONObject result = rpcCall("setIpFwSettings", params);
    SetIpFwSettingsResult ret = new SetIpFwSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setIpFwSettings(final com.raritan.idl.security.IpFw ipFw, final AsyncRpcResponse<SetIpFwSettingsResult> rsp) {
    return setIpFwSettings(ipFw, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setIpFwSettings(final com.raritan.idl.security.IpFw ipFw, final AsyncRpcResponse<SetIpFwSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("ipFw", com.raritan.json_rpc.security.IpFw_Codec.encode(ipFw));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setIpFwSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetIpFwSettingsResult ret = new SetIpFwSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetRoleAccessControlSettingsResult setRoleAccessControlSettings(final com.raritan.idl.security.RoleAccessControl settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("settings", com.raritan.json_rpc.security.RoleAccessControl_Codec.encode(settings));
    final JSONObject result = rpcCall("setRoleAccessControlSettings", params);
    SetRoleAccessControlSettingsResult ret = new SetRoleAccessControlSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setRoleAccessControlSettings(final com.raritan.idl.security.RoleAccessControl settings, final AsyncRpcResponse<SetRoleAccessControlSettingsResult> rsp) {
    return setRoleAccessControlSettings(settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setRoleAccessControlSettings(final com.raritan.idl.security.RoleAccessControl settings, final AsyncRpcResponse<SetRoleAccessControlSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("settings", com.raritan.json_rpc.security.RoleAccessControl_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setRoleAccessControlSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetRoleAccessControlSettingsResult ret = new SetRoleAccessControlSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetBlockSettingsResult setBlockSettings(final int blockTimeout, final int maxFailedLogins) throws Exception {
    JSONObject params = new JSONObject();
    params.put("blockTimeout", blockTimeout);
    params.put("maxFailedLogins", maxFailedLogins);
    final JSONObject result = rpcCall("setBlockSettings", params);
    SetBlockSettingsResult ret = new SetBlockSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setBlockSettings(final int blockTimeout, final int maxFailedLogins, final AsyncRpcResponse<SetBlockSettingsResult> rsp) {
    return setBlockSettings(blockTimeout, maxFailedLogins, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setBlockSettings(final int blockTimeout, final int maxFailedLogins, final AsyncRpcResponse<SetBlockSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("blockTimeout", blockTimeout);
      params.put("maxFailedLogins", maxFailedLogins);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setBlockSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetBlockSettingsResult ret = new SetBlockSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetPwSettingsResult setPwSettings(final com.raritan.idl.security.PasswordSettings pwSettings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("pwSettings", com.raritan.json_rpc.security.PasswordSettings_Codec.encode(pwSettings));
    final JSONObject result = rpcCall("setPwSettings", params);
    SetPwSettingsResult ret = new SetPwSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setPwSettings(final com.raritan.idl.security.PasswordSettings pwSettings, final AsyncRpcResponse<SetPwSettingsResult> rsp) {
    return setPwSettings(pwSettings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setPwSettings(final com.raritan.idl.security.PasswordSettings pwSettings, final AsyncRpcResponse<SetPwSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("pwSettings", com.raritan.json_rpc.security.PasswordSettings_Codec.encode(pwSettings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setPwSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetPwSettingsResult ret = new SetPwSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetIdleTimeoutSettingsResult setIdleTimeoutSettings(final int idleTimeout) throws Exception {
    JSONObject params = new JSONObject();
    params.put("idleTimeout", idleTimeout);
    final JSONObject result = rpcCall("setIdleTimeoutSettings", params);
    SetIdleTimeoutSettingsResult ret = new SetIdleTimeoutSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setIdleTimeoutSettings(final int idleTimeout, final AsyncRpcResponse<SetIdleTimeoutSettingsResult> rsp) {
    return setIdleTimeoutSettings(idleTimeout, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setIdleTimeoutSettings(final int idleTimeout, final AsyncRpcResponse<SetIdleTimeoutSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("idleTimeout", idleTimeout);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setIdleTimeoutSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetIdleTimeoutSettingsResult ret = new SetIdleTimeoutSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void setSingleLoginLimitation(final boolean singleLogin) throws Exception {
    JSONObject params = new JSONObject();
    params.put("singleLogin", singleLogin);
    rpcCall("setSingleLoginLimitation", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest setSingleLoginLimitation(final boolean singleLogin, final AsyncRpcResponse<Void> rsp) {
    return setSingleLoginLimitation(singleLogin, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setSingleLoginLimitation(final boolean singleLogin, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("singleLogin", singleLogin);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setSingleLoginLimitation", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetIdleTimeoutSettingsResult getIdleTimeoutSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getIdleTimeoutSettings", params);
    GetIdleTimeoutSettingsResult ret = new GetIdleTimeoutSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest getIdleTimeoutSettings(final AsyncRpcResponse<GetIdleTimeoutSettingsResult> rsp) {
    return getIdleTimeoutSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getIdleTimeoutSettings(final AsyncRpcResponse<GetIdleTimeoutSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getIdleTimeoutSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetIdleTimeoutSettingsResult ret = new GetIdleTimeoutSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetHttpRedirSettingsResult getHttpRedirSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getHttpRedirSettings", params);
    GetHttpRedirSettingsResult ret = new GetHttpRedirSettingsResult();
    ret._ret_ = result.getBoolean("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest getHttpRedirSettings(final AsyncRpcResponse<GetHttpRedirSettingsResult> rsp) {
    return getHttpRedirSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getHttpRedirSettings(final AsyncRpcResponse<GetHttpRedirSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getHttpRedirSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetHttpRedirSettingsResult ret = new GetHttpRedirSettingsResult();
          ret._ret_ = result.getBoolean("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetBlockSettingsResult getBlockSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getBlockSettings", params);
    GetBlockSettingsResult ret = new GetBlockSettingsResult();
    ret.blockTimeout = result.getInt("blockTimeout");
    ret.maxFailedLogins = result.getInt("maxFailedLogins");
    return ret;
  }

  @Override
  public AsyncRequest getBlockSettings(final AsyncRpcResponse<GetBlockSettingsResult> rsp) {
    return getBlockSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getBlockSettings(final AsyncRpcResponse<GetBlockSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getBlockSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetBlockSettingsResult ret = new GetBlockSettingsResult();
          ret.blockTimeout = result.getInt("blockTimeout");
          ret.maxFailedLogins = result.getInt("maxFailedLogins");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetSSHSettingsResult getSSHSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getSSHSettings", params);
    GetSSHSettingsResult ret = new GetSSHSettingsResult();
    ret._ret_ = com.raritan.json_rpc.security.SSHSettings_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getSSHSettings(final AsyncRpcResponse<GetSSHSettingsResult> rsp) {
    return getSSHSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSSHSettings(final AsyncRpcResponse<GetSSHSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getSSHSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSSHSettingsResult ret = new GetSSHSettingsResult();
          ret._ret_ = com.raritan.json_rpc.security.SSHSettings_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void setSSHSettings(final com.raritan.idl.security.SSHSettings settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("settings", com.raritan.json_rpc.security.SSHSettings_Codec.encode(settings));
    rpcCall("setSSHSettings", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest setSSHSettings(final com.raritan.idl.security.SSHSettings settings, final AsyncRpcResponse<Void> rsp) {
    return setSSHSettings(settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setSSHSettings(final com.raritan.idl.security.SSHSettings settings, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("settings", com.raritan.json_rpc.security.SSHSettings_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setSSHSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
